/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;

public final class VersionInfo
extends UnpackedObject
implements DbValue {
    private final LongProperty highestVersionProp = new LongProperty("nextValue", -1L);
    private final ArrayProperty<LongValue> knownVersions = new ArrayProperty("knownVersions", LongValue::new);

    public VersionInfo() {
        super(2);
        this.declareProperty((BaseProperty)this.highestVersionProp).declareProperty(this.knownVersions);
    }

    public VersionInfo(VersionInfo other) {
        this();
        this.wrap(BufferUtil.createCopy((BufferWriter)other));
    }

    public long getHighestVersion() {
        return this.highestVersionProp.getValue();
    }

    public VersionInfo setHighestVersionIfHigher(long version) {
        if (version > this.getHighestVersion()) {
            this.highestVersionProp.setValue(version);
        }
        return this;
    }

    public Long getLatestVersion() {
        List<Long> knownVersions = this.getKnownVersions();
        if (knownVersions.isEmpty()) {
            return 0L;
        }
        return knownVersions.get(knownVersions.size() - 1);
    }

    public List<Long> getKnownVersions() {
        return StreamSupport.stream(this.knownVersions.spliterator(), false).map(LongValue::getValue).sorted().toList();
    }

    public Optional<Integer> findVersionBefore(long version) {
        List<Long> knownVersions = this.getKnownVersions();
        int previousIndex = knownVersions.indexOf(version) - 1;
        if (previousIndex >= knownVersions.size() || previousIndex < 0) {
            return Optional.empty();
        }
        return Optional.of(knownVersions.get(previousIndex).intValue());
    }

    public void addKnownVersion(long version) {
        if (!this.getKnownVersions().contains(version)) {
            ((LongValue)this.knownVersions.add()).setValue(version);
            this.setHighestVersionIfHigher(version);
        }
    }

    public void removeKnownVersion(long version) {
        Iterator iterator = this.knownVersions.iterator();
        while (iterator.hasNext()) {
            if (((LongValue)iterator.next()).getValue() != version) continue;
            iterator.remove();
            break;
        }
    }
}

