/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Objects;

public final class CaCertificatesValue
extends AuthValue {
    private final String certificates;

    public CaCertificatesValue(@JsonProperty(value="certificates") String certificates) {
        this.certificates = Objects.requireNonNull(certificates, "Argument `certs` must not be null");
    }

    @JsonProperty(value="certificates")
    public String certificates() {
        return this.certificates;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.CA_CERTIFICATES;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaCertificatesValue)) {
            return false;
        }
        return this.certificates.equals(((CaCertificatesValue)o).certificates);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.certificates);
    }

    public String toString() {
        return String.format("CaCertificatesValue{\n\tcertificates=%s\n}", this.certificates);
    }
}

