/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Objects;

public final class CaCertCrlValue
extends AuthValue {
    private final String crl;

    public CaCertCrlValue(@JsonProperty(value="crl") String crl) {
        this.crl = Objects.requireNonNull(crl, "Argument `crl` must not be null");
    }

    @JsonProperty(value="crl")
    public String crl() {
        return this.crl;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.CA_CERT_CRL;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaCertCrlValue)) {
            return false;
        }
        return this.crl.equals(((CaCertCrlValue)o).crl);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.crl);
    }

    public String toString() {
        return String.format("CaCertCrlValue{\n\tcrl=%s\n}", this.crl);
    }
}

