/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

public class RefreshTokenInfoKey
extends AuthKey {
    private final String issuer;
    private final String subClaim;

    @JsonCreator
    public RefreshTokenInfoKey(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="subClaim") String subClaim) {
        this.issuer = issuer;
        this.subClaim = subClaim;
    }

    public static String cacheKey(String issuer, String subClaim) {
        return String.format("%s-%s", issuer, subClaim);
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.REFRESH_TOKEN_INFO;
    }

    @JsonProperty
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty
    public String subClaim() {
        return this.subClaim;
    }

    public String cacheKey() {
        return RefreshTokenInfoKey.cacheKey(this.issuer, this.subClaim);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefreshTokenInfoKey)) {
            return false;
        }
        RefreshTokenInfoKey that = (RefreshTokenInfoKey)o;
        return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.subClaim, that.subClaim);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.issuer, this.subClaim);
    }

    public String toString() {
        return "RefreshTokenInfoKey{issuer=" + this.issuer + ", subClaim=" + this.subClaim + "}";
    }
}

