/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Collection;
import java.util.Objects;

public class IpFilteringValue
extends AuthValue {
    private final Collection<String> ipFilteringCidrs;

    @JsonCreator
    public IpFilteringValue(@JsonProperty(value="ipFilteringCidrs") Collection<String> ipFilteringCidrs) {
        this.ipFilteringCidrs = Objects.requireNonNull(ipFilteringCidrs, "IpFilteringCidrs cannot be null");
    }

    @JsonProperty
    public Collection<String> ipFilteringCidrs() {
        return this.ipFilteringCidrs;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IP_FILTERING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IpFilteringValue that = (IpFilteringValue)o;
        return Objects.equals(this.ipFilteringCidrs, that.ipFilteringCidrs);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.ipFilteringCidrs);
    }

    public String toString() {
        return "IpFilteringValue{IpFilteringCidrs=" + String.valueOf(this.ipFilteringCidrs) + "}";
    }
}

