/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.metrics.AbstractConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.network.ClientInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInformationSensorBuilder {
    private static final String CONNECTION_INFO_NAME = "connection-info";
    private static final String UNIQUE_CLIENT_IDS_NAME = "unique-client-ids";
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionInformationSensorBuilder.class);
    private static final AbstractConnectionSensorBuilder.ConnectionMeterSensorCreator CONNECTION_INFO_SENSOR_CREATOR = new AbstractConnectionSensorBuilder.ConnectionMeterSensorCreator("connection-info", "connection-info");
    private final Metrics metrics;
    private final TenantMetrics.TenantConnectionInformationMetricsContext connectionInformationContext;
    private final TenantMetrics.TenantClientIdsMetricsContext clientIdsContext;
    private final int clientIdsPerTenantCap;

    public ConnectionInformationSensorBuilder(Metrics metrics, MultiTenantPrincipal principal, ClientInformation clientInformation, String clientId, int clientIdsPerTenantCap) {
        this.metrics = metrics;
        this.clientIdsPerTenantCap = clientIdsPerTenantCap;
        this.connectionInformationContext = new TenantMetrics.TenantConnectionInformationMetricsContext(principal, clientInformation, clientId);
        this.clientIdsContext = new TenantMetrics.TenantClientIdsMetricsContext(principal);
    }

    private String connectionInfoSensorName() {
        return CONNECTION_INFO_NAME + this.connectionInformationContext.sensorSuffix();
    }

    private String uniqueClientIdsSensorName() {
        return UNIQUE_CLIENT_IDS_NAME + this.clientIdsContext.sensorSuffix();
    }

    private Sensor lockAndGetSensor(String sensorName) {
        Sensor sensor;
        LOCK.readLock().lock();
        try {
            sensor = this.metrics.getSensor(sensorName);
        }
        finally {
            LOCK.readLock().unlock();
        }
        return sensor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor maybeBuildAndRecord() {
        String connectionInfoSensorName = this.connectionInfoSensorName();
        Sensor connectionInfoSensor = this.lockAndGetSensor(connectionInfoSensorName);
        if (connectionInfoSensor != null) {
            return this.recordConnectionInfo(connectionInfoSensor);
        }
        try {
            LOCK.writeLock().lock();
            connectionInfoSensor = this.lockAndGetSensor(connectionInfoSensorName);
            if (connectionInfoSensor != null) {
                Sensor sensor = this.recordConnectionInfo(connectionInfoSensor);
                return sensor;
            }
            String uniqueClientIdsSensorName = this.uniqueClientIdsSensorName();
            Sensor uniqueClientIdsSensor = this.lockAndGetSensor(uniqueClientIdsSensorName);
            if (uniqueClientIdsSensor == null) {
                uniqueClientIdsSensor = this.createUniqueClientIdsSensor(uniqueClientIdsSensorName);
            }
            uniqueClientIdsSensor.checkQuotas();
            uniqueClientIdsSensor.record();
            connectionInfoSensor = CONNECTION_INFO_SENSOR_CREATOR.createSensor(this.metrics, connectionInfoSensorName, this.connectionInformationContext);
        }
        catch (QuotaViolationException e) {
            LOGGER.trace("Got QuotaViolationException, not recording client-information", (Throwable)e);
            Sensor sensor = null;
            return sensor;
        }
        finally {
            LOCK.writeLock().unlock();
        }
        connectionInfoSensor.record();
        return connectionInfoSensor;
    }

    private Sensor recordConnectionInfo(Sensor connectionInfoSensor) {
        connectionInfoSensor.record();
        return connectionInfoSensor;
    }

    private Sensor createUniqueClientIdsSensor(String name) {
        LOGGER.info("Creating sensor for unique client ids: {}", (Object)name);
        LinkedHashMap<String, String> combinedTags = new LinkedHashMap<String, String>(this.metrics.config().tags());
        combinedTags.putAll(this.clientIdsContext.metricTags());
        MetricConfig metricConfig = new MetricConfig().tags(combinedTags).timeWindow(1L, TimeUnit.HOURS).quota(Quota.upperBound((double)this.clientIdsPerTenantCap));
        Sensor sensor = this.metrics.sensor(name, metricConfig, new Sensor[0]);
        MetricName metricName = this.metrics.metricName(UNIQUE_CLIENT_IDS_NAME, this.clientIdsContext.metricsGroup(), combinedTags);
        sensor.add(metricName, (MeasurableStat)new Rate(TimeUnit.HOURS));
        return sensor;
    }
}

