/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.PartitionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorBuilder;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class PartitionSensorBuilder
extends AbstractSensorBuilder<TenantMetrics.MetricsRequestContext, PartitionSensors> {
    static final long PARTITION_SENSOR_EXPIRY_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    static final String BYTES_IN = "partition-bytes-in";
    static final String BYTES_OUT = "partition-bytes-out";
    static final String RECORDS_IN = "partition-records-in";
    static final String RECORDS_OUT = "partition-records-out";

    public PartitionSensorBuilder(Metrics metrics, TenantMetrics.MetricsRequestContext context) {
        super(metrics, (MetricsBuilderContext)context);
    }

    public PartitionSensors build() {
        return new PartitionSensors((TenantMetrics.MetricsRequestContext)this.context, this.metrics, this);
    }

    protected <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> sensorCreators, T sensorKey, String sensorName) {
        return sensorCreators.get(sensorKey).createSensor(this.metrics, sensorName, PARTITION_SENSOR_EXPIRY_SECONDS);
    }

    protected String sensorSuffix(String name, TenantMetrics.MetricsRequestContext context) {
        return "";
    }

    protected Map<String, AbstractSensorCreator> sensorCreators() {
        return Collections.emptyMap();
    }
}

