/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.DeconstructedPbkdf2Hash;
import io.confluent.kafka.server.plugins.auth.PbkdfBase64;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Pbkdf2 {
    private static final int COST_MULTIPLIER = 14;
    private static final int DERIVED_KEY_SIZE = 23;

    public static boolean checkpw(String password, String hs) {
        DeconstructedPbkdf2Hash dhHash = new DeconstructedPbkdf2Hash();
        try {
            dhHash.fromHashedSecret(hs);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(password.toCharArray(), PbkdfBase64.decode(dhHash.salt(), dhHash.salt().length()), dhHash.cost() * 14, 184);
            SecretKey key = factory.generateSecret(keyspec);
            String derivedKey = PbkdfBase64.encode(key.getEncoded(), key.getEncoded().length);
            if (derivedKey.equals(dhHash.derivedKey())) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

