/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.common.DeletionEventHandler;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class UserDeletionHandlerIntegrationTest {
    static final String KEY2 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-2\",", "  \"OrgResourceId\": \"org1\",", "  \"PkcId\": \"pkc1\"", "}");
    static final String VALUE2 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"2\",", "  \"ActiveLkcIds\": [\"lkc-abc\", \"lkc-xyz\"]", "}");
    static final String KEY3 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-3\",", "  \"OrgResourceId\": \"org3\"", "}");
    static final String VALUE3 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"3\",", "  \"ActiveLkcIds\": [\"lkc-abc\", \"lkc-xyz\"]", "}");
    static final String KEY4 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-4\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE4 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"4\",", "  \"ActiveLkcIds\": [\"lkc-abc\", \"lkc-xyz\"]", "}");
    private String testTopic1 = "testTopic1";
    private final String logicalClusterId = KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId();
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private final String apiKeysTopic = "_confluent-apikey";
    private final String userMetaDataTopic = "_confluent-user_metadata";
    private int userMetadataSequenceId;
    private final String adminUserAPIkey = "APIKEY1";
    private final String adminUserAPIkeyPassword = "pwd1";
    private final String userResourceId2 = "u-2";
    private final String userId2 = "2";
    private final String userId3 = "3";
    private final String userId4 = "4";

    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        int numBrokers = 3;
        this.testHarness = new IntegrationTestHarness(testInfo, numBrokers);
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic(Arrays.asList("_confluent-apikey", "_confluent-user_metadata"), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs, "0"), this.controllerProps(topicLoadTimeoutMs, "1001"), Optional.empty());
        int adminUserId = 1;
        int serviceUserId = 2;
        this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, adminUserId, serviceUserId);
        this.loadApiKeys(this.physicalCluster, "/file_auth_test_apikeys.json", "APIKEY1");
        this.loadApiKeys(this.physicalCluster, "/service_account_apikey_2.json", "APIKEY2");
        this.loadUserMetadata();
    }

    private void loadUserMetadata() {
        this.userMetadataSequenceId = 0;
        List<String> userMetaDataKeys = Arrays.asList(KEY2, KEY3, KEY4);
        List<String> userMetaDataValues = Arrays.asList(VALUE2, VALUE3, VALUE4);
        for (int i = 0; i < userMetaDataKeys.size(); ++i) {
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, userMetaDataKeys.get(i), userMetaDataValues.get(i));
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        KafkaTestUtils.verifyThreadCleanup();
    }

    private Properties brokerProps(long topicLoadTimeoutMs, String brokerId) throws IOException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("broker.id", brokerId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties controllerProps(long topicLoadTimeoutMs, String nodeId) throws IOException {
        Properties props = new Properties();
        props.put("node.id", nodeId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties commonProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("confluent.cdc.user.metadata.enable", "true");
        props.put("confluent.cdc.user.metadata.topic", "_confluent-user_metadata");
        props.put("confluent.cdc.user.deletion.handler.enable", "true");
        props.put("confluent.multitenant.authorizer.enable.acl.state", "true");
        return props;
    }

    private void loadApiKeys(PhysicalCluster cluster, String fileName, String apiKey) throws Exception {
        BufferedInputStream path;
        try {
            path = (BufferedInputStream)JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)fileName).toURI().toURL().getContent();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = Utils.readFullyToString((InputStream)path);
        cluster.kafkaCluster().produceApiKeysData("_confluent-apikey", apiKey, apiKeys, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testSoftACLDelete(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            Metrics metrics = ((DeletionEventHandler)this.physicalCluster.kafkaCluster().kraftController().userDeletionHandler().get()).metrics();
            Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)metrics, (String)"user-deletion-event-count"), (double)0.0);
            AclBinding acl1 = this.topicAcl("u-2", this.testTopic1);
            AclBinding acl2 = this.topicAcl("2", this.testTopic1);
            adminClient.createAcls(Arrays.asList(acl1, acl2)).all().get();
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Assertions.assertEquals((Object)adminClient.describeAcls(acl1.toFilter()).values().get(), Collections.singletonList(acl1));
                Assertions.assertEquals((Object)adminClient.describeAcls(acl2.toFilter()).values().get(), Collections.singletonList(acl2));
            });
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY2, null);
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)metrics, (String)"user-deletion-event-count"), (double)1.0));
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((int)((Collection)adminClient.describeAcls(acl1.toFilter()).values().get()).size(), (int)0));
            Collection inactiveAcls1 = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)acl1.toFilter(), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            Collection inactiveAcls2 = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)acl2.toFilter(), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            Assertions.assertEquals((int)inactiveAcls1.size(), (int)1);
            Assertions.assertEquals((int)inactiveAcls2.size(), (int)1);
            Assertions.assertEquals((Object)inactiveAcls1, Collections.singletonList(acl1));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testSoftACLDeleteForMultipleUsers(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            Metrics metrics = ((DeletionEventHandler)this.physicalCluster.kafkaCluster().kraftController().userDeletionHandler().get()).metrics();
            Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)metrics, (String)"user-deletion-event-count"), (double)0.0);
            AclBinding acl1 = this.topicAcl("u-2", this.testTopic1);
            AclBinding acl2 = this.topicAcl("4", this.testTopic1);
            AclBinding acl3 = this.topicAcl("3", this.testTopic1);
            adminClient.createAcls(Arrays.asList(acl1, acl2, acl3)).all().get();
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Assertions.assertEquals((Object)adminClient.describeAcls(acl1.toFilter()).values().get(), Collections.singletonList(acl1));
                Assertions.assertEquals((Object)adminClient.describeAcls(acl2.toFilter()).values().get(), Collections.singletonList(acl2));
                Assertions.assertEquals((Object)adminClient.describeAcls(acl3.toFilter()).values().get(), Collections.singletonList(acl3));
            });
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY2, null);
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY4, null);
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((int)((Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get()).size(), (int)1));
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)metrics, (String)"user-deletion-event-count"), (double)2.0));
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY2, null);
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY2, null);
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY4, null);
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY4, null);
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((int)((Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get()).size(), (int)1));
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)metrics, (String)"user-deletion-event-count"), (double)2.0));
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY3, null);
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((int)((Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get()).size(), (int)0));
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)metrics, (String)"user-deletion-event-count"), (double)3.0));
            Collection inactiveAcls1 = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)acl1.toFilter(), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            Collection inactiveAcls2 = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)acl2.toFilter(), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            Collection inactiveAcls3 = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)acl3.toFilter(), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            Assertions.assertEquals((int)inactiveAcls1.size(), (int)1);
            Assertions.assertEquals((int)inactiveAcls2.size(), (int)1);
            Assertions.assertEquals((int)inactiveAcls3.size(), (int)1);
            Assertions.assertEquals((Object)inactiveAcls1, Collections.singletonList(acl1));
            Assertions.assertEquals((Object)inactiveAcls2, Collections.singletonList(acl2));
            Assertions.assertEquals((Object)inactiveAcls3, Collections.singletonList(acl3));
        }
    }

    private AclBinding topicAcl(String principalName, String topicName) {
        return new AclBinding(new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", principalName).toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }
}

