/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.CallingResourceIdentityType;
import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.schema.MultiTenantApis;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.security.auth.IdentityMetadata;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MultiTenantApisTest {
    private final Map<ApiKeys, Integer> maxVerifiedVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ApiKeys.PRODUCE, (Object)12), Utils.mkEntry((Object)ApiKeys.FETCH, (Object)17), Utils.mkEntry((Object)ApiKeys.LIST_OFFSETS, (Object)10), Utils.mkEntry((Object)ApiKeys.METADATA, (Object)13), Utils.mkEntry((Object)ApiKeys.OFFSET_COMMIT, (Object)9), Utils.mkEntry((Object)ApiKeys.OFFSET_FETCH, (Object)9), Utils.mkEntry((Object)ApiKeys.FIND_COORDINATOR, (Object)6), Utils.mkEntry((Object)ApiKeys.JOIN_GROUP, (Object)9), Utils.mkEntry((Object)ApiKeys.HEARTBEAT, (Object)4), Utils.mkEntry((Object)ApiKeys.LEAVE_GROUP, (Object)5), Utils.mkEntry((Object)ApiKeys.SYNC_GROUP, (Object)5), Utils.mkEntry((Object)ApiKeys.DESCRIBE_GROUPS, (Object)6), Utils.mkEntry((Object)ApiKeys.LIST_GROUPS, (Object)6), Utils.mkEntry((Object)ApiKeys.DELETE_GROUPS, (Object)2), Utils.mkEntry((Object)ApiKeys.SASL_HANDSHAKE, (Object)1), Utils.mkEntry((Object)ApiKeys.API_VERSIONS, (Object)4), Utils.mkEntry((Object)ApiKeys.CREATE_TOPICS, (Object)7), Utils.mkEntry((Object)ApiKeys.DELETE_TOPICS, (Object)6), Utils.mkEntry((Object)ApiKeys.DELETE_RECORDS, (Object)2), Utils.mkEntry((Object)ApiKeys.INIT_PRODUCER_ID, (Object)5), Utils.mkEntry((Object)ApiKeys.ADD_PARTITIONS_TO_TXN, (Object)3), Utils.mkEntry((Object)ApiKeys.ADD_OFFSETS_TO_TXN, (Object)4), Utils.mkEntry((Object)ApiKeys.END_TXN, (Object)5), Utils.mkEntry((Object)ApiKeys.TXN_OFFSET_COMMIT, (Object)5), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CONFIGS, (Object)4), Utils.mkEntry((Object)ApiKeys.ALTER_CONFIGS, (Object)2), Utils.mkEntry((Object)ApiKeys.INCREMENTAL_ALTER_CONFIGS, (Object)1), Utils.mkEntry((Object)ApiKeys.SASL_AUTHENTICATE, (Object)2), Utils.mkEntry((Object)ApiKeys.CREATE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.DESCRIBE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.DELETE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.CREATE_PARTITIONS, (Object)3), Utils.mkEntry((Object)ApiKeys.OFFSET_FOR_LEADER_EPOCH, (Object)4), Utils.mkEntry((Object)ApiKeys.REPLICA_STATUS, (Object)4), Utils.mkEntry((Object)ApiKeys.OFFSET_DELETE, (Object)0), Utils.mkEntry((Object)ApiKeys.CREATE_CLUSTER_LINKS, (Object)4), Utils.mkEntry((Object)ApiKeys.LIST_CLUSTER_LINKS, (Object)5), Utils.mkEntry((Object)ApiKeys.DELETE_CLUSTER_LINKS, (Object)2), Utils.mkEntry((Object)ApiKeys.ALTER_MIRRORS, (Object)10), Utils.mkEntry((Object)ApiKeys.LIST_MIRRORS, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_MIRRORS, (Object)10), Utils.mkEntry((Object)ApiKeys.INITIATE_REVERSE_CONNECTIONS, (Object)1), Utils.mkEntry((Object)ApiKeys.REVERSE_CONNECTION, (Object)1), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER, (Object)2), Utils.mkEntry((Object)ApiKeys.ALLOCATE_PRODUCER_IDS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER_LINKS, (Object)6), Utils.mkEntry((Object)ApiKeys.CONSUMER_GROUP_DESCRIBE, (Object)0), Utils.mkEntry((Object)ApiKeys.CONSUMER_GROUP_HEARTBEAT, (Object)1), Utils.mkEntry((Object)ApiKeys.SHARE_GROUP_DESCRIBE, (Object)0), Utils.mkEntry((Object)ApiKeys.SHARE_FETCH, (Object)0), Utils.mkEntry((Object)ApiKeys.SHARE_GROUP_HEARTBEAT, (Object)0), Utils.mkEntry((Object)ApiKeys.RESOLVE_OFFSET_RANGE, (Object)0), Utils.mkEntry((Object)ApiKeys.LIST_TRANSACTIONS, (Object)1), Utils.mkEntry((Object)ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, (Object)0), Utils.mkEntry((Object)ApiKeys.PUSH_TELEMETRY, (Object)0), Utils.mkEntry((Object)ApiKeys.SHARE_FETCH, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_SWITCHOVER_STATUS, (Object)0), Utils.mkEntry((Object)ApiKeys.CONSUMER_GROUP_DESCRIBE, (Object)1), Utils.mkEntry((Object)ApiKeys.SHARE_ACKNOWLEDGE, (Object)0)});
    private final Map<ApiKeys, Integer> maxVerifiedSbcApiVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ApiKeys.REMOVE_BROKERS, (Object)1), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BROKER_REMOVALS, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BROKER_ADDITIONS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BALANCER_STATUS, (Object)1), Utils.mkEntry((Object)ApiKeys.TRIGGER_EVEN_CLUSTER_LOAD, (Object)1), Utils.mkEntry((Object)ApiKeys.COMPUTE_EVEN_CLUSTER_LOAD_PLAN, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_EVEN_CLUSTER_LOAD_STATUS, (Object)1), Utils.mkEntry((Object)ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BROKER_REPLICA_EXCLUSIONS, (Object)0)});
    private final Set<ApiKeys> clusterLinkUpdateApis = Set.of(ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.DELETE_CLUSTER_LINKS, ApiKeys.ALTER_MIRRORS);
    private final Set<ApiKeys> internalListenerApis = Set.of(ApiKeys.RESOLVE_OFFSET_RANGE);

    @ParameterizedTest
    @MethodSource(value={"principalProvider"})
    public void testAllBrokerApiKeysAreAccountedFor(MultiTenantPrincipal principal) {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        MultiTenantApis multiTenantApis = new MultiTenantApis(false);
        for (ApiKeys api : ApiKeys.brokerApis()) {
            Iterator iterator = api.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    multiTenantApis.isApiAllowed(api, version, principal);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(api);
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following APIs are not handled: " + String.valueOf(unhandledApis)));
    }

    @ParameterizedTest
    @MethodSource(value={"principalProvider"})
    public void testIsApiAllowedHandlesAllApiVersions(MultiTenantPrincipal principal) {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> unverifiedVersionApis = new HashSet<ApiKeys>();
        HashMap<ApiKeys, Integer> maxVersions = new HashMap<ApiKeys, Integer>(this.maxVerifiedVersions);
        for (boolean sbcApisEnabled : Arrays.asList(true, false)) {
            if (sbcApisEnabled) {
                maxVersions.putAll(this.maxVerifiedSbcApiVersions);
            }
            MultiTenantApis multiTenantApis = new MultiTenantApis(sbcApisEnabled);
            for (ApiKeys api : ApiKeys.brokerApis()) {
                Iterator iterator = api.allVersions().iterator();
                while (iterator.hasNext()) {
                    short version = (Short)iterator.next();
                    try {
                        Optional<Integer> maxValidatedVersion;
                        if (!multiTenantApis.isApiAllowed(api, version, principal) || (maxValidatedVersion = Optional.ofNullable((Integer)maxVersions.get(api))).isPresent() && version <= maxValidatedVersion.get()) continue;
                        unverifiedVersionApis.add(api);
                    }
                    catch (IllegalArgumentException e) {
                        unhandledApis.add(api);
                    }
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following APIs are not handled: " + String.valueOf(unhandledApis)));
        Assertions.assertEquals(Collections.emptySet(), unverifiedVersionApis, (String)("The following exposed APIs have unverified version bumps: " + String.valueOf(unhandledApis)));
    }

    @ParameterizedTest
    @MethodSource(value={"principalProvider"})
    public void testSbcApisAreDisabledByDefault(MultiTenantPrincipal principal) {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> allowedApis = new HashSet<ApiKeys>();
        Properties props = new Properties();
        props.put("process.roles", "broker");
        props.put("broker.id", "1");
        props.put("controller.quorum.bootstrap.servers", "localhost:9095");
        props.put("controller.listener.names", "CONTROLLER");
        props.put("listeners", "PLAINTEXT://localhost:9092");
        MultiTenantInterceptorConfig config = MultiTenantInterceptorConfig.fromConfigMap((Map)new KafkaConfig((Map)props).valuesFromThisConfig());
        MultiTenantApis multiTenantApis = new MultiTenantApis(config.sbcApisEnabled());
        for (ApiKeys sbcApi : this.maxVerifiedSbcApiVersions.keySet()) {
            Iterator iterator = sbcApi.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    boolean isAllowed = multiTenantApis.isApiAllowed(sbcApi, version, principal);
                    if (!isAllowed) continue;
                    allowedApis.add(sbcApi);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(sbcApi);
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following SBC APIs are not handled: " + String.valueOf(unhandledApis)));
        Assertions.assertEquals(Collections.emptySet(), allowedApis, (String)("The following SBC APIs were exposed when they shouldn't have been: " + String.valueOf(allowedApis)));
    }

    @ParameterizedTest
    @MethodSource(value={"principalProvider"})
    public void testSbcApisAreAllowedWhenEnabled(MultiTenantPrincipal principal) {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> notAllowed = new HashSet<ApiKeys>();
        Properties props = new Properties();
        props.put("process.roles", "broker");
        props.put("broker.id", "1");
        props.put("controller.quorum.bootstrap.servers", "localhost:9095");
        props.put("controller.listener.names", "CONTROLLER");
        props.put("listeners", "PLAINTEXT://localhost:9092");
        props.put("confluent.multitenant.interceptor.balancer.apis.enabled", "true");
        MultiTenantInterceptorConfig config = MultiTenantInterceptorConfig.fromConfigMap((Map)new KafkaConfig((Map)props).valuesFromThisConfig());
        MultiTenantApis multiTenantApis = new MultiTenantApis(config.sbcApisEnabled());
        for (ApiKeys sbcApi : this.maxVerifiedSbcApiVersions.keySet()) {
            Iterator iterator = sbcApi.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    boolean isAllowed = multiTenantApis.isApiAllowed(sbcApi, version, principal);
                    if (isAllowed) continue;
                    notAllowed.add(sbcApi);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(sbcApi);
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following SBC APIs are not handled: " + String.valueOf(unhandledApis)));
        Assertions.assertEquals(Collections.emptySet(), notAllowed, (String)("The following SBC APIs were not exposed when they should have been: " + String.valueOf(notAllowed)));
    }

    @ParameterizedTest
    @MethodSource(value={"principalProvider"})
    public void testClusterLinkUpdates(MultiTenantPrincipal principal) {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> notAllowedApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> allowedApis = new HashSet<ApiKeys>();
        MultiTenantApis multiTenantApis = new MultiTenantApis(false);
        for (ApiKeys api : this.clusterLinkUpdateApis) {
            Iterator iterator = api.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    if (multiTenantApis.isApiAllowed(api, version, principal)) continue;
                    notAllowedApis.add(api);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(api);
                }
            }
            if (notAllowedApis.contains(api)) continue;
            allowedApis.add(api);
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis);
        Assertions.assertEquals(Collections.emptySet(), notAllowedApis);
        Assertions.assertEquals(this.clusterLinkUpdateApis, allowedApis);
    }

    @ParameterizedTest
    @MethodSource(value={"principalProvider"})
    public void testApisAllowedBasedOnListener(MultiTenantPrincipal principal) {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> notAllowedApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> allowedApis = new HashSet<ApiKeys>();
        MultiTenantApis multiTenantApis = new MultiTenantApis(false);
        for (ApiKeys api : this.internalListenerApis) {
            Iterator iterator = api.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    if (multiTenantApis.isApiAllowed(api, version, principal)) continue;
                    notAllowedApis.add(api);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(api);
                }
            }
            if (notAllowedApis.contains(api)) continue;
            allowedApis.add(api);
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis);
        if (principal.maybeGetIdentityMetadata().isEmpty() || ((IdentityMetadata)principal.maybeGetIdentityMetadata().get()).callingResourceIdentityType() == CallingResourceIdentityType.DEFAULT) {
            Assertions.assertEquals(this.internalListenerApis, notAllowedApis);
            Assertions.assertEquals(Collections.emptySet(), allowedApis);
        } else {
            Assertions.assertEquals(Collections.emptySet(), notAllowedApis);
            Assertions.assertEquals(this.internalListenerApis, allowedApis);
        }
    }

    private static Stream<MultiTenantPrincipal> principalProvider() {
        return MultiTenantApisTest.identityMetadataProvider().map(metadata -> new MultiTenantPrincipal("username", new TenantMetadata("tenant", "lkc-foo"), metadata));
    }

    private static Stream<IdentityMetadata> identityMetadataProvider() {
        Stream<IdentityMetadata> applicationIdentities = Arrays.stream(CallingResourceIdentityType.values()).map(type -> new IdentityMetadata.Builder().callingResourceIdentityType(type).build());
        Stream<IdentityMetadata> emptyIdentity = Stream.of(new IdentityMetadata.Builder().build());
        return Stream.concat(applicationIdentities, emptyIdentity);
    }
}

