/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JSONUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T readJSON(InputStream is, Class<T> clazz) throws IOException {
        if (clazz == String.class) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JSONUtil.copy(is, baos);
            return clazz.cast(new String(baos.toByteArray(), StandardCharsets.UTF_8));
        }
        return (T)MAPPER.readValue(is, clazz);
    }

    public static JsonNode asJson(Object value) {
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        try {
            return (JsonNode)MAPPER.convertValue(value, JsonNode.class);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Failed to convert value to JSON (" + String.valueOf(value) + ")", e);
        }
    }

    public static String getClaimFromJWT(String claim, Object token) {
        JsonNode node = JSONUtil.asJson(token);
        return JSONUtil.getClaimFromJWT(node, claim.split("\\."));
    }

    public static String getClaimFromJWT(JsonNode node, String ... path) {
        if (path.length == 0) {
            return null;
        }
        for (String p : path) {
            if ((node = node.get(p)) != null) continue;
            return null;
        }
        return node.asText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        try {
            int rc;
            while ((rc = input.read(buf)) != -1) {
                output.write(buf, 0, rc);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }
}

