/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignor;
import java.util.Map;
import java.util.Optional;
import kafka.assignor.TopicReplicaAssignor;
import kafka.assignor.TopicReplicaAssignorBuilder;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantPartitionAssignorBuilder
implements TopicReplicaAssignorBuilder {
    private final Logger logger = LoggerFactory.getLogger(TenantPartitionAssignorBuilder.class);
    private volatile ClusterDescriber cluster = null;
    private boolean failUnsatisfiedPlacementConstraints;

    public void configure(Map<String, ?> configs) {
        if (configs.containsKey("confluent.fail.unsatisfied.placement.constraints")) {
            this.failUnsatisfiedPlacementConstraints = (Boolean)configs.get("confluent.fail.unsatisfied.placement.constraints");
        }
    }

    public TenantPartitionAssignorBuilder() {
        this.failUnsatisfiedPlacementConstraints = false;
    }

    @VisibleForTesting
    TenantPartitionAssignorBuilder(boolean failUnsatisfiedPlacementConstraints) {
        this.failUnsatisfiedPlacementConstraints = failUnsatisfiedPlacementConstraints;
    }

    public Optional<TopicReplicaAssignor> maybeBuildAssignor(Optional<KafkaPrincipal> principalOpt, PartitionPlacementStrategy targetPlacementStrategy) {
        String tenantName = "";
        KafkaPrincipal principal = principalOpt.orElse(null);
        boolean isMultitenantPrincipal = principal instanceof MultiTenantPrincipal;
        if (!isMultitenantPrincipal && targetPlacementStrategy != PartitionPlacementStrategy.PARTITION_IN_CELL) {
            this.logger.debug("The {} only supports principals of type {} but was given {}", new Object[]{TenantPartitionAssignor.class.getSimpleName(), MultiTenantPrincipal.class.getSimpleName(), principal == null ? "<null>" : principal.getClass().getSimpleName()});
            return Optional.empty();
        }
        if (isMultitenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            tenantName = multiTenantPrincipal.tenantMetadata().tenantName;
        }
        try {
            TenantPartitionAssignor assignor = new TenantPartitionAssignor(this.cluster, tenantName, targetPlacementStrategy, this.failUnsatisfiedPlacementConstraints);
            return Optional.of(assignor);
        }
        catch (Exception e) {
            this.logger.error("Exception while building TenantPartitionAssignor with principal {}", (Object)principal);
            return Optional.empty();
        }
    }

    public void updateClusterDescriber(ClusterDescriber cluster) {
        this.cluster = cluster;
    }
}

