/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.multitenant.MultiTenantConfigRestrictions;
import io.confluent.kafka.server.plugins.policy.AbstractPolicyConfig;
import io.confluent.kafka.server.plugins.policy.PolicyUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.PolicyViolationException;

public class TopicPolicyConfig
extends AbstractPolicyConfig {
    public static final String BASE_PREFIX = "confluent.plugins.";
    public static final String TOPIC_PREFIX = "confluent.plugins.topic.policy.";
    public static final String SEGMENT_BYTES_MIN_CONFIG = "confluent.plugins.topic.policy.segment.bytes.min";
    public static final int DEFAULT_SEGMENT_BYTES_MIN = 0x3200000;
    protected static final String SEGMENT_BYTES_MIN_CONFIG_DOC = "The minimum allowed value for the segment.bytes topic config property.";
    public static final String SEGMENT_BYTES_MAX_CONFIG = "confluent.plugins.topic.policy.segment.bytes.max";
    public static final int DEFAULT_SEGMENT_BYTES_MAX = 0x40000000;
    protected static final String SEGMENT_BYTES_MAX_CONFIG_DOC = "The maximum allowed value for the segment.bytes topic config property.";
    public static final String SEGMENT_MS_MIN_CONFIG = "confluent.plugins.topic.policy.segment.ms.min";
    public static final int DEFAULT_SEGMENT_MS_MIN = 600000;
    protected static final String SEGMENT_MS_MIN_CONFIG_DOC = "The minimum allowed value for the segment.ms topic config property.";
    public static final String RETENTION_MS_MAX_CONFIG = "confluent.plugins.topic.policy.retention.ms.max";
    public static final long DEFAULT_RETENTION_MS_MAX = Long.MAX_VALUE;
    protected static final String RETENTION_MS_MAX_CONFIG_DOC = "The maximum allowed value for the retention.ms topic config property.";
    public static final String DELETE_RETENTION_MS_MAX_CONFIG = "confluent.plugins.topic.policy.delete.retention.ms.max";
    public static final long DEFAULT_DELETE_RETENTION_MS_MAX = 60566400000L;
    protected static final String DELETE_RETENTION_MS_MAX_CONFIG_DOC = "The maximum allowed value for the delete.retention.ms topic config property.";
    public static final String MAX_MESSAGE_BYTES_MAX_CONFIG = "confluent.plugins.topic.policy.max.message.bytes.max";
    public static final int DEFAULT_MAX_MESSAGE_BYTES_MAX = 0x800000;
    protected static final String MAX_MESSAGE_BYTES_MAX_CONFIG_DOC = "The maximum allowed value for the max.message.bytes topic config property.";
    public static final String REPLICATION_FACTOR_CONFIG = "confluent.plugins.topic.policy.replication.factor";
    protected static final String REPLICATION_FACTOR_DOC = "The required replication factor for all topics if set.";
    public static final String MAX_REPLICAS_PER_BROKER_CONFIG = "confluent.plugins.topic.policy.max.replicas.per.broker";
    public static final int DEFAULT_MAX_REPLICAS_PER_BROKER = Integer.MAX_VALUE;
    protected static final String MAX_REPLICAS_PER_BROKER_DOC = "The maximum replicas per broker.";
    public static final String MAX_PARTITIONS_PER_TENANT_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.tenant";
    public static final int DEFAULT_MAX_PARTITIONS_PER_TENANT = 512;
    protected static final String MAX_PARTITIONS_PER_TENANT_CONFIG_DOC = "The maximum partitions per tenant.";
    public static final String MAX_PARTITIONS_PER_CLUSTER_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.cluster";
    public static final int DEFAULT_MAX_PARTITIONS_PER_CLUSTER = Integer.MAX_VALUE;
    protected static final String MAX_PARTITIONS_PER_CLUSTER_CONFIG_DOC = "The maximum partitions per physical cluster.";
    public static final String MAX_TOPICS_PER_CLUSTER_CONFIG = "confluent.plugins.topic.policy.max.topics.per.cluster";
    public static final int DEFAULT_MAX_TOPICS_PER_CLUSTER = Integer.MAX_VALUE;
    protected static final String MAX_TOPICS_PER_CLUSTER_CONFIG_DOC = "The maximum topics per physical cluster.";
    public static final String INTERNAL_LISTENER_CONFIG = "confluent.plugins.topic.policy.internal.listener";
    public static final String DEFAULT_INTERNAL_LISTENER = "INTERNAL";
    protected static final String INTERNAL_LISTENER_CONFIG_DOC = "Internal listener to get bootstrap broker for AdminClient.";
    public static final String MAX_COMPACTION_LAG_MS_MIN_CONFIG = "confluent.plugins.topic.policy.max.compaction.lag.ms.min";
    public static final long DEFAULT_MAX_COMPACTION_LAG_MS_MIN = TimeUnit.DAYS.toMillis(7L);
    private static final String MAX_COMPACTION_LAG_MS_MIN_DOC = "The lower-bound for topic config max.compaction.lag.ms";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_CONFIG = "confluent.schema.validator.multitenant.enable";
    public static final boolean MULTITENANT_SCHEMA_VALIDATION_ENABLED_DEFAULT = false;
    private static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_DOC = "Controls enablement of the schema validation plugin in the cloud";
    public static final String MULTITENANT_MAX_PARTITIONS_PER_REQUEST_CONFIG = "confluent.multitenant.max.partitions.per.request";
    public static final String MULTITENANT_MAX_PARTITIONS_PER_REQUEST_DOC = "Maximum number of partitions within a single new topic/partition creation. This setting is enforced by the TenantPartitionAssignor.";
    public static final int MULTITENANT_MAX_PARTITIONS_PER_REQUEST_DEFAULT = Integer.MAX_VALUE;
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.plugins.topic.policy.replication.factor", ConfigDef.Type.SHORT, ConfigDef.Importance.HIGH, "The required replication factor for all topics if set.").define("confluent.plugins.topic.policy.max.message.bytes.max", ConfigDef.Type.INT, (Object)0x800000, ConfigDef.Importance.HIGH, "The maximum allowed value for the max.message.bytes topic config property.").define("confluent.plugins.topic.policy.segment.bytes.min", ConfigDef.Type.INT, (Object)0x3200000, ConfigDef.Importance.MEDIUM, "The minimum allowed value for the segment.bytes topic config property.").define("confluent.plugins.topic.policy.segment.bytes.max", ConfigDef.Type.INT, (Object)0x40000000, ConfigDef.Importance.MEDIUM, "The maximum allowed value for the segment.bytes topic config property.").define("confluent.plugins.topic.policy.segment.ms.min", ConfigDef.Type.INT, (Object)600000, ConfigDef.Importance.MEDIUM, "The minimum allowed value for the segment.ms topic config property.").define("confluent.plugins.topic.policy.delete.retention.ms.max", ConfigDef.Type.LONG, (Object)60566400000L, ConfigDef.Importance.MEDIUM, "The maximum allowed value for the delete.retention.ms topic config property.").define("confluent.plugins.topic.policy.retention.ms.max", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, ConfigDef.Importance.MEDIUM, "The maximum allowed value for the retention.ms topic config property.").define("confluent.plugins.topic.policy.max.replicas.per.broker", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.HIGH, "The maximum replicas per broker.").define("confluent.plugins.topic.policy.max.partitions.per.tenant", ConfigDef.Type.INT, (Object)512, ConfigDef.Importance.HIGH, "The maximum partitions per tenant.").define("confluent.plugins.topic.policy.max.partitions.per.cluster", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.HIGH, "The maximum partitions per physical cluster.").define("confluent.plugins.topic.policy.max.topics.per.cluster", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.HIGH, "The maximum topics per physical cluster.").define("confluent.plugins.topic.policy.internal.listener", ConfigDef.Type.STRING, (Object)"INTERNAL", ConfigDef.Importance.HIGH, "Internal listener to get bootstrap broker for AdminClient.").define("confluent.plugins.topic.policy.max.compaction.lag.ms.min", ConfigDef.Type.LONG, (Object)DEFAULT_MAX_COMPACTION_LAG_MS_MIN, ConfigDef.Importance.MEDIUM, "The lower-bound for topic config max.compaction.lag.ms").define("confluent.schema.validator.multitenant.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Controls enablement of the schema validation plugin in the cloud").define("confluent.multitenant.max.partitions.per.request", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "Maximum number of partitions within a single new topic/partition creation. This setting is enforced by the TenantPartitionAssignor.");
    public static final short MIN_ISR = 1;
    private short requiredRepFactor = this.getShort("confluent.plugins.topic.policy.replication.factor");
    private boolean schemaValidationEnabled = this.getBoolean("confluent.schema.validator.multitenant.enable");

    public TopicPolicyConfig(Map<String, ?> clientConfigs) {
        super(CONFIG, clientConfigs);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    void validateConfigsAreInRange(Map<String, String> configs, TopicType topicType) {
        int passedMinIsr;
        this.checkPolicyMax(configs, MAX_MESSAGE_BYTES_MAX_CONFIG, "max.message.bytes", 0x10000CL);
        this.checkPolicyMax(configs, DELETE_RETENTION_MS_MAX_CONFIG, "delete.retention.ms", 86400000L);
        this.checkPolicyMax(configs, RETENTION_MS_MAX_CONFIG, "retention.ms", 604800000L);
        this.checkPolicyMax(configs, SEGMENT_BYTES_MAX_CONFIG, "segment.bytes", 0x40000000L);
        this.checkPolicyMin(configs, SEGMENT_BYTES_MIN_CONFIG, "segment.bytes", 0x40000000L);
        this.checkPolicyMin(configs, SEGMENT_MS_MIN_CONFIG, "segment.ms", 604800000L);
        this.checkPolicyMin(configs, MAX_COMPACTION_LAG_MS_MIN_CONFIG, "max.compaction.lag.ms", Long.MAX_VALUE);
        if (configs.get("min.insync.replicas") != null && ((passedMinIsr = Integer.parseInt(configs.get("min.insync.replicas"))) < 1 || passedMinIsr >= this.requiredRepFactor)) {
            throw new PolicyViolationException(String.format("Config property '%s' with value '%d' must be greater or equal to %d and less than %d, or left empty.", "min.insync.replicas", passedMinIsr, (short)1, this.requiredRepFactor));
        }
        if (topicType == TopicType.FREIGHT) {
            configs.forEach((configName, configValue) -> {
                if ("confluent.topic.type".equals(configName) && !org.apache.kafka.metadata.TopicType.FREIGHT.logConfigValue().equals(configValue)) {
                    throw new PolicyViolationException("The config '" + configName + "' does not support the value '" + configValue + "' with Freight topics");
                }
                if ("cleanup.policy".equals(configName) && !"delete".equals(configValue)) {
                    throw new PolicyViolationException("The config '" + configName + "' does not support the value '" + configValue + "' with Freight topics");
                }
            });
        }
    }

    public void validateTopicConfigs(Map<String, String> configs) {
        this.validateTopicConfigs(configs, TopicType.STANDARD);
    }

    public void validateTopicConfigs(Map<String, String> configs, TopicType topicType) {
        if (configs == null) {
            return;
        }
        if (topicType == TopicType.FREIGHT) {
            PolicyUtils.validateConfigsAreUpdatable(configs, configName -> MultiTenantConfigRestrictions.updatableFreightTopicConfig(configName));
        } else {
            PolicyUtils.validateConfigsAreUpdatable(configs, configName -> MultiTenantConfigRestrictions.updatableTopicConfig(configName, this.schemaValidationEnabled));
        }
        this.validateConfigsAreInRange(configs, topicType);
    }

    public Map<String, String> restrictTopicConfigs(Map<String, String> configs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            String key = entry.getKey();
            if (!MultiTenantConfigRestrictions.updatableTopicConfig(key, this.schemaValidationEnabled)) continue;
            result.put(key, entry.getValue());
        }
        this.clampPolicy(result, "max.message.bytes", Optional.empty(), Optional.of(MAX_MESSAGE_BYTES_MAX_CONFIG));
        this.clampPolicy(result, "delete.retention.ms", Optional.empty(), Optional.of(DELETE_RETENTION_MS_MAX_CONFIG));
        this.clampPolicy(result, "retention.ms", Optional.empty(), Optional.of(RETENTION_MS_MAX_CONFIG));
        this.clampPolicy(result, "segment.bytes", Optional.of(SEGMENT_BYTES_MIN_CONFIG), Optional.of(SEGMENT_BYTES_MAX_CONFIG));
        this.clampPolicy(result, "segment.ms", Optional.of(SEGMENT_MS_MIN_CONFIG), Optional.empty());
        this.clampPolicy(result, "max.compaction.lag.ms", Optional.of(MAX_COMPACTION_LAG_MS_MIN_CONFIG), Optional.empty());
        if (result.containsKey("min.insync.replicas")) {
            int value = Integer.parseInt(configs.get("min.insync.replicas"));
            value = Math.max(value, 1);
            value = Math.min(value, this.requiredRepFactor - 1);
            result.put("min.insync.replicas", String.valueOf(value));
        }
        return result;
    }

    private void clampPolicy(Map<String, String> configs, String configProperty, Optional<String> minPolicyConfigProperty, Optional<String> maxPolicyConfigProperty) {
        if (configs.containsKey(configProperty)) {
            long value = Long.parseLong(configs.get(configProperty));
            if (minPolicyConfigProperty.isPresent()) {
                value = Math.max(value, this.parseLong(minPolicyConfigProperty.get()));
            }
            if (maxPolicyConfigProperty.isPresent()) {
                value = Math.min(value, this.parseLong(maxPolicyConfigProperty.get()));
            }
            configs.put(configProperty, String.valueOf(value));
        }
    }
}

