/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.Exit;

public class RestoreAclsForUser {
    public static void main(String[] args) {
        if (args.length == 1 && (args[0].equals("--h") || args[0].equals("--help"))) {
            System.out.println("Pass BOOTSTRAP_SERVER_CONFIG as first argument\nPass UserResourceId as second argument\nPass UserId as third argument\nPass List of lkc-ids as other arguments");
            Exit.exit((int)0);
        }
        if (args.length < 4) {
            System.out.println("Pass atleast 4 arguments. Bootstrap, principal, and lkc-id/s");
            Exit.exit((int)0);
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", args[0]);
        String userResourceId = args[1];
        String userId = args[2];
        ArrayList<String> lkcIdsForUserResourceID = new ArrayList<String>(Arrays.asList(args).subList(3, args.length));
        lkcIdsForUserResourceID.replaceAll(lkcId -> lkcId + "_" + userResourceId);
        ArrayList<String> userRIdsWithPrefix = new ArrayList<String>(lkcIdsForUserResourceID);
        List<String> lkcIdsForUserId = Arrays.asList(args);
        lkcIdsForUserId.replaceAll(lkcId -> lkcId + "_" + userId);
        ArrayList<String> userIdsWithPrefix = new ArrayList<String>(lkcIdsForUserId.subList(3, args.length));
        userIdsWithPrefix.addAll(userRIdsWithPrefix);
        System.out.println("ACLs will be restored for the following users: \n" + String.valueOf(userIdsWithPrefix));
        try (AdminClient adminClient = AdminClient.create((Properties)props);){
            for (String user : userIdsWithPrefix) {
                AclBindingFilter filter = RestoreAclsForUser.getFilter(user);
                Collection inactiveAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
                adminClient.createAcls(inactiveAcls).all().get();
                ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), Collections.singletonList(filter), (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.DELETED).all().get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static AclBindingFilter getFilter(String userIdWithClusterId) {
        String principal = "TenantUser:" + userIdWithClusterId;
        return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal, "*", AclOperation.ANY, AclPermissionType.ANY));
    }
}

