/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.TestCluster;
import io.confluent.kafka.multitenant.quota.MultiTenantQuotaConfig;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ZkClientQuotaClusterDescriber;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TenantUserQuotaCallbackTest {
    private static final double EPS = 1.0E-4;
    private static final Long MIN_BROKER_CONSUME_QUOTA = 20L;
    private static final Long MIN_BROKER_PRODUCE_QUOTA = 10L;
    private static final Long MAX_BROKER_CONSUME_QUOTA = 1200L;
    private static final Long MAX_BROKER_PRODUCE_QUOTA = 600L;
    private static final Double DEFAULT_CONTROLLER_QUOTA = 20.0;
    private static final Long TENANT_1_PRODUCE_BYTE_RATE = 1000L;
    private static final Long TENANT_1_CONSUME_BYTE_RATE = 2000L;
    private final int brokerId = 1;
    private TestCluster testCluster;
    private TenantQuotaCallback quotaCallback;
    private final String tenant1 = "lkc-tenant1";
    private final String tenant2 = "lkc-tenant2";
    private final String tenant1TopicName = "lkc-tenant1_topic1";
    private final String tenant2TopicName = "lkc-tenant2_topic1";
    private final MultiTenantPrincipal tenant1UserAPrincipal = new MultiTenantPrincipal("userA", new TenantMetadata.Builder("lkc-tenant1", "sa-a").build());
    private final MultiTenantPrincipal tenant1UserBPrincipal = new MultiTenantPrincipal("userB", new TenantMetadata.Builder("lkc-tenant1", "sa-b").build());
    private final MultiTenantPrincipal tenant2UserAPrincipal = new MultiTenantPrincipal("userA", new TenantMetadata.Builder("lkc-tenant2", "sa-a").build());
    private final MultiTenantPrincipal tenant1ClDefaultPrincipal = new MultiTenantPrincipal("cluster-link-user", new TenantMetadata.Builder("lkc-tenant1", "cluster-link-user").build());
    private final MultiTenantPrincipal tenant1ClLinkOnlyPrincipal = new MultiTenantPrincipal("cluster-link-user-link-only", new TenantMetadata.Builder("lkc-tenant1", "cluster-link-user-link-only").build());

    @BeforeEach
    public void setUp() {
        this.quotaCallback = this.createCallbackWithConfigs(this.quotaCallbackProps());
    }

    @AfterEach
    public void tearDown() {
        this.quotaCallback.close();
    }

    @Test
    public void testQuotaMetricTags() {
        Assertions.assertEquals(this.expectedTags(this.tenant1UserAPrincipal), (Object)this.quotaCallback.quotaMetricTags(ClientQuotaType.PRODUCE, (KafkaPrincipal)this.tenant1UserAPrincipal, ""));
        KafkaPrincipal internalPrincipal = new KafkaPrincipal("internal_user", "internal_user");
        Map<String, String> metricTag = Collections.singletonMap("tenant", "lkc-internal-tenant");
        Assertions.assertEquals(metricTag, (Object)this.quotaCallback.quotaMetricTags(ClientQuotaType.PRODUCE, internalPrincipal, ""));
        Assertions.assertEquals((double)MAX_BROKER_PRODUCE_QUOTA.longValue(), (Double)this.quotaCallback.quotaLimit(ClientQuotaType.PRODUCE, metricTag));
    }

    @Test
    public void testParentQuotaMetricTagsWithUserQuotasEnabled() {
        String tenant = this.tenant1UserAPrincipal.tenantMetadata().tenantName;
        for (ClientQuotaType quotaType : ClientQuotaType.values()) {
            Map<Object, Object> expectedParentQuotaMetricTags = Collections.emptyMap();
            if (TenantQuotaCallback.USER_CONFIGURABLE_QUOTAS.contains(quotaType)) {
                expectedParentQuotaMetricTags = Collections.singletonMap("tenant", tenant);
            }
            Map metricTags = this.quotaCallback.quotaMetricTags(quotaType, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
            Assertions.assertEquals(expectedParentQuotaMetricTags, (Object)this.quotaCallback.parentQuotaMetricTags(quotaType, metricTags));
        }
    }

    @Test
    public void testDefaultBandwidthQuotaLimit() {
        Map callbackMetricTags = this.quotaCallback.quotaMetricTags(ClientQuotaType.PRODUCE, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
        Assertions.assertEquals(this.expectedTags(this.tenant1UserAPrincipal), (Object)callbackMetricTags);
        Assertions.assertEquals((double)MAX_BROKER_PRODUCE_QUOTA.longValue(), (double)this.quotaCallback.quotaLimit(ClientQuotaType.PRODUCE, callbackMetricTags), (double)1.0E-4);
        Assertions.assertEquals((double)MAX_BROKER_CONSUME_QUOTA.longValue(), (double)this.quotaCallback.quotaLimit(ClientQuotaType.FETCH, callbackMetricTags), (double)1.0E-4);
        MultiTenantQuotaConfig tenant1DefaultUserQuotaConfig = new MultiTenantQuotaConfig(400.0, 600.0, 1000.0, 1000.0, 1000.0, 1000.0);
        MultiTenantQuotaConfig tenant2DefaultUserQuotaConfig = new MultiTenantQuotaConfig(500.0, 800.0, 1000.0, 1000.0, 1000.0, 1000.0);
        TenantQuotaCallback.updateUserQuotas((String)this.tenant1UserAPrincipal.tenantMetadata().tenantName, Collections.emptyMap(), (MultiTenantQuotaConfig)tenant1DefaultUserQuotaConfig);
        TenantQuotaCallback.updateUserQuotas((String)this.tenant2UserAPrincipal.tenantMetadata().tenantName, Collections.emptyMap(), (MultiTenantQuotaConfig)tenant2DefaultUserQuotaConfig);
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        this.setPartitionLeaders("lkc-tenant1_topic1", 5, 5, 2);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0);
        this.setPartitionLeaders("lkc-tenant2_topic1", 0, 5, 1);
        this.setPartitionLeaders("lkc-tenant2_topic1", 5, 5, 2);
        this.verifyQuota(this.tenant2UserAPrincipal, ClientQuotaType.PRODUCE, 250.0);
        this.verifyQuota(this.tenant2UserAPrincipal, ClientQuotaType.FETCH, 400.0);
    }

    @Test
    public void testUserBandwidthQuotaLimit() {
        Map callbackMetricTags = this.quotaCallback.quotaMetricTags(ClientQuotaType.PRODUCE, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
        Assertions.assertEquals(this.expectedTags(this.tenant1UserAPrincipal), (Object)callbackMetricTags);
        String tenant = this.tenant1UserAPrincipal.tenantMetadata().tenantName;
        String userB = this.tenant1UserBPrincipal.tenantMetadata().userResourceId;
        MultiTenantQuotaConfig defaultUserQuotaConfig = new MultiTenantQuotaConfig(400.0, 600.0, 1000.0, 1000.0, 1000.0, 1000.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.emptyMap(), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        this.setPartitionLeaders("lkc-tenant1_topic1", 5, 5, 2);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1ClDefaultPrincipal, ClientQuotaType.PRODUCE, (double)TENANT_1_PRODUCE_BYTE_RATE.longValue() / 2.0);
        this.verifyQuota(this.tenant1ClLinkOnlyPrincipal, ClientQuotaType.PRODUCE, 200.0);
        MultiTenantQuotaConfig overrideQuotaConfig = new MultiTenantQuotaConfig(500.0, 800.0, 1000.0, 1000.0, 1000.0, 1000.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.singletonMap(userB, overrideQuotaConfig), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.PRODUCE, 250.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.FETCH, 400.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.singletonMap(this.tenant1ClLinkOnlyPrincipal.tenantMetadata().userResourceId, overrideQuotaConfig), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.verifyQuota(this.tenant1ClDefaultPrincipal, ClientQuotaType.PRODUCE, (double)TENANT_1_PRODUCE_BYTE_RATE.longValue() / 2.0);
        this.verifyQuota(this.tenant1ClLinkOnlyPrincipal, ClientQuotaType.PRODUCE, 250.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.singletonMap(this.tenant1ClDefaultPrincipal.tenantMetadata().userResourceId, overrideQuotaConfig), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.verifyQuota(this.tenant1ClDefaultPrincipal, ClientQuotaType.PRODUCE, (double)TENANT_1_PRODUCE_BYTE_RATE.longValue() / 2.0);
    }

    @Test
    public void testUserRequestQuotaLimit() {
        Map callbackMetricTags = this.quotaCallback.quotaMetricTags(ClientQuotaType.REQUEST, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
        Assertions.assertEquals(Collections.singletonMap("tenant", "lkc-tenant1"), (Object)callbackMetricTags);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.REQUEST, 300.0);
    }

    @Test
    public void testNoPartitions() {
        this.createCluster(5);
        String tenant = this.tenant1UserAPrincipal.tenantMetadata().tenantName;
        MultiTenantQuotaConfig defaultUserQuotaConfig = new MultiTenantQuotaConfig(400.0, 600.0, 1000.0, 1000.0, 1000.0, 1000.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.emptyMap(), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MIN_BROKER_PRODUCE_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MIN_BROKER_CONSUME_QUOTA.longValue());
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 2, 1);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 400.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
        this.createCluster(5);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MIN_BROKER_PRODUCE_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MIN_BROKER_CONSUME_QUOTA.longValue());
    }

    @Test
    public void testControllerQuotaLimit() {
        Map callbackMetricTags = this.quotaCallback.quotaMetricTags(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
        Assertions.assertEquals(Collections.singletonMap("tenant", "lkc-tenant1"), (Object)callbackMetricTags);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testBandwidthQuotaLimitTagAware() {
        Map callbackMetricTags = this.quotaCallback.quotaMetricTags(ClientQuotaType.PRODUCE, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
        Assertions.assertEquals(this.expectedTags(this.tenant1UserAPrincipal), (Object)callbackMetricTags);
        String tenant = this.tenant1UserAPrincipal.tenantMetadata().tenantName;
        MultiTenantQuotaConfig defaultUserQuotaConfig = new MultiTenantQuotaConfig(400.0, 600.0, 1000.0, 1000.0, 1000.0, 1000.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.emptyMap(), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        this.setPartitionLeaders("lkc-tenant1_topic1", 5, 5, 2);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.PRODUCE, 200.0);
        Map<String, String> tenantTags = Collections.singletonMap("tenant", tenant);
        Assertions.assertEquals((double)((double)TENANT_1_PRODUCE_BYTE_RATE.longValue() / 2.0), (double)this.quotaCallback.quotaLimit(ClientQuotaType.PRODUCE, tenantTags), (double)1.0E-4);
        Assertions.assertEquals((double)((double)TENANT_1_CONSUME_BYTE_RATE.longValue() / 2.0), (double)this.quotaCallback.quotaLimit(ClientQuotaType.FETCH, tenantTags), (double)1.0E-4);
    }

    @Test
    public void testUserQuotaChangeSetsUpdateFlag() {
        String tenant = this.tenant1UserAPrincipal.tenantMetadata().tenantName;
        MultiTenantQuotaConfig defaultUserQuotaConfig = new MultiTenantQuotaConfig(400.0, 600.0, 1000.0, 1000.0, 1000.0, 1000.0);
        EnumSet<ClientQuotaType> quotaTypes = EnumSet.allOf(ClientQuotaType.class);
        quotaTypes.forEach(arg_0 -> ((TenantQuotaCallback)this.quotaCallback).quotaResetRequired(arg_0));
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.emptyMap(), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        EnumSet userConfigurableQuotaTypes = TenantQuotaCallback.USER_CONFIGURABLE_QUOTAS;
        quotaTypes.forEach(quotaType -> Assertions.assertEquals((Object)userConfigurableQuotaTypes.contains(quotaType), (Object)this.quotaCallback.quotaResetRequired(quotaType)));
    }

    @Test
    public void testUserQuotasRetainedOnTenantQuotaUpdate() {
        Map callbackMetricTags = this.quotaCallback.quotaMetricTags(ClientQuotaType.PRODUCE, (KafkaPrincipal)this.tenant1UserAPrincipal, "");
        Assertions.assertEquals(this.expectedTags(this.tenant1UserAPrincipal), (Object)callbackMetricTags);
        String tenant = this.tenant1UserAPrincipal.tenantMetadata().tenantName;
        MultiTenantQuotaConfig defaultUserQuotaConfig = new MultiTenantQuotaConfig(400.0, 600.0, 1000.0, 1000.0, 1000.0, 1000.0);
        TenantQuotaCallback.updateUserQuotas((String)tenant, Collections.emptyMap(), (MultiTenantQuotaConfig)defaultUserQuotaConfig);
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        this.setPartitionLeaders("lkc-tenant1_topic1", 5, 5, 2);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0);
        HashMap<String, MultiTenantQuotaConfig> tenantQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        tenantQuotas.put("lkc-tenant2", this.quotaConfig(2000L, 3000L, 400.0, 500.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0);
    }

    @Test
    public void testUpdateQuotaMultipleEntities() {
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        this.setPartitionLeaders("lkc-tenant2_topic1", 0, 5, 1);
        ClientQuotaEntity tenant1UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)false);
        ClientQuotaEntity tenant1UserBEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserBPrincipal, (boolean)false);
        ClientQuotaEntity tenant2UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant2UserAPrincipal, (boolean)false);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity, 500.0);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserBEntity, 300.0);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant2UserAEntity, 250.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.PRODUCE, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue());
        this.verifyQuota(this.tenant2UserAPrincipal, ClientQuotaType.PRODUCE, 250.0);
        this.verifyQuota(this.tenant2UserAPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue());
    }

    @Test
    public void testUpdateQuotaDefaultEntity() {
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        ClientQuotaEntity tenant1UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)false);
        ClientQuotaEntity tenant1UserBEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserBPrincipal, (boolean)false);
        ClientQuotaEntity tenant1DefaultEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)true);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity, 500.0);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1DefaultEntity, 400.0);
        this.quotaCallback.updateQuota(ClientQuotaType.FETCH, tenant1DefaultEntity, 550.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.PRODUCE, 400.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.FETCH, 550.0);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserBEntity, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.PRODUCE, 300.0);
        this.verifyQuota(this.tenant1UserBPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue());
    }

    @Test
    public void testDynamicTenantUserQuotas() {
        this.createCluster(5);
        for (int i = 1; i <= 5; ++i) {
            this.setPartitionLeaders("lkc-tenant1_topic1", i - 1, 1, i);
        }
        HashMap<String, MultiTenantQuotaConfig> userQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        userQuotas.put(this.tenant1UserAPrincipal.tenantMetadata().userResourceId, this.quotaConfig(3000L, 4000L, 300.0, 400.0));
        TenantQuotaCallback.updateUserQuotas((String)"lkc-tenant1", userQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        Assertions.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.PRODUCE));
        Assertions.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.FETCH));
        Assertions.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.REQUEST));
        Assertions.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.LINK_REQUEST));
        Assertions.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
        HashMap<String, Long> quotas = new HashMap<String, Long>();
        quotas.put("PRODUCE", 200L);
        quotas.put("FETCH", 400L);
        HashMap<String, String> metricTags = new HashMap<String, String>();
        metricTags.put("tenant", "lkc-tenant1");
        metricTags.put("user-resource-id", this.tenant1UserAPrincipal.tenantMetadata().userResourceId);
        this.quotaCallback.enableDynamicQuota(true);
        Assertions.assertTrue((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, quotas)));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 400.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        Assertions.assertFalse((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, quotas)));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 400.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        Assertions.assertTrue((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, Collections.singletonMap("PRODUCE", 100L))));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 100.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 800.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        Assertions.assertTrue((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, Collections.singletonMap("FETCH", 300L))));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 600.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 300.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        Assertions.assertTrue((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, Collections.singletonMap("REQUEST", 600L))));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 600.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 800.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        Assertions.assertFalse((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, Collections.singletonMap("PRODUCE", 0L))));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 600.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 800.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
    }

    @Test
    public void testUnlimitedClusterQuotaResetDynamicQuota() {
        this.createCluster(5);
        for (int i = 1; i <= 5; ++i) {
            this.setPartitionLeaders("lkc-tenant1_topic1", i - 1, 1, i);
        }
        HashMap<String, MultiTenantQuotaConfig> userQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        userQuotas.put(this.tenant1UserAPrincipal.tenantMetadata().userResourceId, this.quotaConfig(3000L, 4000L, 300.0, 200.0));
        TenantQuotaCallback.updateUserQuotas((String)"lkc-tenant1", userQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        HashMap<String, Long> quotas = new HashMap<String, Long>();
        quotas.put("PRODUCE", 200L);
        quotas.put("FETCH", 400L);
        HashMap<String, String> metricTags = new HashMap<String, String>();
        metricTags.put("tenant", "lkc-tenant1");
        metricTags.put("user-resource-id", this.tenant1UserAPrincipal.tenantMetadata().userResourceId);
        this.quotaCallback.enableDynamicQuota(true);
        Assertions.assertTrue((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, quotas)));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 200.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 400.0, true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.LINK_REQUEST, 200.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        userQuotas.put(this.tenant1UserAPrincipal.tenantMetadata().userResourceId, MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        TenantQuotaCallback.updateUserQuotas((String)"lkc-tenant1", userQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MAX_BROKER_PRODUCE_QUOTA.longValue(), true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue(), true);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.LINK_REQUEST, 200.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
        Assertions.assertFalse((boolean)this.quotaCallback.updateDynamicQuotas(Collections.singletonMap(metricTags, quotas)));
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MAX_BROKER_PRODUCE_QUOTA.longValue(), false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue(), false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.LINK_REQUEST, 200.0, false);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA, false);
    }

    @Test
    public void testUpdateQuotaRetainsQuotaTypeOverrides() {
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        ClientQuotaEntity tenant1UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)false);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, MAX_BROKER_CONSUME_QUOTA.longValue());
        this.quotaCallback.updateQuota(ClientQuotaType.FETCH, tenant1UserAEntity, 750.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 750.0);
    }

    @Test
    public void testUpdateQuotaIgnoresUnconfigurableQuotaTypes() {
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        ClientQuotaEntity tenant1UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)false);
        this.quotaCallback.updateQuota(ClientQuotaType.REQUEST, tenant1UserAEntity, 500.0);
        this.quotaCallback.updateQuota(ClientQuotaType.CONTROLLER_MUTATION, tenant1UserAEntity, 750.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.REQUEST, 300.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.CONTROLLER_MUTATION, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testRemoveQuota() {
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        ClientQuotaEntity tenant1UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)false);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity, 500.0);
        this.quotaCallback.updateQuota(ClientQuotaType.FETCH, tenant1UserAEntity, 600.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
        this.quotaCallback.removeQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MAX_BROKER_PRODUCE_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
    }

    @Test
    public void testRemoveQuotaFallback() {
        this.createCluster(5);
        this.setPartitionLeaders("lkc-tenant1_topic1", 0, 5, 1);
        ClientQuotaEntity tenant1UserAEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)false);
        ClientQuotaEntity tenant1DefaultEntity = KafkaLogicalClusterUtils.quotaEntity((MultiTenantPrincipal)this.tenant1UserAPrincipal, (boolean)true);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity, 500.0);
        this.quotaCallback.updateQuota(ClientQuotaType.FETCH, tenant1UserAEntity, 600.0);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1DefaultEntity, 300.0);
        this.quotaCallback.updateQuota(ClientQuotaType.FETCH, tenant1DefaultEntity, 400.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, 500.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
        this.quotaCallback.removeQuota(ClientQuotaType.PRODUCE, tenant1UserAEntity);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MAX_BROKER_PRODUCE_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
        this.quotaCallback.updateQuota(ClientQuotaType.PRODUCE, tenant1DefaultEntity, 350.0);
        this.quotaCallback.updateQuota(ClientQuotaType.FETCH, tenant1DefaultEntity, 450.0);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MAX_BROKER_PRODUCE_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
        this.quotaCallback.removeQuota(ClientQuotaType.PRODUCE, tenant1DefaultEntity);
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.PRODUCE, MAX_BROKER_PRODUCE_QUOTA.longValue());
        this.verifyQuota(this.tenant1UserAPrincipal, ClientQuotaType.FETCH, 600.0);
    }

    @Test
    public void testClusterLevelTenantUserQuota() {
        long userProduceByteRate = TENANT_1_PRODUCE_BYTE_RATE / 3L;
        long userConsumeByteRate = TENANT_1_CONSUME_BYTE_RATE / 3L;
        HashMap<String, MultiTenantQuotaConfig> userQuota = new HashMap<String, MultiTenantQuotaConfig>();
        userQuota.put("service-account", this.quotaConfig(userProduceByteRate, userConsumeByteRate, 25.0, 25.0));
        userQuota.put(this.tenant1ClLinkOnlyPrincipal.tenantMetadata().userResourceId, this.quotaConfig(userProduceByteRate, userConsumeByteRate, 25.0, 25.0));
        userQuota.put(this.tenant1ClDefaultPrincipal.tenantMetadata().userResourceId, this.quotaConfig(userProduceByteRate, userConsumeByteRate, 25.0, 25.0));
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", userQuota, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        HashMap<String, String> metricTags = new HashMap<String, String>();
        metricTags.put("tenant", "tenant1");
        metricTags.put("user-resource-id", "service-account");
        Assertions.assertEquals((double)userProduceByteRate, (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.PRODUCE, metricTags));
        Assertions.assertEquals((double)userConsumeByteRate, (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.FETCH, metricTags));
        metricTags.put("user-resource-id", this.tenant1ClLinkOnlyPrincipal.tenantMetadata().userResourceId);
        Assertions.assertEquals((double)userProduceByteRate, (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.PRODUCE, metricTags));
        Assertions.assertEquals((double)userConsumeByteRate, (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.FETCH, metricTags));
        metricTags.put("user-resource-id", this.tenant1ClDefaultPrincipal.tenantMetadata().userResourceId);
        Assertions.assertEquals((double)MultiTenantQuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.PRODUCE), (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.PRODUCE, metricTags));
        Assertions.assertEquals((double)MultiTenantQuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.FETCH), (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.FETCH, metricTags));
        metricTags.put("user-resource-id", "fake-service-account");
        Assertions.assertEquals((double)MultiTenantQuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.PRODUCE), (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.PRODUCE, metricTags));
        Assertions.assertEquals((double)MultiTenantQuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.FETCH), (Double)this.quotaCallback.clusterQuotaLimit(ClientQuotaType.FETCH, metricTags));
    }

    private Map<String, String> expectedTags(MultiTenantPrincipal principal) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tenant", principal.tenantMetadata().tenantName);
        tags.put("user-resource-id", principal.tenantMetadata().userResourceId);
        return tags;
    }

    private void verifyQuota(MultiTenantPrincipal principal, ClientQuotaType quotaType, double expectedQuota) {
        this.verifyQuota(principal, quotaType, expectedQuota, false);
    }

    private void verifyQuota(MultiTenantPrincipal principal, ClientQuotaType quotaType, double expectedQuota, boolean expectedResetRequired) {
        Map tags = this.quotaCallback.quotaMetricTags(quotaType, (KafkaPrincipal)principal, "");
        Assertions.assertEquals((double)expectedQuota, (double)this.quotaCallback.quotaLimit(quotaType, tags), (double)1.0E-4);
        if (expectedResetRequired) {
            Assertions.assertTrue((boolean)this.quotaCallback.quotaResetRequired(quotaType));
        }
    }

    private TenantQuotaCallback createCallbackWithConfigs(Map<String, Object> configs) {
        TenantQuotaCallback.closeAll();
        TenantQuotaCallback quotaCallback = new TenantQuotaCallback();
        quotaCallback.configure(configs);
        HashMap<String, MultiTenantQuotaConfig> tenantQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        tenantQuotas.put("lkc-tenant1", this.quotaConfig(TENANT_1_PRODUCE_BYTE_RATE, TENANT_1_CONSUME_BYTE_RATE, 300.0, 200.0));
        tenantQuotas.put("lkc-tenant2", this.quotaConfig(2000L, 3000L, 400.0, 300.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        return quotaCallback;
    }

    private Map<String, Object> quotaCallbackProps() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("broker.id", String.valueOf(1));
        configs.put("confluent.quota.tenant.follower.broker.min.producer.rate", MIN_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.broker.max.producer.rate", MAX_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.internal.throttling.enable", true);
        configs.put("confluent.quota.tenant.internal.broker.max.producer.rate", MAX_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.follower.broker.min.consumer.rate", MIN_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.broker.max.consumer.rate", MAX_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.internal.broker.max.consumer.rate", MAX_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.default.controller.mutation.rate", DEFAULT_CONTROLLER_QUOTA.toString());
        configs.put("confluent.quota.tenant.user.quotas.enable", Boolean.TRUE.toString());
        return configs;
    }

    private MultiTenantQuotaConfig quotaConfig(long producerByteRate, long consumerByteRate, double requestPercentage, double linkRequestPercentage) {
        return new MultiTenantQuotaConfig(Long.valueOf(producerByteRate), Long.valueOf(consumerByteRate), Double.valueOf(requestPercentage), null, null, Double.valueOf(linkRequestPercentage), MultiTenantQuotaConfig.UNLIMITED_QUOTA);
    }

    private void createCluster(int numNodes) {
        this.testCluster = new TestCluster();
        for (int i = 1; i <= numNodes; ++i) {
            this.testCluster.addNode(i, "rack0");
        }
        Cluster cluster = this.testCluster.cluster();
        this.quotaCallback.updateClusterMetadata((ClientQuotaClusterDescriber)new ZkClientQuotaClusterDescriber(cluster));
        Assertions.assertEquals((Object)cluster, (Object)((ZkClientQuotaClusterDescriber)this.quotaCallback.cluster()).cluster());
    }

    private void setPartitionLeaders(String topic, int firstPartition, int count, Integer leaderBrokerId) {
        this.testCluster.setPartitionLeaders(topic, firstPartition, count, leaderBrokerId);
        this.quotaCallback.updateClusterMetadata((ClientQuotaClusterDescriber)new ZkClientQuotaClusterDescriber(this.testCluster.cluster()));
    }
}

