/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.server.plugins.auth.PlainSaslCredentials;
import io.confluent.kafka.server.plugins.auth.PlainSaslServer;
import io.confluent.kafka.server.plugins.auth.SaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.stats.AuthenticationStats;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PlainSaslServerTest {
    private List<AppConfigurationEntry> jaasEntries;
    private SaslAuthenticator mockSaslAuth;
    private PlainSaslServer saslServer;
    private static AuthenticationStats stats = AuthenticationStats.getInstance();

    @BeforeEach
    public void setUp() throws Exception {
        this.jaasEntries = Collections.emptyList();
        this.mockSaslAuth = (SaslAuthenticator)Mockito.mock(SaslAuthenticator.class);
        Mockito.when((Object)this.mockSaslAuth.clusterId((String)ArgumentMatchers.any())).thenReturn(Optional.of("test-cluster"));
        this.saslServer = new PlainSaslServer(this.jaasEntries, this.mockSaslAuth, Collections.emptyMap());
        stats.reset();
    }

    @Test
    public void shouldNotAllowImpersonation() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "impersonating\u0000foo\u0000bar";
        try {
            this.saslServer.evaluateResponse("impersonating\u0000foo\u0000bar".getBytes());
            Assertions.fail();
        }
        catch (SaslAuthenticationException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Client requested an authorization id that is different from username"));
            this.verifyErrorInfo(e, AuditEventStatus.UNAUTHENTICATED, "foo");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"authenticateArgs"})
    public void authSucceedsWithMetrics(String networkId, String organizationId, SaslInternalConfigs.NetworkType networkType) throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        String testClientLkc = "lkc-client";
        this.saslServer = new PlainSaslServer(this.jaasEntries, this.mockSaslAuth, this.getProps("tenant1", networkId, organizationId, networkType, true, "lkc-client"));
        this.configureUser(new PlainSaslCredentials.Builder("foo", "bar", null, "tenant1", networkId, organizationId, networkType, Boolean.valueOf(true)).build());
        this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
        Assertions.assertEquals((Object)"foo", (Object)this.saslServer.getAuthorizationID());
        Assertions.assertEquals((Object)"foo", (Object)this.saslServer.authenticationId());
        Assertions.assertEquals(Optional.ofNullable(networkId), (Object)this.saslServer.networkId());
        Assertions.assertEquals(Optional.ofNullable(organizationId), (Object)this.saslServer.organizationId());
        Assertions.assertEquals(Optional.ofNullable(networkType), (Object)this.saslServer.networkType());
        Assertions.assertEquals(Optional.of(true), (Object)this.saslServer.hasSslPeerCertificate());
        Assertions.assertEquals(Optional.ofNullable("lkc-client"), (Object)this.saslServer.clientLogicalClusterId());
        Assertions.assertEquals((long)1L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)0L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    private Map<String, ?> getProps(String tenantId, String networkId, String organizationId, SaslInternalConfigs.NetworkType networkType, Boolean hasSslPeerCertificate, String clientLogicalClusterId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("__confluent_logical_cluster_id", tenantId);
        props.put("__confluent_traffic_network_id", networkId);
        props.put("__confluent_cloud_organization_id", organizationId);
        props.put("__confluent_traffic_network_type", networkType);
        props.put("__confluent_has_ssl_peer_certificate", hasSslPeerCertificate);
        props.put("__confluent_client_logical_cluster_id", clientLogicalClusterId);
        return props;
    }

    @Test
    public void authFailsWithMetrics() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        ((SaslAuthenticator)Mockito.doThrow((Throwable[])new Throwable[]{new SaslException("Top level msg", new Exception("Detailed cause"))}).when((Object)this.mockSaslAuth)).authenticate(new PlainSaslCredentials.Builder("foo", "bar").build());
        try {
            this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
            Assertions.fail();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assertions.assertEquals((long)0L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)1L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void nullCauseIsOK() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        ((SaslAuthenticator)Mockito.doThrow((Throwable[])new Throwable[]{new SaslException("Top level msg", null)}).when((Object)this.mockSaslAuth)).authenticate(new PlainSaslCredentials.Builder("foo", "bar").build());
        try {
            this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
            Assertions.fail();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assertions.assertEquals((long)0L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)1L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void parseFailsWithMetrics() throws Exception {
        try {
            this.saslServer.evaluateResponse("garbage".getBytes());
            Assertions.fail();
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            // empty catch block
        }
        Assertions.assertEquals((long)0L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)1L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void metricsInJMX() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        long successes = 7L;
        this.saslServer = new PlainSaslServer(this.jaasEntries, this.mockSaslAuth, this.getProps("tenant1", null, null, null, null, null));
        this.configureUser(new PlainSaslCredentials.Builder("foo", "bar").logicalClusterId("tenant1").build());
        int i = 0;
        while ((long)i < 7L) {
            this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
            ++i;
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String objectName = "io.confluent.kafka.server.plugins:type=Authentication";
        Set<ObjectInstance> instances = mBeanServer.queryMBeans(new ObjectName(objectName), null);
        Assertions.assertEquals((int)1, (int)instances.size());
        ObjectInstance instance = (ObjectInstance)instances.toArray()[0];
        MBeanInfo info = mBeanServer.getMBeanInfo(instance.getObjectName());
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            attrMap.put(attrInfo.getName(), mBeanServer.getAttribute(instance.getObjectName(), attrInfo.getName()));
        }
        Assertions.assertEquals((Object)7L, attrMap.get("Succeeded"));
        Assertions.assertEquals((Object)0L, attrMap.get("Failed"));
        Assertions.assertEquals((Object)7L, attrMap.get("Total"));
    }

    @Test
    public void emptyTokens() {
        SaslAuthenticationException e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "", "")));
        Assertions.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "", "p")));
        Assertions.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "u", "")));
        Assertions.assertEquals((Object)"Authentication failed: password not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNAUTHENTICATED, "u");
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "", "")));
        Assertions.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "", "p")));
        Assertions.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "u", "")));
        Assertions.assertEquals((Object)"Authentication failed: password not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNAUTHENTICATED, "u");
        String nul = "\u0000";
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(String.format("%s%s%s%s%s%s", "a", nul, "u", nul, "p", nul).getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)"Invalid SASL/PLAIN response: expected 3 tokens, got 4", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(String.format("%s%s%s", "", nul, "u").getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)"Invalid SASL/PLAIN response: expected 3 tokens, got 2", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
    }

    private void verifyErrorInfo(SaslAuthenticationException e, AuditEventStatus auditEventStatus, String identifier) {
        Assertions.assertEquals((Object)auditEventStatus, (Object)e.errorInfo().auditEventStatus());
        Assertions.assertEquals((Object)identifier, (Object)e.errorInfo().identifier());
        if (AuditEventStatus.UNAUTHENTICATED == auditEventStatus) {
            Assertions.assertEquals((Object)"test-cluster", (Object)e.errorInfo().clusterId());
        }
    }

    private void configureUser(final PlainSaslCredentials credentials) throws SaslException {
        ((SaslAuthenticator)Mockito.doAnswer((Answer)new Answer<MultiTenantPrincipal>(){
            final /* synthetic */ PlainSaslServerTest this$0;
            {
                this.this$0 = this$0;
            }

            public MultiTenantPrincipal answer(InvocationOnMock invocation) throws Throwable {
                TenantMetadata tenantMetadata = new TenantMetadata((String)credentials.logicalClusterId.orElse(null), (String)credentials.logicalClusterId.orElse(null));
                return new MultiTenantPrincipal(credentials.username, tenantMetadata);
            }
        }).when((Object)this.mockSaslAuth)).authenticate(credentials);
    }

    private byte[] saslMessage(String authorizationId, String userName, String password) {
        String nul = "\u0000";
        String message = String.format("%s%s%s%s%s", authorizationId, nul, userName, nul, password);
        return message.getBytes(StandardCharsets.UTF_8);
    }

    static Stream<Arguments> authenticateArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null, null, null}), Arguments.of((Object[])new Object[]{"networkIdFoo", "organizationIdFoo", SaslInternalConfigs.NetworkType.PRIVATE}));
    }
}

