/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.server.plugins.auth.TestLogicalClusterMetadata;
import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.kafka.server.quota.ElasticCkuDefinitionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class CreateTopicPolicyTest {
    static final Map<String, Integer> SAMPLE_TOPICS_TO_NUM_PARTITIONS;
    static final Map<String, String> VALID_SAMPLE_TOPIC_CONFIG;
    static final Map<String, String> VALID_SAMPLE_FREIGHT_TOPIC_CONFIG;
    static final Map<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> ELASTIC_CKU_METADATA_DEFAULT_CONFIG;
    static final Map<String, String> INVALID_SAMPLE_TOPIC_CONFIG;
    static final Map<String, String> SCHEMA_VALIDATION_TOPIC_CONFIG;
    static final boolean TOPIC_COMPACTED = true;

    @Test
    public void testEnsureValidPartitionCountTenantLimit() {
        CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)1, (int)2);
        CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)9, (int)1);
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)9, (int)2));
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)0, (int)11));
        CreateTopicPolicy.ensureValidTenantCompactedPartitionCount((String)"foo", (int)10, (int)1, (int)2);
        CreateTopicPolicy.ensureValidTenantCompactedPartitionCount((String)"foo", (int)10, (int)9, (int)1);
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidTenantCompactedPartitionCount((String)"foo", (int)10, (int)9, (int)2));
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidTenantCompactedPartitionCount((String)"foo", (int)10, (int)0, (int)11));
    }

    @Test
    public void testEnsureValidPartitionCountClusterLimit() {
        CreateTopicPolicy.ensureValidClusterPartitionCount((int)10, (int)1, (int)2);
        CreateTopicPolicy.ensureValidClusterPartitionCount((int)10, (int)9, (int)1);
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidClusterPartitionCount((int)0, (int)10, (int)2));
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidClusterPartitionCount((int)0, (int)10, (int)11));
    }

    @Test
    public void testFullUpdate() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), new HashMap(), new HashSet());
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("partitions", "lkc-fghij"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("partitions", "lkc-klmno"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
        }
    }

    @Test
    public void testFullUpdateWithCompactedPartitions() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            HashSet<String> compactedTopics = new HashSet<String>();
            compactedTopics.add("lkc-abcde_foo");
            compactedTopics.add("lkc-fghij_bar");
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), new HashMap(), compactedTopics);
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)2, (int)ctx.policy.numCompactedPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("compacted-partitions", "lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("partitions", "lkc-fghij"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("partitions", "lkc-klmno"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numCompactedPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("compacted-partitions", "lkc-klmno"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
            HashMap<String, Integer> updatedTopicToNumPartitions = new HashMap<String, Integer>();
            updatedTopicToNumPartitions.put("lkc-abcde_foo", 5);
            updatedTopicToNumPartitions.put("lkc-abcde_bar", 4);
            updatedTopicToNumPartitions.put("lkc-baz_topic", 7);
            updatedTopicToNumPartitions.put("lkc-fghij_bar", 2);
            ctx.policy.fullUpdate(updatedTopicToNumPartitions.entrySet().iterator(), new HashMap(), compactedTopics);
            Assertions.assertEquals((int)9, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)9, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)5, (int)ctx.policy.numCompactedPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)5, (Integer)ctx.metricValue("compacted-partitions", "lkc-abcde"));
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("partitions", "lkc-fghij"));
            Assertions.assertEquals((int)2, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            Assertions.assertEquals((int)7, (int)ctx.policy.numPartitions("lkc-baz"));
            Assertions.assertEquals((Integer)7, (Integer)ctx.metricValue("partitions", "lkc-baz"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numCompactedPartitions("lkc-baz"));
            Assertions.assertNull((Object)ctx.metricValue("compacted-partitions", "lkc-baz"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("partitions", "lkc-klmno"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numCompactedPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("compacted-partitions", "lkc-klmno"));
        }
    }

    @Test
    public void testPartialUpdates() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), new HashMap(), new HashSet());
            ctx.policy.partialUpdate("lkc-abcde_foo", -2, -1, Collections.emptyMap(), Collections.emptyMap(), false, false);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            ctx.policy.partialUpdate("blah", -2, -1, Collections.emptyMap(), Collections.emptyMap(), false, false);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            ctx.policy.partialUpdate("lkc-abcde_foo", -2, -1, Collections.emptyMap(), Collections.emptyMap(), false, false);
            ctx.policy.partialUpdate("lkc-xyzab_", 2, -1, Collections.emptyMap(), Collections.emptyMap(), false, false);
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("partitions", "lkc-fghij"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
            ctx.policy.partialUpdate("lkc-fghij_baz", 4, 1, Collections.emptyMap(), Collections.emptyMap(), false, false);
            Assertions.assertEquals((int)5, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap())));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact", 10, 1, Collections.emptyMap(), Collections.emptyMap(), false, true);
            Assertions.assertEquals((int)10, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)10, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact_1", 10, 1, Collections.emptyMap(), Collections.emptyMap(), false, true);
            Assertions.assertEquals((int)20, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)20, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact", 4, 0, Collections.emptyMap(), Collections.emptyMap(), true, true);
            Assertions.assertEquals((int)24, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)20, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact", -3, 0, Collections.emptyMap(), Collections.emptyMap(), true, true);
            Assertions.assertEquals((int)21, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)20, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact", -4, 0, Collections.emptyMap(), Collections.emptyMap(), false, true);
            Assertions.assertEquals((int)17, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)16, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact", -6, 0, Collections.emptyMap(), Collections.emptyMap(), false, true);
            Assertions.assertEquals((int)11, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)10, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact", -1, 0, Collections.emptyMap(), Collections.emptyMap(), true, true);
            Assertions.assertEquals((int)10, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)10, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact_1", -10, 1, Collections.emptyMap(), Collections.emptyMap(), false, true);
            Assertions.assertEquals((int)0, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertNull((Object)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.partialUpdate("lkc-fghij_baz_compact_1", -5, 1, Collections.emptyMap(), Collections.emptyMap(), false, true);
            Assertions.assertEquals((int)0, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertNull((Object)ctx.metricValue("compacted-partitions", "lkc-fghij"));
        }
    }

    @Test
    public void testUpdateTopicCompactionConfig() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            HashSet<String> compactedTopics = new HashSet<String>();
            compactedTopics.add("lkc-abcde_foo");
            compactedTopics.add("lkc-fghij_bar");
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), new HashMap(), compactedTopics);
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)2, (int)ctx.policy.numCompactedPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("compacted-partitions", "lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("partitions", "lkc-fghij"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numCompactedPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("compacted-partitions", "lkc-fghij"));
            ctx.policy.updateTopicPartitionsOnCompactConfigChange("lkc-abcde_foo", "compact", "delete", 2);
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numCompactedPartitions("lkc-abcde"));
            Assertions.assertNull((Object)ctx.metricValue("compacted-partitions", "lkc-abcde"));
            ctx.policy.updateTopicPartitionsOnCompactConfigChange("lkc-abcde_bar", "delete", "compact", 2);
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("partitions", "lkc-abcde"));
            Assertions.assertEquals((int)2, (int)ctx.policy.numCompactedPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("compacted-partitions", "lkc-abcde"));
        }
    }

    @Test
    public void testPendingUpdates() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.partialUpdate("lkc-abcde_foo", -2, -1, Collections.emptyMap(), Collections.emptyMap(), true, false);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            ctx.policy.partialUpdate("lkc-abcde_foo", 2, 1, Collections.emptyMap(), Collections.emptyMap(), true, false);
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            ctx.policy.clearPending();
        }
    }

    @Test
    public void testTooManyTopics() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (5).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 1 new partitions. Adding the requested number of partitions will exceed 5 total partitions. Currently, there are 4 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(2), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testTooManyClusterTopics() {
        int maxTopicsPerCluster = 3;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, Integer.MAX_VALUE, maxTopicsPerCluster, false, Integer.MAX_VALUE, Integer.MAX_VALUE, "delete");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertEquals((Object)"The cluster has reached the maximum number of topics.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testTooManyClusterPartitions() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (5).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testDynamicTotalPartitionCountEnforcement() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 500, Integer.MAX_VALUE, false);){
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith2MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(ELASTIC_CKU_METADATA_DEFAULT_CONFIG);
            eckuMetadataWith2MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 2);
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith3MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(ELASTIC_CKU_METADATA_DEFAULT_CONFIG);
            eckuMetadataWith3MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 3);
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith4MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(ELASTIC_CKU_METADATA_DEFAULT_CONFIG);
            eckuMetadataWith4MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 4);
            HashMap<String, KafkaLogicalClusterMetadata> updates = new HashMap<String, KafkaLogicalClusterMetadata>();
            updates.put("lkc-abc", this.kafkaLogicalClusterMetadata("lkc-abc", 500, eckuMetadataWith2MaxEcku));
            updates.put("lkc-def", this.kafkaLogicalClusterMetadata("lkc-def", 500, eckuMetadataWith3MaxEcku));
            updates.put("lkc-123", this.kafkaLogicalClusterMetadata("lkc-123", 500, null));
            ctx.policy.onMetadataUpdate(updates);
            Map<String, Integer> allTopicsMap = Map.of("lkc-abc_foo", 150, "lkc-abc_bar", 20, "lkc-def_foo", 250, "lkc-def_bar", 20, "lkc-123_foo", 350, "lkc-123_bar", 100);
            ctx.policy.fullUpdate(allTopicsMap.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (200).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(220), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 30 new partitions. Adding the requested number of partitions will exceed 200 total partitions. Currently, there are 170 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(40), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertDoesNotThrow(() -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(30), Short.valueOf((short)3), null, Collections.emptyMap())));
            ctx.policy.partialUpdate("lkc-abc_foobar", 30, 0, new HashMap(), new HashMap(), false, false);
            Assertions.assertEquals((Object)"You may not create more than 0 new partitions. Adding the requested number of partitions will exceed 200 total partitions. Currently, there are 200 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foo", Integer.valueOf(5), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (300).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-def_foobar", Integer.valueOf(330), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 30 new partitions. Adding the requested number of partitions will exceed 300 total partitions. Currently, there are 270 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-def_foobar", Integer.valueOf(40), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (500).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-123_foobar", Integer.valueOf(530), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 50 new partitions. Adding the requested number of partitions will exceed 500 total partitions. Currently, there are 450 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-123_foobar", Integer.valueOf(60), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            updates = new HashMap();
            updates.put("lkc-abc", this.kafkaLogicalClusterMetadata("lkc-abc", 500, eckuMetadataWith3MaxEcku));
            ctx.policy.onMetadataUpdate(updates);
            Assertions.assertDoesNotThrow(() -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(30), Short.valueOf((short)3), null, Collections.emptyMap())));
            ctx.policy.partialUpdate("lkc-abc_foobar", 30, 0, new HashMap(), new HashMap(), false, false);
            Assertions.assertEquals((Object)"You may not create more than 70 new partitions. Adding the requested number of partitions will exceed 300 total partitions. Currently, there are 230 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(130), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            updates.put("lkc-def", this.kafkaLogicalClusterMetadata("lkc-def", 500, eckuMetadataWith4MaxEcku));
            ctx.policy.onMetadataUpdate(updates);
            Assertions.assertEquals((Object)"You may not create more than 130 new partitions. Adding the requested number of partitions will exceed 400 total partitions. Currently, there are 270 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-def_f1", Integer.valueOf(140), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 50 new partitions. Adding the requested number of partitions will exceed 500 total partitions. Currently, there are 450 total partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-123_f1", Integer.valueOf(60), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testDynamicCompactedPartitionCountEnforcement() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 500, Integer.MAX_VALUE, false);){
            Map elasticCkuMetadataBaseConfig = Map.ofEntries(Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.PRODUCE, 0x500000), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.FETCH, 0x500000), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.CONNECTION_ATTEMPT, 250), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.CONNECTION_COUNT, 4500), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT, 90), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT, 10), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.REQUEST_COUNT, 7500), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MIN_ELASTIC_CKU, 1), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.TOTAL_THROUGHPUT, 0xA00000));
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith2MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(elasticCkuMetadataBaseConfig);
            eckuMetadataWith2MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 2);
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith3MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(elasticCkuMetadataBaseConfig);
            eckuMetadataWith3MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 3);
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith4MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(elasticCkuMetadataBaseConfig);
            eckuMetadataWith4MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 4);
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith6MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(elasticCkuMetadataBaseConfig);
            eckuMetadataWith6MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 6);
            HashMap<String, KafkaLogicalClusterMetadata> updates = new HashMap<String, KafkaLogicalClusterMetadata>();
            updates.put("lkc-abc", this.kafkaLogicalClusterMetadata("lkc-abc", 500, eckuMetadataWith2MaxEcku));
            updates.put("lkc-def", this.kafkaLogicalClusterMetadata("lkc-def", 500, eckuMetadataWith3MaxEcku));
            updates.put("lkc-123", this.kafkaLogicalClusterMetadata("lkc-123", 500, null));
            ctx.policy.onMetadataUpdate(updates);
            Map<String, Integer> allTopicsMap = Map.of("lkc-abc_foo", 15, "lkc-abc_bar", 2, "lkc-def_foo", 25, "lkc-def_bar", 2, "lkc-123_foo", 35, "lkc-123_bar", 10);
            HashSet<String> compactedTopics = new HashSet<String>(Arrays.asList("lkc-abc_foo", "lkc-abc_bar", "lkc-def_foo", "lkc-def_bar", "lkc-123_foo", "lkc-123_bar"));
            ctx.policy.fullUpdate(allTopicsMap.entrySet().iterator(), Collections.emptyMap(), compactedTopics);
            HashMap<String, String> compactTopicConfig = new HashMap<String, String>();
            compactTopicConfig.put("cleanup.policy", "compact");
            Assertions.assertEquals((Object)"You may not create more than the maximum number of compacted partitions (20).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(40), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 3 new compacted partitions. Adding the requested number of partitions will exceed 20 total compacted partitions. Currently, there are 17 total compacted partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(4), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            Assertions.assertDoesNotThrow(() -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(3), Short.valueOf((short)3), null, compactTopicConfig)));
            ctx.policy.partialUpdate("lkc-abc_foobar", 3, 0, new HashMap(), new HashMap(), false, true);
            Assertions.assertEquals((Object)"You may not create more than 0 new compacted partitions. Adding the requested number of partitions will exceed 20 total compacted partitions. Currently, there are 20 total compacted partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foo", Integer.valueOf(5), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than the maximum number of compacted partitions (30).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-def_foobar", Integer.valueOf(40), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 3 new compacted partitions. Adding the requested number of partitions will exceed 30 total compacted partitions. Currently, there are 27 total compacted partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-def_foobar", Integer.valueOf(4), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            Assertions.assertDoesNotThrow(() -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-123_foobar", Integer.valueOf(6), Short.valueOf((short)3), null, compactTopicConfig)));
            ctx.policy.partialUpdate("lkc-123_foobar", 6, 0, new HashMap(), new HashMap(), false, true);
            updates = new HashMap();
            updates.put("lkc-abc", this.kafkaLogicalClusterMetadata("lkc-abc", 500, eckuMetadataWith3MaxEcku));
            ctx.policy.onMetadataUpdate(updates);
            Assertions.assertDoesNotThrow(() -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(3), Short.valueOf((short)3), null, compactTopicConfig)));
            ctx.policy.partialUpdate("lkc-abc_foobar", 3, 0, new HashMap(), new HashMap(), false, true);
            Assertions.assertEquals((Object)"You may not create more than 7 new compacted partitions. Adding the requested number of partitions will exceed 30 total compacted partitions. Currently, there are 23 total compacted partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abc_foobar", Integer.valueOf(13), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            updates.put("lkc-def", this.kafkaLogicalClusterMetadata("lkc-def", 500, eckuMetadataWith4MaxEcku));
            ctx.policy.onMetadataUpdate(updates);
            Assertions.assertEquals((Object)"You may not create more than 13 new compacted partitions. Adding the requested number of partitions will exceed 40 total compacted partitions. Currently, there are 27 total compacted partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-def_f1", Integer.valueOf(14), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
            updates.put("lkc-123", this.kafkaLogicalClusterMetadata("lkc-123", 500, eckuMetadataWith6MaxEcku));
            ctx.policy.onMetadataUpdate(updates);
            Assertions.assertEquals((Object)"You may not create more than 9 new compacted partitions. Adding the requested number of partitions will exceed 60 total compacted partitions. Currently, there are 51 total compacted partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-123_f1", Integer.valueOf(20), Short.valueOf((short)3), null, compactTopicConfig)))).getMessage());
        }
    }

    @Test
    public void testTooManyClusterPartitionsAlreadyCreated() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, 5, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertEquals((Object)"The cluster has reached the maximum number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testInvalidRequestMetadata() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertEquals((Object)"Invalid topic name specified.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Invalid topic name specified.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_::", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Must specify number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Topic replication factor must be 3", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", Integer.valueOf(1), Short.valueOf((short)2), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Must specify number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, Collections.emptyMap(), Collections.emptyMap())))).getMessage());
            HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
            assignments.put(0, Arrays.asList(5, 6, 7, 8));
            assignments.put(1, Arrays.asList(8, 7, 6, 5));
            Assertions.assertEquals((Object)"Topic replication factor must be 3", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, assignments, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testSettingTopicConfigs() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG));
            Assertions.assertEquals((Object)"Altering config property 'foobar' is disallowed.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, INVALID_SAMPLE_TOPIC_CONFIG)))).getMessage());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG)));
        }
    }

    @Test
    public void testFreightTopicConfigs() {
        String allowedCleanupPolicies = "delete;delete,compact";
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE, "delete;delete,compact");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_FREIGHT_TOPIC_CONFIG, TopicType.FREIGHT));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("retention.bytes", "1000000000"), TopicType.FREIGHT));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("retention.ms", "1000000000"), TopicType.FREIGHT));
            Assertions.assertEquals((Object)"The config 'cleanup.policy' does not support the value 'compact' with Freight topics", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("cleanup.policy", "compact"), TopicType.FREIGHT)))).getMessage());
            Assertions.assertEquals((Object)"The config 'confluent.topic.type' does not support the value 'standard' with Freight topics", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("confluent.topic.type", "standard"), TopicType.FREIGHT)))).getMessage());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG, TopicType.FREIGHT)));
        }
    }

    @Test
    public void rejectsInvalidMinInSyncReplicasConfig() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertEquals((Object)"Config property 'min.insync.replicas' with value '0' must be greater or equal to 1 and less than 3, or left empty.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("min.insync.replicas", "0"))))).getMessage());
            Assertions.assertEquals((Object)"Config property 'min.insync.replicas' with value '4' must be greater or equal to 1 and less than 3, or left empty.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("min.insync.replicas", "4"))))).getMessage());
        }
    }

    @Test
    public void rejectsDeleteRetentionMsToHigh() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("delete.retention.ms", "60566400001"))));
        }
    }

    @Test
    public void rejectsSegmentBytesTooLow() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.bytes", "52428799"))));
        }
    }

    @Test
    public void rejectsSegmentBytesTooHigh() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.bytes", "1073741825"))));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void rejectMaxMessageBytesTooHigh(boolean isFreight) {
        TopicType topicType = isFreight ? TopicType.FREIGHT : TopicType.STANDARD;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("max.message.bytes", String.valueOf(0x800001)), topicType)));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void rejectRetentionMsTooHigh(boolean isFreight) {
        TopicType topicType = isFreight ? TopicType.FREIGHT : TopicType.STANDARD;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("retention.ms", String.valueOf(Long.MAX_VALUE)), topicType)));
        }
    }

    @Test
    public void rejectSegmentMsTooLow() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.ms", "500000"))));
        }
    }

    @Test
    public void testNonTenantTopicsAreExempt() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("not-a-tenant-topic", Integer.valueOf(1000), Short.valueOf((short)30), null, Collections.emptyMap()));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("blah_abc", Integer.valueOf(100), Short.valueOf((short)3), null, INVALID_SAMPLE_TOPIC_CONFIG));
        }
    }

    @Test
    public void rejectsWhenTopicMetadataNotSet() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            Assertions.assertThrows(NotControllerException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG)));
        }
    }

    @Test
    public void rejectsWhenLogicalClusterMetadataNotSet() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), Collections.emptySet());
            Assertions.assertThrows(NotControllerException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG)));
        }
    }

    @Test
    public void acceptSchemaValidationPropertiesWhenFeatureEnabled() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 7, Integer.MAX_VALUE, true);){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(2), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG));
        }
    }

    @Test
    public void rejectRequestWithTooManyPartitions() {
        int maxPartitionsPerTenant = 1000;
        int maxPartitionsPerRequest = 100;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, maxPartitionsPerTenant, Integer.MAX_VALUE, Integer.MAX_VALUE, false, maxPartitionsPerRequest, Integer.MAX_VALUE, "delete");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(maxPartitionsPerRequest), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(maxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap())));
        }
    }

    @Test
    public void acceptInternalTopicRequestWithTooManyPartitions() {
        int maxPartitionsPerTenant = 1000;
        int maxPartitionsPerRequest = 100;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, maxPartitionsPerTenant, Integer.MAX_VALUE, Integer.MAX_VALUE, false, maxPartitionsPerRequest, Integer.MAX_VALUE, "delete");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("__consumer_offsets", Integer.valueOf(maxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap()));
        }
    }

    @Test
    public void testReconfigureMaxPartitionsPerRequest() {
        int maxPartitionsPerTenant = 1000;
        int initialMaxPartitionsPerRequest = 100;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, maxPartitionsPerTenant, Integer.MAX_VALUE, Integer.MAX_VALUE, false, initialMaxPartitionsPerRequest, Integer.MAX_VALUE, "delete");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            Assertions.assertTrue((boolean)ctx.policy.reconfigurableConfigs().contains("confluent.multitenant.max.partitions.per.request"));
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(initialMaxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap())));
            int updateMaxPartitionsPerRequest = 200;
            HashMap<String, String> newConfigs = new HashMap<String, String>(ctx.configs);
            newConfigs.put("confluent.multitenant.max.partitions.per.request", String.valueOf(updateMaxPartitionsPerRequest));
            ctx.policy.reconfigure(newConfigs);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(updateMaxPartitionsPerRequest), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(updateMaxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap())));
        }
    }

    @Test
    public void testFullUpdateWithDeletedTenant() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2048, 1000, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE, "delete");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            HashMap<String, Integer> tenantOnePartitions = new HashMap<String, Integer>();
            tenantOnePartitions.put("lkc-tenant1_foo", 1000);
            ctx.policy.fullUpdate(tenantOnePartitions.entrySet().iterator(), new HashMap(), new HashSet());
            HashMap<String, Integer> tenantTwoPartitions = new HashMap<String, Integer>();
            tenantTwoPartitions.put("lkc-tenant2_bar", 500);
            ctx.policy.fullUpdate(tenantTwoPartitions.entrySet().iterator(), new HashMap(), new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-tenant3_quux", Integer.valueOf(500), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-tenant3_quux", Integer.valueOf(501), Short.valueOf((short)3), null, Collections.emptyMap())));
        }
    }

    @Test
    public void testMaxReplicasPerBroker() {
        int maxReplicasPerBroker = 1000;
        HashMap<Integer, Integer> replicasPerBrokerAtCapacity = new HashMap<Integer, Integer>();
        replicasPerBrokerAtCapacity.put(0, maxReplicasPerBroker);
        replicasPerBrokerAtCapacity.put(1, 6);
        HashMap<Integer, Integer> replicasPerBrokerAtUnderCapacity = new HashMap<Integer, Integer>();
        replicasPerBrokerAtUnderCapacity.put(0, maxReplicasPerBroker - 1);
        HashMap<Integer, ArrayList<Integer>> replicaAssignment = new HashMap<Integer, ArrayList<Integer>>();
        replicaAssignment.put(0, new ArrayList<Integer>(Arrays.asList(0, 1, 2)));
        HashMap<Integer, List<Integer>> overReplicasPerBrokerAssignment = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < maxReplicasPerBroker + 1; ++i) {
            overReplicasPerBrokerAssignment.put(i, Arrays.asList(0, 1, 2));
        }
        HashMap<Integer, List<Integer>> underReplicasPerBrokerAssignment = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < maxReplicasPerBroker; ++i) {
            underReplicasPerBrokerAssignment.put(i, Arrays.asList(0, 1, 2));
        }
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, false, Integer.MAX_VALUE, maxReplicasPerBroker, "delete");){
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            Assertions.assertTrue((boolean)ctx.policy.reconfigurableConfigs().contains("confluent.plugins.topic.policy.max.replicas.per.broker"));
            ctx.policy.fullUpdate(Collections.emptyIterator(), Collections.emptyMap(), new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), overReplicasPerBrokerAssignment, Collections.emptyMap())));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), underReplicasPerBrokerAssignment, Collections.emptyMap()));
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), replicasPerBrokerAtUnderCapacity, new HashSet());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), replicasPerBrokerAtCapacity, new HashSet());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap())));
            int additionalReplicasPerBrokerCapacity = 2;
            HashMap<String, String> newConfigs = new HashMap<String, String>(ctx.configs);
            newConfigs.put("confluent.plugins.topic.policy.max.replicas.per.broker", String.valueOf(maxReplicasPerBroker + additionalReplicasPerBrokerCapacity));
            ctx.policy.reconfigure(newConfigs);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
            HashMap<Integer, ArrayList<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, ArrayList<Integer>>();
            partitionIdToReplicasAdded.put(0, new ArrayList<Integer>(Collections.singletonList(0)));
            ctx.policy.partialUpdate("lkc-abcde_quux", 1, 1, partitionIdToReplicasAdded, new HashMap(), false, false);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
            partitionIdToReplicasAdded = new HashMap();
            partitionIdToReplicasAdded.put(1, new ArrayList<Integer>(Arrays.asList(0)));
            ctx.policy.partialUpdate("lkc-abcde_quux", 1, 1, partitionIdToReplicasAdded, new HashMap(), false, false);
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap())));
            HashMap<Integer, ArrayList<Integer>> partitionIdToReplicasRemoved = new HashMap<Integer, ArrayList<Integer>>();
            partitionIdToReplicasRemoved.put(0, new ArrayList<Integer>(Arrays.asList(0)));
            partitionIdToReplicasRemoved.put(1, new ArrayList<Integer>(Arrays.asList(0)));
            ctx.policy.partialUpdate("lkc-abcde_quux", 1, 1, new HashMap(), partitionIdToReplicasRemoved, false, false);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
        }
    }

    @Test
    public void testUpdateTenantMaxPartitions() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith2MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(ELASTIC_CKU_METADATA_DEFAULT_CONFIG);
            eckuMetadataWith2MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 2);
            HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadataWith3MaxEcku = new HashMap<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer>(ELASTIC_CKU_METADATA_DEFAULT_CONFIG);
            eckuMetadataWith3MaxEcku.put(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 3);
            ctx.policy.onMetadataUpdate(Collections.emptyMap());
            Assertions.assertEquals((int)5, (int)ctx.policy.numMaxPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)KafkaLogicalClusterMetadata.COMPACTED_PARTITIONS_PER_TENANT_NO_LIMIT, (int)ctx.policy.numMaxCompactedPartitions("lkc-abcde"));
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("lkc-abcde", this.kafkaLogicalClusterMetadata("lkc-abcde", 5000, eckuMetadataWith2MaxEcku));
            updates.put("lkc-defgh", this.kafkaLogicalClusterMetadata("lkc-defgh", 10000, eckuMetadataWith2MaxEcku));
            updates.put("lkc-invalid", (Object)new TestLogicalClusterMetadata("lkc-invalid", null, null));
            updates.put("lkc-null", null);
            ctx.policy.onMetadataUpdate(updates);
            Assertions.assertEquals((int)200, (int)ctx.policy.numMaxPartitions("lkc-abcde"));
            Assertions.assertEquals((int)20, (int)ctx.policy.numMaxCompactedPartitions("lkc-abcde"));
            Assertions.assertEquals((int)200, (int)ctx.policy.numMaxPartitions("lkc-defgh"));
            Assertions.assertEquals((int)20, (int)ctx.policy.numMaxCompactedPartitions("lkc-defgh"));
            Assertions.assertEquals((int)5, (int)ctx.policy.numMaxPartitions("lkc-fghij"));
            Assertions.assertEquals((int)5, (int)ctx.policy.numMaxPartitions("lkc-null"));
            ctx.policy.onMetadataUpdate(Collections.singletonMap("lkc-abcde", null));
            Assertions.assertEquals((int)5, (int)ctx.policy.numMaxPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)KafkaLogicalClusterMetadata.COMPACTED_PARTITIONS_PER_TENANT_NO_LIMIT, (int)ctx.policy.numMaxCompactedPartitions("lkc-abcde"));
            ctx.policy.onMetadataUpdate(Collections.singletonMap("lkc-defgh", this.kafkaLogicalClusterMetadata("lkc-defgh", 10000, eckuMetadataWith3MaxEcku)));
            Assertions.assertEquals((int)300, (int)ctx.policy.numMaxPartitions("lkc-defgh"));
            Assertions.assertEquals((int)30, (int)ctx.policy.numMaxCompactedPartitions("lkc-defgh"));
            ctx.policy.onMetadataUpdate(Collections.singletonMap("lkc-abcde", this.kafkaLogicalClusterMetadata("lkc-abcde", 10000, ELASTIC_CKU_METADATA_DEFAULT_CONFIG)));
            Assertions.assertEquals((int)100, (int)ctx.policy.numMaxPartitions("lkc-abcde"));
            Assertions.assertEquals((int)10, (int)ctx.policy.numMaxCompactedPartitions("lkc-abcde"));
        }
    }

    @Test
    public void testName() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            Assertions.assertEquals((Object)"CreateTopicPolicy", (Object)ctx.policy.name());
        }
    }

    private KafkaLogicalClusterMetadata kafkaLogicalClusterMetadata(String logicalClusterId, int maxPartitions, Map<ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey, Integer> eckuMetadata) {
        return new KafkaLogicalClusterMetadata(logicalClusterId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Integer.valueOf(maxPartitions), null, null, null, eckuMetadata, null, null);
    }

    static {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("lkc-abcde_foo", 2);
        tmp.put("lkc-abcde_bar", 2);
        tmp.put("baz", 2);
        tmp.put("lkc-fghij_bar", 1);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("max.message.bytes", "10000");
        tmp.put("retention.ms", Integer.toString(Integer.MAX_VALUE));
        tmp.put("min.insync.replicas", "2");
        VALID_SAMPLE_TOPIC_CONFIG = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("cleanup.policy", "delete");
        tmp.put("max.message.bytes", "8388608");
        tmp.put("message.timestamp.before.max.ms", "100");
        tmp.put("message.timestamp.after.max.ms", "100");
        tmp.put("message.timestamp.type", "CreateTime");
        tmp.put("confluent.topic.type", TopicType.FREIGHT.logConfigValue());
        VALID_SAMPLE_FREIGHT_TOPIC_CONFIG = Collections.unmodifiableMap(tmp);
        ELASTIC_CKU_METADATA_DEFAULT_CONFIG = Map.ofEntries(Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.PRODUCE, 0x500000), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.FETCH, 0x500000), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.CONNECTION_ATTEMPT, 250), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.CONNECTION_COUNT, 4500), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT, 90), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT, 10), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.REQUEST_COUNT, 7500), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MIN_ELASTIC_CKU, 1), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, 1), Map.entry(ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.TOTAL_THROUGHPUT, 0xA00000));
        tmp = new HashMap();
        tmp.put("max.message.bytes", "10000");
        tmp.put("foobar", "baz");
        INVALID_SAMPLE_TOPIC_CONFIG = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("confluent.key.schema.validation", "true");
        tmp.put("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        tmp.put("confluent.value.schema.validation", "false");
        tmp.put("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        tmp.put("confluent.schema.validation.context.name", ".customContext");
        SCHEMA_VALIDATION_TOPIC_CONFIG = Collections.unmodifiableMap(tmp);
    }

    static class CreateTopicPolicyTestContext
    implements AutoCloseable {
        final CreateTopicPolicy policy = new CreateTopicPolicy();
        final Metrics metrics;
        final Map<String, String> configs = new HashMap<String, String>();

        CreateTopicPolicyTestContext(int replicationFactor, int maxPartitionsPerTenant, int maxPartitionsPerCluster, boolean schemaValidationEnabled) {
            this(replicationFactor, maxPartitionsPerTenant, maxPartitionsPerCluster, Integer.MAX_VALUE, schemaValidationEnabled, Integer.MAX_VALUE, Integer.MAX_VALUE, "delete");
        }

        CreateTopicPolicyTestContext(int replicationFactor, int maxPartitionsPerTenant, int maxPartitionsPerCluster, int maxTopicsPerCluster, boolean schemaValidationEnabled, int maxPartitionsPerRequest, int maxReplicasPerBroker, String allowedCleanupPolicies) {
            this.configs.put("confluent.plugins.topic.policy.replication.factor", String.valueOf(replicationFactor));
            this.configs.put("confluent.plugins.topic.policy.max.partitions.per.tenant", String.valueOf(maxPartitionsPerTenant));
            this.configs.put("confluent.multitenant.max.partitions.per.request", String.valueOf(maxPartitionsPerRequest));
            this.configs.put("confluent.plugins.topic.policy.max.partitions.per.cluster", String.valueOf(maxPartitionsPerCluster));
            this.configs.put("confluent.plugins.topic.policy.max.topics.per.cluster", String.valueOf(maxTopicsPerCluster));
            this.configs.put("confluent.plugins.topic.policy.max.replicas.per.broker", String.valueOf(maxReplicasPerBroker));
            this.configs.put("confluent.plugins.topic.policy.retention.ms.max", String.valueOf(0x7FFFFFFFFFFFFFFEL));
            this.configs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", allowedCleanupPolicies);
            if (schemaValidationEnabled) {
                this.configs.put("confluent.schema.validator.multitenant.enable", "true");
            }
            this.policy.configure(this.configs);
            this.metrics = new Metrics();
            this.policy.registerMetrics(this.metrics);
        }

        Integer metricValue(String metricName, String tenant) {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("tenant", tenant);
            MetricName name = this.metrics.metricName(metricName, "tenant-metrics", "", tags);
            KafkaMetric metric = this.metrics.metric(name);
            if (metric != null) {
                return (Integer)metric.metricValue();
            }
            return null;
        }

        @Override
        public void close() {
            this.policy.close();
            this.metrics.close();
        }
    }
}

