/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.multitenant.MultiTenantConfigRestrictions;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.server.plugins.policy.AbstractPolicyConfig;
import io.confluent.kafka.server.plugins.policy.ClusterLinkPolicyConfig;
import io.confluent.kafka.server.plugins.policy.PolicyUtils;
import io.confluent.kafka.server.plugins.policy.TopicPolicyConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterConfigPolicy
implements ClusterLinkAlterConfigPolicy {
    private static final Logger log = LoggerFactory.getLogger(AlterConfigPolicy.class);
    private ClusterPolicyConfig clusterPolicyConfig;
    private TopicPolicyConfig topicPolicyConfig;
    private ClusterLinkPolicyConfig clusterLinkPolicyConfig;
    private GroupPolicyConfig groupPolicyConfig;

    public void configure(Map<String, ?> configMap) {
        this.clusterPolicyConfig = new ClusterPolicyConfig(configMap);
        this.topicPolicyConfig = new TopicPolicyConfig(configMap);
        this.clusterLinkPolicyConfig = new ClusterLinkPolicyConfig(configMap);
        this.groupPolicyConfig = new GroupPolicyConfig(configMap);
    }

    public void validate(AlterConfigPolicy.RequestMetadata reqMetadata) throws PolicyViolationException {
        block8: {
            KafkaPrincipal principal;
            block7: {
                principal = reqMetadata.principal();
                if (principal == null) {
                    throw new IllegalArgumentException("Request principal not provided to validate alter policy");
                }
                if (!(principal instanceof MultiTenantPrincipal)) break block7;
                switch (reqMetadata.resource().type()) {
                    case TOPIC: {
                        log.trace("Validating request to update configs using principal {}", (Object)principal);
                        this.topicPolicyConfig.validateTopicConfigs(reqMetadata.configs());
                        break block8;
                    }
                    case BROKER: {
                        this.clusterPolicyConfig.validateBrokerConfigs(reqMetadata);
                        break block8;
                    }
                    case CLUSTER_LINK: {
                        this.clusterLinkPolicyConfig.validateClusterLinkConfigs(reqMetadata.configs());
                        break block8;
                    }
                    case GROUP: {
                        this.groupPolicyConfig.validateGroupConfigs(reqMetadata);
                        break block8;
                    }
                    default: {
                        throw AlterConfigPolicy.configUpdateNotAllowed(reqMetadata);
                    }
                }
            }
            log.info("Allowing update of configs using principal {}", (Object)principal);
        }
    }

    public void clusterLinkValidateTopicConfigs(Map<String, String> configs) {
        this.topicPolicyConfig.validateTopicConfigs(configs);
    }

    public Map<String, String> clusterLinkRestrictTopicConfigs(Map<String, String> configs) {
        return this.topicPolicyConfig.restrictTopicConfigs(configs);
    }

    private static PolicyViolationException configUpdateNotAllowed(AlterConfigPolicy.RequestMetadata reqMetadata) {
        log.debug("Not allowing update of {} configs using principal {}", (Object)reqMetadata.resource().type(), (Object)reqMetadata.principal());
        return new PolicyViolationException("Altering resources of type " + String.valueOf(reqMetadata.resource().type()) + " is not permitted");
    }

    public void close() {
    }

    public static class ClusterPolicyConfig
    extends AbstractPolicyConfig {
        public static final String CONFIG_PREFIX = "confluent.alter.cluster.configs.";
        public static final String ALTER_ENABLE_CONFIG = "confluent.alter.cluster.configs.enable";
        public static final String SSL_CIPHER_SUITES_ALLOWED_CONFIG = "confluent.alter.cluster.configs.ssl.cipher.suites.allowed";
        public static final List<String> DEFAULT_SSL_CIPHER_SUITES_ALLOWED = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        private static final String SSL_CIPHER_SUITES_ALLOWED_DOC = "List of allowed cipher suites for TLS.";
        public static final String SSL_ENABLED_PROTOCOLS_ALLOWED_CONFIG = "confluent.alter.cluster.configs.ssl.enabled.protocols.allowed";
        public static final List<String> DEFAULT_SSL_ENABLED_PROTOCOLS_ALLOWED = Arrays.asList("TLSv1.2", "TLSv1.3");
        private static final String SSL_ENABLED_PROTOCOLS_ALLOWED_DOC = "List of allowed ssl enabled protocols.";
        public static final String NUM_PARTITIONS_MIN_CONFIG = "confluent.alter.cluster.configs.num.partitions.min";
        public static final int DEFAULT_NUM_PARTITIONS_MIN = 1;
        private static final String NUM_PARTITIONS_MIN_DOC = "The minimum value allowed for the default number of partitions.";
        public static final String NUM_PARTITIONS_MAX_CONFIG = "confluent.alter.cluster.configs.num.partitions.max";
        public static final int DEFAULT_NUM_PARTITIONS_MAX = 100;
        private static final String NUM_PARTITIONS_MAX_DOC = "The maximum value allowed for the default number of partitions.";
        public static final String RETENTION_MS_MIN_CONFIG = "confluent.alter.cluster.configs." + ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG + ".min";
        public static final long DEFAULT_RETENTION_MS_MIN = TimeUnit.HOURS.toMillis(1L);
        private static final String RETENTION_MS_MIN_DOC = "The minimum value allowed for retention.ms.";
        public static final String RETENTION_MS_MAX_CONFIG = "confluent.alter.cluster.configs." + ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG + ".max";
        public static final long DEFAULT_RETENTION_MS_MAX = Long.MAX_VALUE;
        private static final String RETENTION_MS_MAX_DOC = "The maximum value allowed for retention.ms.";
        public static final String MAX_COMPACTION_LAG_MS_MIN_CONFIG = "confluent.alter.cluster.configs." + CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP + ".min";
        public static final long DEFAULT_MAX_COMPACTION_LAG_MS_MIN = TopicPolicyConfig.DEFAULT_MAX_COMPACTION_LAG_MS_MIN;
        private static final String MAX_COMPACTION_LAG_MS_MIN_DOC = "The minimum value allowed for max.compaction.lag.ms.";
        private static final ConfigDef CONFIG_DEF;
        static final String EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG;
        static final String EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG;
        private final boolean alterConfigsEnabled;
        private final Set<String> allowedCipherSuites = new HashSet<String>();
        private final Set<String> allowedSslEnabledProtocols = new HashSet<String>();

        ClusterPolicyConfig(Map<String, ?> configMap) {
            super(CONFIG_DEF, configMap);
            this.alterConfigsEnabled = this.getBoolean(ALTER_ENABLE_CONFIG);
            this.allowedCipherSuites.addAll(this.getList(SSL_CIPHER_SUITES_ALLOWED_CONFIG));
            this.allowedSslEnabledProtocols.addAll(this.getList(SSL_ENABLED_PROTOCOLS_ALLOWED_CONFIG));
        }

        public void validateBrokerConfigs(AlterConfigPolicy.RequestMetadata reqMetadata) {
            if (!this.alterConfigsEnabled) {
                throw AlterConfigPolicy.configUpdateNotAllowed(reqMetadata);
            }
            if (!reqMetadata.resource().name().isEmpty()) {
                log.debug("Not allowing update of BROKER configs for broker {}, we only support config updates for all brokers.", (Object)reqMetadata.resource().name());
                throw new PolicyViolationException("`ConfigResource.name` must be empty when updating broker configs in order to update the configuration of all brokers consistently.");
            }
            Map configs = reqMetadata.configs();
            PolicyUtils.validateConfigsAreUpdatable(configs, configName -> MultiTenantConfigRestrictions.UPDATABLE_BROKER_CONFIGS.contains(configName));
            if (configs.containsKey(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG) && Long.parseLong((String)configs.get(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG)) != -1L) {
                this.checkPolicyMin(configs, RETENTION_MS_MIN_CONFIG, ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, 604800000L);
                this.checkPolicyMax(configs, RETENTION_MS_MAX_CONFIG, ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, 604800000L);
            }
            this.checkPolicyMin(configs, NUM_PARTITIONS_MIN_CONFIG, "num.partitions", 1L);
            this.checkPolicyMax(configs, NUM_PARTITIONS_MAX_CONFIG, "num.partitions", 1L);
            this.checkSslCiphers(configs);
            this.checkSslEnabledProtocols(configs);
            this.checkPolicyMin(configs, MAX_COMPACTION_LAG_MS_MIN_CONFIG, CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, Long.MAX_VALUE);
        }

        private void checkSslCiphers(Map<String, String> configs) {
            List<String> ciphers = this.parseList(configs, EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG);
            if (ciphers == null) {
                return;
            }
            boolean foundInvalid = ciphers.stream().anyMatch(c -> !this.allowedCipherSuites.contains(c.toUpperCase(Locale.ROOT)));
            if (foundInvalid) {
                throw new PolicyViolationException(ClusterPolicyConfig.invalidCipherSuiteMessage(this.allowedCipherSuites, configs.get(EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG)));
            }
        }

        private void checkSslEnabledProtocols(Map<String, String> configs) {
            List<String> protocols = this.parseList(configs, EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG);
            if (protocols == null) {
                return;
            }
            boolean foundInvalid = protocols.stream().anyMatch(p -> !this.allowedSslEnabledProtocols.contains(p));
            if (foundInvalid) {
                throw new PolicyViolationException(ClusterPolicyConfig.invalidEnabledProtocolsMessage(this.allowedSslEnabledProtocols, configs.get(EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG)));
            }
        }

        public static String invalidEnabledProtocolsMessage(Collection<String> allowedProtocols, String protocols) {
            return "ssl.enabled.protocols=" + protocols + " contains one or more invalid protocols. Allowed protocols: " + String.valueOf(allowedProtocols);
        }

        public static String invalidCipherSuiteMessage(Collection<String> allowedCipherSuites, String cipherSuites) {
            return "ssl.cipher.suites=" + cipherSuites + " contains one or more invalid cipher suites. Allowed cipher suites: " + String.valueOf(allowedCipherSuites);
        }

        static {
            EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG = MultiTenantConfigRestrictions.EXTERNAL_LISTENER_PREFIX + "ssl.cipher.suites";
            EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG = MultiTenantConfigRestrictions.EXTERNAL_LISTENER_PREFIX + "ssl.enabled.protocols";
            CONFIG_DEF = new ConfigDef().define(ALTER_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Allow AlterConfigs for Broker configs from all listeners").define(SSL_CIPHER_SUITES_ALLOWED_CONFIG, ConfigDef.Type.LIST, DEFAULT_SSL_CIPHER_SUITES_ALLOWED, ConfigDef.Importance.MEDIUM, SSL_CIPHER_SUITES_ALLOWED_DOC).define(SSL_ENABLED_PROTOCOLS_ALLOWED_CONFIG, ConfigDef.Type.LIST, DEFAULT_SSL_ENABLED_PROTOCOLS_ALLOWED, ConfigDef.Importance.MEDIUM, SSL_ENABLED_PROTOCOLS_ALLOWED_DOC).define(NUM_PARTITIONS_MIN_CONFIG, ConfigDef.Type.LONG, (Object)1, ConfigDef.Importance.MEDIUM, NUM_PARTITIONS_MIN_DOC).define(NUM_PARTITIONS_MAX_CONFIG, ConfigDef.Type.LONG, (Object)100, ConfigDef.Importance.MEDIUM, NUM_PARTITIONS_MAX_DOC).define(RETENTION_MS_MIN_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_RETENTION_MS_MIN, ConfigDef.Importance.MEDIUM, RETENTION_MS_MIN_DOC).define(RETENTION_MS_MAX_CONFIG, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, ConfigDef.Importance.MEDIUM, RETENTION_MS_MAX_DOC).define(MAX_COMPACTION_LAG_MS_MIN_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_MAX_COMPACTION_LAG_MS_MIN, ConfigDef.Importance.MEDIUM, MAX_COMPACTION_LAG_MS_MIN_DOC);
        }
    }

    public static class GroupPolicyConfig
    extends AbstractPolicyConfig {
        private static final ConfigDef CONFIG_DEF;
        private static final Set<String> ALLOWED_RESET_STRATEGIES;
        private static final Set<String> ALLOWED_ISOLATION_LEVELS;

        protected GroupPolicyConfig(Map<String, ?> clientConfigs) {
            super(CONFIG_DEF, clientConfigs);
        }

        public void validateGroupConfigs(AlterConfigPolicy.RequestMetadata reqMetadata) {
            Map configs = reqMetadata.configs();
            PolicyUtils.validateConfigsAreUpdatable(configs, MultiTenantConfigRestrictions.UPDATABLE_GROUP_CONFIGS::contains);
            this.checkShareAutoOffsetResetStrategy(configs);
            this.checkShareIsolationLevel(configs);
            this.checkPolicyMin(configs, "group.share.min.record.lock.duration.ms", "share.record.lock.duration.ms", 30000L);
            this.checkPolicyMax(configs, "group.share.max.record.lock.duration.ms", "share.record.lock.duration.ms", 30000L);
            this.checkPolicyMin(configs, "group.share.min.heartbeat.interval.ms", "share.heartbeat.interval.ms", 5000L);
            this.checkPolicyMax(configs, "group.share.max.heartbeat.interval.ms", "share.heartbeat.interval.ms", 5000L);
            this.checkPolicyMin(configs, "group.share.min.session.timeout.ms", "share.session.timeout.ms", 45000L);
            this.checkPolicyMax(configs, "group.share.max.session.timeout.ms", "share.session.timeout.ms", 45000L);
            this.checkPolicyMin(configs, "group.consumer.min.session.timeout.ms", "consumer.session.timeout.ms", 45000L);
            this.checkPolicyMax(configs, "group.consumer.max.session.timeout.ms", "consumer.session.timeout.ms", 45000L);
            this.checkPolicyMin(configs, "group.consumer.min.heartbeat.interval.ms", "consumer.heartbeat.interval.ms", 5000L);
            this.checkPolicyMax(configs, "group.consumer.max.heartbeat.interval.ms", "consumer.heartbeat.interval.ms", 5000L);
        }

        private void checkShareAutoOffsetResetStrategy(Map<String, String> configs) {
            String value = configs.get("share.auto.offset.reset");
            if (value != null && !ALLOWED_RESET_STRATEGIES.contains(value.toLowerCase(Locale.ROOT))) {
                throw new PolicyViolationException(GroupPolicyConfig.invalidAutoOffsetResetStrategy(value));
            }
        }

        private static String invalidAutoOffsetResetStrategy(String strategy) {
            return "share.auto.offset.reset=" + strategy + " is invalid. Allowed auto offset reset strategies are: " + String.valueOf(ALLOWED_RESET_STRATEGIES);
        }

        private void checkShareIsolationLevel(Map<String, String> configs) {
            String value = configs.get("share.isolation.level");
            if (value != null && !ALLOWED_ISOLATION_LEVELS.contains(value.toLowerCase(Locale.ROOT))) {
                throw new PolicyViolationException(GroupPolicyConfig.invalidIsolationLevel(value));
            }
        }

        private static String invalidIsolationLevel(String isolationLevel) {
            return "share.isolation.level=" + isolationLevel + " is invalid. Allowed share isolation levels are: " + String.valueOf(ALLOWED_ISOLATION_LEVELS);
        }

        static {
            ALLOWED_RESET_STRATEGIES = Set.of("latest", "earliest");
            ALLOWED_ISOLATION_LEVELS = Set.of("read_committed", "read_uncommitted");
            CONFIG_DEF = new ConfigDef().define("group.consumer.min.session.timeout.ms", ConfigDef.Type.LONG, (Object)45000, ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers.").define("group.consumer.max.session.timeout.ms", ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers.").define("group.consumer.min.heartbeat.interval.ms", ConfigDef.Type.LONG, (Object)5000, ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for registered consumers.").define("group.consumer.max.heartbeat.interval.ms", ConfigDef.Type.LONG, (Object)15000, ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for registered consumers.").define("group.share.min.record.lock.duration.ms", ConfigDef.Type.LONG, (Object)15000, ConfigDef.Importance.MEDIUM, "The record acquisition lock minimum duration in milliseconds for share groups.").define("group.share.max.record.lock.duration.ms", ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.MEDIUM, "The record acquisition lock maximum duration in milliseconds for share groups.").define("group.share.min.heartbeat.interval.ms", ConfigDef.Type.LONG, (Object)5000, ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for share group members.").define("group.share.max.heartbeat.interval.ms", ConfigDef.Type.LONG, (Object)15000, ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for share group members.").define("group.share.min.session.timeout.ms", ConfigDef.Type.LONG, (Object)45000, ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for share group members.").define("group.share.max.session.timeout.ms", ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for share group members.");
        }
    }
}

