/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.license.AddOnLicenseManager;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseChanged;
import io.confluent.license.LicenseManager;
import io.confluent.license.LicenseManagerPurpose;
import io.confluent.license.LicenseStoreFactory;
import io.confluent.license.store.ConfluentLicenseStore;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddOnLicenseManagerImpl
implements AddOnLicenseManager {
    private static final Logger log = LoggerFactory.getLogger(AddOnLicenseManagerImpl.class);
    private final ConfluentLicenseStore addOnLicenseStore;
    private final LicenseManager delegate;

    public AddOnLicenseManagerImpl(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, LicenseManagerPurpose purpose, String licenseString) {
        if (purpose.equals((Object)LicenseManagerPurpose.PRIMARY)) {
            throw new IllegalArgumentException("Addon License Manager cannot have Primary purpose");
        }
        this.addOnLicenseStore = LicenseStoreFactory.createAddOnLicenseStore(topic, producerConfig, consumerConfig, topicConfig, purpose);
        this.delegate = new LicenseManager(this.addOnLicenseStore, licenseString, purpose);
        this.addOnLicenseStore.start();
    }

    public AddOnLicenseManagerImpl(ConfluentLicenseStore store, LicenseManagerPurpose purpose, String licenseString, Time time) {
        if (purpose.equals((Object)LicenseManagerPurpose.PRIMARY)) {
            throw new IllegalArgumentException("Addon License Manager cannot have Primary purpose");
        }
        this.addOnLicenseStore = store;
        this.delegate = new LicenseManager(this.addOnLicenseStore, licenseString, purpose, time);
        store.start();
    }

    @Override
    public License registerOrValidateAddOnLicense(String license) throws InvalidLicenseException {
        return this.delegate.registerOrValidateAddOnLicense(license);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public boolean addListener(Consumer<LicenseChanged> listener) {
        return this.delegate.addListener(listener);
    }
}

