/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.license;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractScheduledService;
import io.confluent.common.security.license.LicenseEventListener;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLicenseBackgroundFetcher
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(MultiLicenseBackgroundFetcher.class);
    private static final int DEFAULT_REFRESH_INTERVAL_MS = 30000;
    private final int refreshIntervalMs;
    private final String topic;
    private final Map<String, Object> producerConfig;
    private final Map<String, Object> consumerConfig;
    private final Map<String, Object> topicConfig;
    private final List<LicenseEventListener> listeners;
    protected final AtomicReference<List<License>> cacheLicenses = new AtomicReference();
    private LicenseManager licenseManager;

    public MultiLicenseBackgroundFetcher(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.consumerConfig = consumerConfig;
        this.topicConfig = topicConfig;
        this.refreshIntervalMs = 30000;
        this.listeners = new CopyOnWriteArrayList<LicenseEventListener>();
    }

    public MultiLicenseBackgroundFetcher(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, int refreshIntervalMs) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.consumerConfig = consumerConfig;
        this.topicConfig = topicConfig;
        this.refreshIntervalMs = refreshIntervalMs;
        this.listeners = new CopyOnWriteArrayList<LicenseEventListener>();
    }

    public void addListener(LicenseEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LicenseEventListener listener) {
        this.listeners.remove(listener);
    }

    public void shutDown() {
        if (this.licenseManager != null) {
            log.info("Shutting down License Manager...");
            this.licenseManager.stop();
        }
    }

    public List<License> registerLicenseThenNotify(String license, Boolean skipTrialLicense) {
        if (this.licenseManager == null) {
            log.info("Setting up License Manager...");
            this.licenseManager = new LicenseManager(this.topic, this.producerConfig, this.consumerConfig, this.topicConfig);
            log.info("Finished setting up License Manager.");
        }
        log.info("Attempting to register/validate license. Skip trial: {}", (Object)skipTrialLicense);
        List validatedLicenses = this.licenseManager.registerOrValidateMultiLicense(license, skipTrialLicense.booleanValue());
        log.debug("Successfully validated {} licenses", (Object)validatedLicenses.size());
        this.cacheLicenses.set(validatedLicenses);
        this.notifyListeners(listener -> listener.onLicenseValidated(validatedLicenses));
        return validatedLicenses;
    }

    public List<License> readLicenses() {
        return this.registerLicenseThenNotify("", true);
    }

    protected void runOneIteration() {
        try {
            this.registerLicenseThenNotify("", true);
        }
        catch (InvalidLicenseException e) {
            this.notifyListeners(listener -> listener.onLicenseValidationFailure(e));
        }
        catch (Exception e) {
            this.notifyListeners(listener -> listener.onLicenseValidated(this.cacheLicenses.get()));
            log.error("Can not validate license due to", (Throwable)e);
        }
    }

    protected void notifyListeners(ListenerAction action) {
        for (LicenseEventListener listener : this.listeners) {
            try {
                action.notify(listener);
            }
            catch (Exception e) {
                log.error("Error notifying listener: {}", listener.getClass(), (Object)e);
            }
        }
    }

    public boolean hasValidLicense() {
        List<License> licenseList = this.cacheLicenses.get();
        return licenseList != null && licenseList.stream().anyMatch(License::isValid);
    }

    @VisibleForTesting
    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        this.runOneIteration();
    }

    @VisibleForTesting
    public List<License> getCachedLicenses() {
        return this.cacheLicenses.get();
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        log.debug("Scheduling license fetcher to run every {}ms.", (Object)this.refreshIntervalMs);
        return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)0L, (long)this.refreshIntervalMs, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @FunctionalInterface
    protected static interface ListenerAction {
        public void notify(LicenseEventListener var1);
    }
}

