/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtils {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    public static PublicKey loadPublicKey(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
            PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(keyInfo);
            return publicKey;
        }
    }

    public static void writePublicKey(OutputStream out, PublicKey key) throws IOException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(out, "utf8"));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)key));
        }
    }

    public static KeyPair loadKeyPair(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            Object pemKeypairObject = pemParser.readObject();
            if (pemKeypairObject instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)pemKeypairObject;
                KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
                return keyPair;
            }
            if (pemKeypairObject instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemKeypairObject;
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                PublicKey publicKey = PemUtils.getPublicKeyFromPrivateKeyInfo(privateKeyInfo);
                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                return keyPair;
            }
            throw new IOException("Unsupported PEM object type: " + String.valueOf(pemKeypairObject.getClass()));
        }
    }

    public static KeyPair loadKeyPair(InputStream inputStream, String password) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            KeyPair keyPair;
            try (PEMParser pemParser = new PEMParser((Reader)reader);){
                PrivateKeyInfo privateKeyInfo;
                InputDecryptorProvider inputDecryptorProvider;
                Object object = pemParser.readObject();
                PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object;
                try {
                    inputDecryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
                }
                catch (OperatorCreationException e) {
                    throw new IOException("Unable to create decryptor: ", e);
                }
                try {
                    privateKeyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
                }
                catch (PKCSException e) {
                    throw new IOException("Unable to decrypt private key: ", e);
                }
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                PublicKey publicKey = PemUtils.getPublicKeyFromPrivateKeyInfo(privateKeyInfo);
                keyPair = new KeyPair(publicKey, privateKey);
            }
            return keyPair;
        }
    }

    public static PublicKey getPublicKeyFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        PemObject oldPemObject = new JcaMiscPEMGenerator((Object)privateKey, null).generate();
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        pemWriter.writeObject((PemObjectGenerator)oldPemObject);
        pemWriter.close();
        Object pair = new PEMParser((Reader)new StringReader(writer.toString())).readObject();
        return new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)pair).getPublic();
    }

    public static void writeKeyPair(OutputStream out, KeyPair keyPair) throws IOException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(out, "utf8"));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)keyPair));
        }
    }
}

