/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logevents.connect;

import io.confluent.telemetry.events.exporter.ExporterConfig;
import io.confluent.telemetry.events.exporter.kafka.EventKafkaExporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class LogEventsConfig
extends AbstractConfig {
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String CONFLUENT_EVENT_LOGGER_PREFIX = "confluent.event.logger.";
    private static final String KAFKA_EXPORTER_PREFIX = "exporter.kafka.";
    public static final String CONFLUENT_EVENT_LOGGER_KAFKA_EXPORTER_PREFIX = "confluent.event.logger.exporter.kafka.";
    public static final String LOGGER_ENABLE_CONFIG = "confluent.event.logger.enable";
    public static final String DEFAULT_LOGGER_ENABLE = "false";
    public static final String LOGGER_ENABLE_DOC = "Flag to toggle connect log events in this connect cluster";
    public static final String LOGGER_BOOTSTRAP_SERVERS_CONFIG = "confluent.event.logger.exporter.kafka.producer.bootstrap.servers";
    public static final String DEFAULT_LOGGER_BOOTSTRAP_SERVERS = "";
    public static final String LOGGER_EVENT_EXPORTER_CLASS_CONFIG = "confluent.event.logger.exporter.class";
    public static final String DEFAULT_EVENT_EXPORTER_CLASS_CONFIG = EventKafkaExporter.class.getCanonicalName();
    public static final String LOGGER_CLOUD_EVENT_ENCODING_CONFIG = "confluent.event.logger.cloudevent.codec";
    public static final String LOGGER_TOPIC_CREATE_CONFIG = "confluent.event.logger.exporter.kafka.topic.create";
    public static final boolean DEFAULT_TOPIC_CREATE_CONFIG = true;
    public static final String LOGGER_EXPORTER_TYPE_CONFIG = "confluent.event.logger.exporter.kafka.type";
    public static final String LOGGER_EXPORTER_TYPE_DEFAULT = ExporterConfig.ExporterType.kafka.name();
    public static final String LOGGER_LOG_EVENTS_TOPIC_CONFIG = "confluent.event.logger.exporter.kafka.topic.name";
    public static final String DEFAULT_TOPIC = "confluent-connect-log-events";
    public static final String LOGGER_CLIENT_ID_CONFIG = "confluent.event.logger.exporter.kafka.producer.client.id";
    public static final String LOGGER_CLIENT_ID_DOC = "Client id for the producer used to emit Connect Log Events";
    public static final String DEFAULT_LOGGER_CLIENT_ID = "confluent-connect-log-events-emitter";
    public static final String LOG_EVENTS_DEDUPLICATE_ERRORS = "confluent.event.logger.deduplicate.errors";
    protected static final Boolean LOG_EVENTS_DEDUPLICATE_ERRORS_DEFAULT = false;
    protected static final String LOG_EVENTS_DEDUPLICATE_ERRORS_DOC = "Enable deduplication of Connect Log events of connector and task failures.";
    public static final String LOG_EVENTS_FAILURE_EVENT_RESET_TIME = "confluent.event.logger.deduplicate.errors.reset.time.ms";
    protected static final String LOG_EVENTS_FAILURE_EVENT_RESET_TIME_DOC = "Deduplication reset time window in milliseconds for a connector/task's failure log event. Once this window elapses, following log event will be captured even if its a duplicate. This config regulates the time duration for which duplicates should be avoided. If log event deduplication is requested, the reset window should atleast be 10 mins.";
    public static final Long LOG_EVENTS_FAILURE_EVENT_MAP_CLEANUP_TIME_DEFAULT = TimeUnit.HOURS.toMillis(1L);
    protected static final Long LOG_EVENTS_FAILURE_EVENT_RESET_TIME_DEFAULT = TimeUnit.HOURS.toMillis(12L);
    public static final String AUTHORITY_NAME = "confluent.cloud";
    public static final String NAMED_BOOTSTRAP_SERVERS_CONFIG_ENABLED = "confluent.event.logger.named.config.enabled";
    public static final boolean NAMED_BOOTSTRAP_SERVERS_CONFIG_ENABLED_DEFAULT = false;
    public static final String NAMED_BOOTSTRAP_SERVERS_CONFIG_ENABLED_DOC = "Configuration to enable named bootstrap servers configuration for routing Connect Log events to topics. This configuration would be used for Disaster Recovery Switch for Connect Event Logs";
    public static final String CONFLUENT_LOG_PREFIX_REMOTE_CONFIG = "confluent.event.logger.remoteconfig.";
    public static final String CONFLUENT_LOG_REMOTE_CONFIG_CLOUD = "cloud.";
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.event.logger.enable", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.HIGH, "Flag to toggle connect log events in this connect cluster").define("confluent.event.logger.exporter.class", ConfigDef.Type.CLASS, (Object)DEFAULT_EVENT_EXPORTER_CLASS_CONFIG, ConfigDef.Importance.HIGH, "Class to use for delivering event logs.").define("confluent.event.logger.exporter.kafka.topic.create", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Create the topic if it does not exist.").define("confluent.event.logger.exporter.kafka.producer.bootstrap.servers", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example.").define("confluent.event.logger.cloudevent.codec", ConfigDef.Type.STRING, (Object)"binary", ConfigDef.Importance.LOW, "Which cloudevent encoding to use. Use structured encoding by default").define("confluent.event.logger.exporter.kafka.type", ConfigDef.Type.STRING, (Object)LOGGER_EXPORTER_TYPE_DEFAULT, ConfigDef.Importance.LOW, ExporterConfig.TYPE_CONFIG_DOC).define("confluent.event.logger.exporter.kafka.topic.name", ConfigDef.Type.STRING, (Object)"confluent-connect-log-events", ConfigDef.Importance.LOW, "Topic to which telemetry data will be written.").define("confluent.event.logger.deduplicate.errors", ConfigDef.Type.BOOLEAN, (Object)LOG_EVENTS_DEDUPLICATE_ERRORS_DEFAULT, ConfigDef.Importance.LOW, "Enable deduplication of Connect Log events of connector and task failures.").define("confluent.event.logger.deduplicate.errors.reset.time.ms", ConfigDef.Type.LONG, (Object)LOG_EVENTS_FAILURE_EVENT_RESET_TIME_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)600000), ConfigDef.Importance.LOW, "Deduplication reset time window in milliseconds for a connector/task's failure log event. Once this window elapses, following log event will be captured even if its a duplicate. This config regulates the time duration for which duplicates should be avoided. If log event deduplication is requested, the reset window should atleast be 10 mins.").define("confluent.event.logger.named.config.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Configuration to enable named bootstrap servers configuration for routing Connect Log events to topics. This configuration would be used for Disaster Recovery Switch for Connect Event Logs");

    public Map<String, Object> toEventLoggerConfig() throws ConfigException {
        HashMap<String, Object> eventLoggerConfig = new HashMap<String, Object>();
        LogEventsConfig.populateEventLoggerConfigs(this.values(), eventLoggerConfig);
        LogEventsConfig.populateEventLoggerConfigs(this.originals(), eventLoggerConfig);
        if (((String)eventLoggerConfig.get("producer.bootstrap.servers")).isEmpty()) {
            throw new ConfigException("Missing required configuration confluent.event.logger.exporter.kafka.producer.bootstrap.servers");
        }
        return eventLoggerConfig;
    }

    public LogEventsConfig(Map<?, ?> originals) {
        super(LogEventsConfig.addConnectLoggerClientId(CONFIG, originals), originals);
    }

    public Boolean logEventsDeduplicateErrors() {
        return this.getBoolean(LOG_EVENTS_DEDUPLICATE_ERRORS);
    }

    public long logFailureEventResetTime() {
        return this.getLong(LOG_EVENTS_FAILURE_EVENT_RESET_TIME);
    }

    private static void populateEventLoggerConfigs(Map<String, ?> properties, Map<String, Object> eventLoggerConfig) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            if (entry.getKey().startsWith(CONFLUENT_EVENT_LOGGER_KAFKA_EXPORTER_PREFIX)) {
                eventLoggerConfig.put(entry.getKey().substring(CONFLUENT_EVENT_LOGGER_KAFKA_EXPORTER_PREFIX.length()), entry.getValue());
                continue;
            }
            if (!entry.getKey().startsWith(CONFLUENT_EVENT_LOGGER_PREFIX)) continue;
            eventLoggerConfig.put(entry.getKey().substring(CONFLUENT_PREFIX.length()), entry.getValue());
        }
    }

    private static ConfigDef addConnectLoggerClientId(ConfigDef definition, Map<?, ?> properties) {
        String defaultValue = DEFAULT_LOGGER_CLIENT_ID;
        Optional<String> groupId = Optional.ofNullable((String)properties.get("group.id"));
        if (groupId.isPresent()) {
            defaultValue = defaultValue + "-" + groupId.get();
        }
        ConfigDef configDef = new ConfigDef(definition);
        configDef.defineInternal(LOGGER_CLIENT_ID_CONFIG, ConfigDef.Type.STRING, (Object)defaultValue, ConfigDef.Importance.LOW, LOGGER_CLIENT_ID_DOC);
        return configDef;
    }
}

