/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.DelegatingAdminClient;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;

public class CachingBootstrapClientSupplier
implements BootstrapClientSupplier,
AutoCloseable {
    private final BootstrapClientConfigSupplier config;
    private final Supplier<AdminClient> supplier;
    private volatile AdminClient client;

    @Inject
    public CachingBootstrapClientSupplier(BootstrapClientConfigSupplier config) {
        this.config = config;
        this.supplier = Suppliers.memoize((Supplier)new Supplier<AdminClient>(){

            public AdminClient get() {
                return CachingBootstrapClientSupplier.this.createClient();
            }
        });
    }

    private AdminClient createClient() {
        this.client = AdminClient.create((Map)this.config.get());
        return new DelegatingAdminClient(this.client){

            @Override
            public void close() {
            }

            @Override
            public void close(long duration, TimeUnit unit) {
            }
        };
    }

    @Override
    public AdminClient get() {
        return (AdminClient)this.supplier.get();
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

