/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.C3Version;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.CachingBootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.schemaregistry.CachingSchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientManager;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.controlcenter.streams.SingleGroupPartitionGrouper;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.util.DefaultZkUtilsFactory;
import io.confluent.controlcenter.util.TopicInfo;
import io.confluent.controlcenter.util.ZkUtilsFactory;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.record.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterConfigModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterConfigModule.class);
    private final ControlCenterConfig controlCenterConfig;
    private final boolean enableSubTopologies;
    private final ImmutableSet<String> subTopologyTopics;

    public ControlCenterConfigModule(ControlCenterConfig controlCenterConfig) {
        this(controlCenterConfig, false, null);
    }

    public ControlCenterConfigModule(ControlCenterConfig controlCenterConfig, boolean enableSubTopologies, ImmutableSet<String> subTopologyTopics) {
        this.controlCenterConfig = controlCenterConfig;
        this.enableSubTopologies = enableSubTopologies;
        this.subTopologyTopics = subTopologyTopics;
    }

    protected void configure() {
        this.bind(BootstrapClientSupplier.class).to(CachingBootstrapClientSupplier.class).in(Singleton.class);
        this.bind(Key.get(String.class, HealthCheckModule.SessionId.class)).toInstance((Object)UUID.randomUUID().toString());
        if (this.enableSubTopologies) {
            this.requestStaticInjection(new Class[]{SingleGroupPartitionGrouper.class});
        }
    }

    @Provides
    protected ControlCenterConfig provideControlCenterConfig() {
        return this.controlCenterConfig;
    }

    @Provides
    @EnableSubTopologies
    protected boolean areSubTopologiesEnabled() {
        return this.enableSubTopologies;
    }

    @Provides
    @SubTopologyInputTopics
    protected ImmutableSet<String> provideSubTopologyTopics() {
        return this.subTopologyTopics;
    }

    @Provides
    @Inject
    @Singleton
    protected Version provideControlCenterVersion() throws IOException {
        return C3Version.getVersion();
    }

    @Provides
    @Inject
    protected ZkUtilsFactory getZkUtilsFactory() {
        return new DefaultZkUtilsFactory();
    }

    @Provides
    @HealthCheckModule.PhoneHomeEnabled
    @Inject
    protected boolean getPhoneHomeEnabled(ControlCenterConfig config) {
        return config.getBoolean("confluent.support.metrics.enable");
    }

    @Provides
    @HealthCheckModule.PhoneHomeCustomerId
    @Inject
    protected String getPhoneHomeCustomerId(ControlCenterConfig config) {
        return config.getString("confluent.support.metrics.customer.id");
    }

    @Provides
    @HealthCheckModule.ControlCenterInstance
    @Inject
    @Singleton
    protected String getControlCenterInstance(ControlCenterConfig config) {
        return Hashing.sha256().newHasher().putString((CharSequence)Joiner.on((char)'\u00ff').join((Object)config.getString("confluent.controlcenter.id"), (Object)config.getString("confluent.controlcenter.command.topic"), new Object[]{config.getString("confluent.metrics.topic"), config.getString("confluent.monitoring.interceptor.topic")}), Charsets.UTF_8).hash().toString();
    }

    @Provides
    @ControlCenterRestModule.DisplayHost
    @Inject
    protected String getDisplayHost(ControlCenterConfig config) {
        return config.getString("confluent.controlcenter.rest.advertised.url");
    }

    @Provides
    @Inject
    protected RestConfig getRestConfig(ControlCenterConfig config, ControlCenterRbacConfig rbacConfig) {
        HashMap props = Maps.newHashMap();
        props.putAll(config.valuesWithPrefix("confluent.controlcenter.rest."));
        props.putAll(config.originalsWithPrefix("confluent.controlcenter.rest."));
        if (rbacConfig.isRbacEnabled()) {
            props.put("authentication.roles", ImmutableList.of((Object)"**"));
        }
        return new RestConfig(RestConfig.baseConfigDef(), (Map)props);
    }

    @Provides
    @Inject
    @Singleton
    protected ControlCenterRbacConfig getRbacConfig(ControlCenterConfig controlCenterConfig) {
        return ControlCenterRbacConfig.fromControlCenterConfig(controlCenterConfig);
    }

    @Provides
    @Singleton
    @Inject
    BootstrapClientConfigSupplier adminClientConfig(ControlCenterConfig controlCenterConfig, ControlCenterRbacConfig rbacConfig) {
        final HashMap config = Maps.newHashMap();
        config.put("bootstrap.servers", controlCenterConfig.getList("bootstrap.servers"));
        rbacConfig.putAllIfAbsentRbacControlCenterConfigs(config);
        config.putAll(controlCenterConfig.valuesWithPrefix("confluent.controlcenter.streams."));
        config.putAll(controlCenterConfig.originalsWithPrefix("confluent.controlcenter.streams."));
        return new BootstrapClientConfigSupplier(){

            @Override
            public Map<String, Object> get() {
                return config;
            }
        };
    }

    @Provides
    @Inject
    @RestModule.BrokerConfigsEditEnabled
    boolean brokerConfigsEditEnabled(ControlCenterConfig config) {
        return config.getBoolean("confluent.controlcenter.broker.config.edit.enable");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.KafkaClusterConfigSupplier
    StaticClusterConfigSupplier provideKafkaClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.kafka.");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.ConnectClusterConfigSupplier
    StaticClusterConfigSupplier provideConnectClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.connect.");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.KsqlClusterConfigSupplier
    StaticClusterConfigSupplier provideKsqlClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.ksql.");
    }

    @Provides
    @Inject
    @Singleton
    protected KsqlClusterMetadata provideKsqlMetadata(@ControlCenterRestModule.KsqlClusterConfigSupplier StaticClusterConfigSupplier staticKsqlClusterConfigSupplier, ControlCenterConfig config) {
        return new KsqlClusterMetadata(staticKsqlClusterConfigSupplier, config);
    }

    @Provides
    @Singleton
    @Inject
    @RestModule.SchemaRegistry
    List<String> getSchemaRegistryEndpoints(ControlCenterConfig config) {
        return config.getList("confluent.controlcenter.schema.registry.url");
    }

    @Provides
    @Singleton
    @Inject
    @RestModule.SchemaRegistry
    Map<String, Object> schemaRegistryClientConfig(ControlCenterConfig controlCenterConfig) {
        HashMap config = Maps.newHashMap();
        config.putAll(controlCenterConfig.originalsWithPrefix("confluent.controlcenter.schema.registry."));
        return config;
    }

    @Provides
    @Singleton
    @Inject
    SchemaRegistryClientManager getSchemaRegistryClientManager(@RestModule.SchemaRegistry List<String> schemaRegistryUrls, @RestModule.SchemaRegistry Map<String, Object> configs, ControlCenterRbacConfig rbacConfig) {
        return new SchemaRegistryClientManager(schemaRegistryUrls, configs, rbacConfig);
    }

    @Provides
    @Singleton
    @Inject
    SchemaRegistryClientSupplier<String> getSchemaRegistryClientSupplier(SchemaRegistryClientManager schemaRegistryClientManager) {
        return new CachingSchemaRegistryClientSupplier<String>(schemaRegistryClientManager);
    }

    @Provides
    @ControlTopics
    @Inject
    protected Set<TopicInfo> getControlTopics(ControlCenterConfig config, TopicStoreMaster topicStoreMaster) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int internalPartitions = config.getInt("confluent.controlcenter.internal.topics.partitions");
        short internalReplication = config.getShort("confluent.controlcenter.internal.topics.replication");
        long internalRetentionMs = config.getLong("confluent.controlcenter.internal.topics.retention.ms");
        long internalRetentionBytes = config.getLong("confluent.controlcenter.internal.topics.retention.bytes");
        long internalChangelogSegmentBytes = config.getLong("confluent.controlcenter.internal.topics.changelog.segment.bytes");
        log.info("getPersistentStoreTopicNames={}", topicStoreMaster.getPersistentStoreTopicNames());
        for (String name : topicStoreMaster.getPersistentStoreTopicNames()) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).setCompact().setSegmentBytes(internalChangelogSegmentBytes).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).build());
        }
        log.info("getLruStoreTopicNames={}", topicStoreMaster.getLruStoreTopicNames());
        for (String name : topicStoreMaster.getLruStoreTopicNames()) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).setCompact().setSegmentBytes(internalChangelogSegmentBytes / 2L).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).build());
        }
        log.info("getWindowedStoreTopicNames={}", topicStoreMaster.getWindowedStoreTopicNames());
        for (String name : topicStoreMaster.getWindowedStoreTopicNames()) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).setCompactDelete().setSegmentBytes(internalChangelogSegmentBytes).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).build());
        }
        log.info("getLogAppendTimeIntermediateTopicNames={}", topicStoreMaster.getLogAppendTimeIntermediateTopicNames());
        for (String name : topicStoreMaster.getLogAppendTimeIntermediateTopicNames()) {
            builder.add((Object)TopicInfo.builder().setPartitions(internalPartitions).setReplication(internalReplication).setDelete().setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).addConfigEntry("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name).build());
        }
        Sets.SetView intermediateTopics = Sets.difference(topicStoreMaster.getIntermediateTopicNames(), topicStoreMaster.getLogAppendTimeIntermediateTopicNames());
        log.info("intermediateTopics={}", (Object)intermediateTopics);
        for (String name : intermediateTopics) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setDelete().setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).build());
        }
        builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setName(config.getString("confluent.controlcenter.command.topic")).setPartitions(1).setReplication(config.getShort("confluent.controlcenter.command.topic.replication")).setDeleteRetentionMs(config.getLong("confluent.controlcenter.command.topic.retention.ms")).setSegmentBytes(config.getLong("confluent.controlcenter.internal.topics.changelog.segment.bytes")).setCompact().build());
        builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).setName(config.getString("confluent.monitoring.interceptor.topic")).setPartitions(config.getInt("confluent.monitoring.interceptor.topic.partitions")).setReplication(config.getShort("confluent.monitoring.interceptor.topic.replication")).setDelete().setRetentionMs(config.getLong("confluent.monitoring.interceptor.topic.retention.ms")).setRetentionBytes(config.getLong("confluent.monitoring.interceptor.topic.retention.bytes")).addConfigEntry("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name).setValidateConfig(config.getBoolean("confluent.monitoring.interceptor.topic.config.validate")).build());
        builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setName(config.getString("confluent.metrics.topic")).setPartitions(config.getInt("confluent.metrics.topic.partitions")).setDelete().setReplication(config.getShort("confluent.metrics.topic.replication")).setRetentionMs(config.getLong("confluent.metrics.topic.retention.ms")).setRetentionBytes(config.getLong("confluent.metrics.topic.retention.bytes")).addConfigEntry("max.message.bytes", config.getInt("confluent.metrics.topic.max.message.bytes")).setValidateConfig(config.getBoolean("confluent.metrics.topic.config.validate")).build());
        return builder.build();
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SubTopologyInputTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface EnableSubTopologies {
    }
}

