/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.protobuf.Descriptors;
import io.confluent.controlcenter.alert.EmailSender;
import io.confluent.controlcenter.alert.WebhooksSender;
import io.confluent.controlcenter.alert.record.Alert;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertSenderRouter {
    private final EmailSender emailSender;
    private final WebhooksSender webHooksSender;
    private final AtomicBoolean alertPaused;
    private static final Descriptors.FieldDescriptor EMAIL_FIELD = Alert.ActionInfo.getDescriptor().findFieldByNumber(3);
    private static final Descriptors.FieldDescriptor WEBHOOK_FIELD = Alert.ActionInfo.getDescriptor().findFieldByNumber(4);
    private static final Logger log = LoggerFactory.getLogger(AlertSenderRouter.class);

    public AlertSenderRouter(EmailSender emailSender, WebhooksSender webHooksSender, AtomicBoolean alertsPaused) {
        this.emailSender = emailSender;
        this.webHooksSender = webHooksSender;
        this.alertPaused = alertsPaused;
    }

    public void sendWithHistory(Alert.AlertInfo alertInfo) {
        if (!this.alertPaused.get()) {
            for (Alert.ActionInfo actionInfo : alertInfo.getActionsList()) {
                if (actionInfo.hasField(EMAIL_FIELD)) {
                    this.emailSender.send(alertInfo, actionInfo, true);
                    continue;
                }
                if (!actionInfo.hasField(WEBHOOK_FIELD)) continue;
                this.webHooksSender.send(alertInfo, actionInfo, true);
            }
        } else {
            log.debug("Ignore alerts since global alerts are paused.");
        }
    }

    public void sendWithoutHistory(Alert.AlertInfo alertInfo) {
        if (!this.alertPaused.get()) {
            for (Alert.ActionInfo actionInfo : alertInfo.getActionsList()) {
                if (actionInfo.hasField(EMAIL_FIELD)) {
                    this.emailSender.send(alertInfo, actionInfo, false);
                    continue;
                }
                if (!actionInfo.hasField(WEBHOOK_FIELD)) continue;
                this.webHooksSender.send(alertInfo, actionInfo, false);
            }
        } else {
            log.debug("Ignore alerts since global alerts are paused.");
        }
    }
}

