/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.common.base.Joiner;
import com.google.protobuf.ProtocolStringList;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.TriggerConfigUtil;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.record.Controlcenter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerEventUtil {
    private static final Logger log = LoggerFactory.getLogger(TriggerEventUtil.class);
    public static final String CLIENT_MONITORING_METRIC_NAME = "client-monitoring";

    public static boolean createTriggerEventsIfTriggerable(Controlcenter.TriggerMeasurement triggerMeasurement, List<KeyValue<Bytes, Controlcenter.TriggerEvent>> triggerList, long now, Collection<KeyValue<Command.CommandKey, Command.CommandMessage>> triggerConfigs) {
        return TriggerEventUtil.createTriggerEventsIfTriggerable(Bytes.wrap((byte[])new byte[0]), triggerMeasurement, triggerList, now, triggerConfigs);
    }

    public static boolean createTriggerEventsIfTriggerable(Bytes triggerKey, Controlcenter.TriggerMeasurement triggerMeasurement, List<KeyValue<Bytes, Controlcenter.TriggerEvent>> triggerList, long now, Collection<KeyValue<Command.CommandKey, Command.CommandMessage>> triggerConfigs) {
        boolean waitForAtLeastOneTrigger = false;
        try {
            for (KeyValue<Command.CommandKey, Command.CommandMessage> triggerConfigKv : triggerConfigs) {
                Long deadline;
                block16: {
                    Alert.TriggerInfo.Builder info;
                    CommandAlert.MonitoringTriggerConfig triggerConfig;
                    block19: {
                        block17: {
                            block18: {
                                triggerConfig = ((Command.CommandMessage)triggerConfigKv.value).getMonitoringTriggerConfig();
                                if (!TriggerEventUtil.isMeasurementTriggerable(triggerMeasurement, triggerConfig)) continue;
                                deadline = triggerMeasurement.getArrivalTime() + triggerConfig.getLagMs();
                                Long lastTriggerTimestamp = triggerMeasurement.getLastTriggerEventTimestamp();
                                log.info("now={} deadline={} lastTriggerTimstamp={}", new Object[]{now, deadline, lastTriggerTimestamp});
                                if (deadline > now || deadline <= lastTriggerTimestamp) break block16;
                                info = Alert.TriggerInfo.newBuilder().setWindow(triggerMeasurement.getWindow());
                                if (TriggerEventUtil.isBrokerOrBrokerCluster(triggerMeasurement)) {
                                    Alert.BrokerClusterComponent.Builder brokerClusterBuilder = Alert.BrokerClusterComponent.newBuilder().setClusterId(triggerMeasurement.getClusterId());
                                    if (triggerMeasurement.getComponentType() == Controlcenter.ComponentType.BROKER) {
                                        brokerClusterBuilder.setBrokerId(triggerMeasurement.getComponent());
                                    }
                                    info.setComponent(Alert.ComponentDesc.newBuilder().setBrokerCluster(brokerClusterBuilder).build());
                                } else {
                                    info.setComponent(Alert.ComponentDesc.newBuilder().setComponentId(triggerMeasurement.getComponent()).build());
                                }
                                if (triggerMeasurement.getMeasurementCase() == Controlcenter.TriggerMeasurement.MeasurementCase.CLIENTMEASUREMENT) {
                                    info.setHasError(triggerMeasurement.getClientMeasurement().getHasError());
                                }
                                if (triggerConfig.getValueCase() != CommandAlert.MonitoringTriggerConfig.ValueCase.LONGVALUE) break block17;
                                if (triggerConfig.getTriggerMetricCase() != CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.METRIC) break block18;
                                switch (triggerConfig.getMetric()) {
                                    case CONSUMPTION_DIFF: {
                                        info.setLongValue(triggerMeasurement.getClientMeasurement().getConsumptionDiff());
                                        break block19;
                                    }
                                    case AVG_LATENCY: {
                                        info.setLongValue(triggerMeasurement.getClientMeasurement().getAvgLatency());
                                        break block19;
                                    }
                                    case MAX_LATENCY: {
                                        info.setLongValue(triggerMeasurement.getClientMeasurement().getMaxLatency());
                                        break block19;
                                    }
                                    case CONSUMER_LAG: {
                                        info.setLongValue(triggerMeasurement.getClientMeasurement().getConsumerLag());
                                        break block19;
                                    }
                                    case CONSUMER_LEAD: {
                                        info.setLongValue(triggerMeasurement.getClientMeasurement().getConsumerLead());
                                        break block19;
                                    }
                                    default: {
                                        log.warn("Unexpected trigger metric, not sending trigger event: {}", (Object)triggerConfig);
                                        break;
                                    }
                                }
                                continue;
                            }
                            info.setLongValue(triggerMeasurement.getMetricMeasurement().getLongValue());
                            break block19;
                        }
                        if (triggerConfig.getValueCase() == CommandAlert.MonitoringTriggerConfig.ValueCase.STATUSVALUE) {
                            info.setStatusValue(triggerMeasurement.getMetricMeasurement().getStatusValue());
                        } else {
                            log.warn("Unexpected value type, not sending trigger event: {}", (Object)triggerConfig);
                        }
                    }
                    Controlcenter.TriggerEvent triggerEvent = Controlcenter.TriggerEvent.newBuilder().setTriggerGuid(triggerConfig.getGuid()).setTimestamp(now).setInfo(info).setWindow(triggerMeasurement.getWindow()).build();
                    log.trace("Fire trigger={}", (Object)triggerEvent);
                    triggerList.add((KeyValue<Bytes, Controlcenter.TriggerEvent>)KeyValue.pair((Object)triggerKey, (Object)triggerEvent));
                    continue;
                }
                if (deadline <= now) continue;
                log.info("waitforatleastonetriggger=true");
                waitForAtLeastOneTrigger = true;
            }
        }
        catch (Exception e) {
            log.error("Failure while checking if event is triggerable.", (Throwable)e);
        }
        return !waitForAtLeastOneTrigger;
    }

    public static boolean componentAndMetricMatch(Controlcenter.TriggerMeasurement triggerMeasurement, CommandAlert.MonitoringTriggerConfig triggerConfig) {
        switch (triggerConfig.getComponentCase()) {
            case GROUP: {
                return triggerMeasurement.getComponentType() == Controlcenter.ComponentType.CONSUMER_GROUP && triggerConfig.getClusterId().equals(triggerMeasurement.getClusterId()) && triggerConfig.getGroup().equals(triggerMeasurement.getComponent());
            }
            case BROKERCLUSTERS: {
                ProtocolStringList brokerClusters = triggerConfig.getBrokerClusters().getBrokerClustersList();
                CommandAlert.BrokerTriggerMetricType measurementMetric = triggerMeasurement.getMetricMeasurement().getBrokerMetric();
                return TriggerEventUtil.isBrokerOrBrokerCluster(triggerMeasurement) && brokerClusters.contains(triggerMeasurement.getClusterId()) && measurementMetric == triggerConfig.getBrokerMetric();
            }
            case TOPIC: {
                CommandAlert.TopicTriggerMetricType topicMetric = triggerMeasurement.getMetricMeasurement().getTopicMetric();
                if (triggerMeasurement.getComponentType() != Controlcenter.ComponentType.TOPIC || topicMetric != triggerConfig.getTopicMetric()) break;
                return TriggerConfigUtil.topicMatch(triggerMeasurement.getComponent(), triggerConfig);
            }
            default: {
                log.info("Unsupported component type in trigger config {}", (Object)triggerConfig);
            }
        }
        return false;
    }

    public static boolean isBrokerOrBrokerCluster(Controlcenter.TriggerMeasurement triggerMeasurement) {
        return triggerMeasurement.getComponentType() == Controlcenter.ComponentType.BROKER || triggerMeasurement.getComponentType() == Controlcenter.ComponentType.BROKER_CLUSTER;
    }

    public static boolean isMeasurementTriggerable(Controlcenter.TriggerMeasurement triggerMeasurement, CommandAlert.MonitoringTriggerConfig triggerConfig) {
        if (triggerConfig != null && TriggerEventUtil.componentAndMetricMatch(triggerMeasurement, triggerConfig)) {
            if (triggerConfig.getValueCase() == CommandAlert.MonitoringTriggerConfig.ValueCase.LONGVALUE) {
                Long measurementValue;
                if (triggerConfig.getTriggerMetricCase() == CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.METRIC) {
                    switch (triggerConfig.getMetric()) {
                        case CONSUMPTION_DIFF: {
                            measurementValue = triggerMeasurement.getClientMeasurement().getConsumptionDiff();
                            break;
                        }
                        case AVG_LATENCY: {
                            measurementValue = triggerMeasurement.getClientMeasurement().getAvgLatency();
                            break;
                        }
                        case MAX_LATENCY: {
                            measurementValue = triggerMeasurement.getClientMeasurement().getMaxLatency();
                            break;
                        }
                        case CONSUMER_LAG: {
                            measurementValue = triggerMeasurement.getClientMeasurement().getConsumerLag();
                            break;
                        }
                        case CONSUMER_LEAD: {
                            measurementValue = triggerMeasurement.getClientMeasurement().getConsumerLead();
                            break;
                        }
                        default: {
                            log.info("Unsupported client monitoring metric in config {}", (Object)triggerConfig);
                            return false;
                        }
                    }
                    log.info("metric={} value={}", (Object)triggerConfig.getMetric(), (Object)measurementValue);
                } else {
                    measurementValue = triggerMeasurement.getMetricMeasurement().getLongValue();
                }
                log.info("condition={} value={}", (Object)triggerConfig.getCondition(), (Object)triggerConfig.getLongValue());
                switch (triggerConfig.getCondition()) {
                    case GREATER_THAN: {
                        return measurementValue > triggerConfig.getLongValue();
                    }
                    case LESS_THAN: {
                        return measurementValue < triggerConfig.getLongValue();
                    }
                    case EQUAL: {
                        return measurementValue.longValue() == triggerConfig.getLongValue();
                    }
                    case NOT_EQUAL: {
                        return measurementValue.longValue() != triggerConfig.getLongValue();
                    }
                }
                log.warn("unexpected condition={} for valueCase={}", (Object)triggerConfig.getCondition(), (Object)triggerConfig.getValueCase());
            } else if (triggerConfig.getValueCase() == CommandAlert.MonitoringTriggerConfig.ValueCase.STATUSVALUE) {
                switch (triggerConfig.getCondition()) {
                    case EQUAL: {
                        return triggerMeasurement.getMetricMeasurement().getStatusValue() == triggerConfig.getStatusValue();
                    }
                    case NOT_EQUAL: {
                        return triggerMeasurement.getMetricMeasurement().getStatusValue() != triggerConfig.getStatusValue();
                    }
                }
                log.warn("unexpected condition={} for valueCase={}", (Object)triggerConfig.getCondition(), (Object)triggerConfig.getValueCase());
            }
        }
        return false;
    }

    public static boolean isTriggerable(Controlcenter.TriggerMeasurement triggerMeasurement, Iterator<KeyValue<Command.CommandKey, Command.CommandMessage>> triggerConfigIter) {
        while (triggerConfigIter.hasNext()) {
            CommandAlert.MonitoringTriggerConfig triggerConfig = ((Command.CommandMessage)triggerConfigIter.next().value).getMonitoringTriggerConfig();
            if (!TriggerEventUtil.isMeasurementTriggerable(triggerMeasurement, triggerConfig)) continue;
            return true;
        }
        return false;
    }

    public static String logMeasurement(Controlcenter.TriggerMeasurement triggerMeasurement) {
        if (triggerMeasurement.getMeasurementCase() == Controlcenter.TriggerMeasurement.MeasurementCase.METRICMEASUREMENT) {
            return Joiner.on((char)' ').join((Object)"arrivalTime=", (Object)triggerMeasurement.getArrivalTime(), new Object[]{"measurement=", triggerMeasurement.getMetricMeasurement()});
        }
        return Joiner.on((char)' ').join((Object)"arrivalTime=", (Object)triggerMeasurement.getArrivalTime(), new Object[]{"consumptionDiff=", triggerMeasurement.getClientMeasurement().getConsumptionDiff(), "avgLatency=", triggerMeasurement.getClientMeasurement().getAvgLatency(), "maxLatency=", triggerMeasurement.getClientMeasurement().getMaxLatency()});
    }
}

