/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.alert.AlertSender;
import io.confluent.controlcenter.alert.PagerdutyWebhookSender;
import io.confluent.controlcenter.alert.SlackWebhookSender;
import io.confluent.controlcenter.alert.record.Alert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhooksSender
extends AlertSender {
    private static final Logger log = LoggerFactory.getLogger(WebhooksSender.class);
    private SenderMakerFactory senderMaker;

    public WebhooksSender(ControlCenterConfig config, String restEndpoint, SenderMakerFactory senderMaker) {
        super(config, restEndpoint);
        this.senderMaker = senderMaker;
    }

    @Override
    void send(Alert.AlertInfo info, Alert.ActionInfo ai, boolean linkToHistory) {
        CommandAlert.WebHookAction webHookAction = ai.getWebhook();
        if (this.config.getBoolean("confluent.controlcenter.webhook.enabled").booleanValue()) {
            if (webHookAction.hasSlack()) {
                this.senderMaker.makeSlackWebhookSender(info, webHookAction, linkToHistory, this).sendWebHook();
            } else if (webHookAction.hasPagerduty()) {
                this.senderMaker.makePagerDutyWebhookSender(info, webHookAction, linkToHistory, this).sendWebHook();
            }
        } else {
            log.debug("sending=prevented webhook to={} with subject={} from trigger={} messageId={}", new Object[]{webHookAction.getUrl(), webHookAction.getSubject(), info.getMonitoringTrigger().getGuid()});
        }
    }

    public static class SenderMakerFactory {
        public SlackWebhookSender makeSlackWebhookSender(Alert.AlertInfo info, CommandAlert.WebHookAction webHookAction, boolean linkToHistory, AlertSender alertSender) {
            return new SlackWebhookSender(info, webHookAction, linkToHistory, alertSender);
        }

        public PagerdutyWebhookSender makePagerDutyWebhookSender(Alert.AlertInfo info, CommandAlert.WebHookAction webHookAction, boolean linkToHistory, AlertSender alertSender) {
            return new PagerdutyWebhookSender(info, webHookAction, linkToHistory, alertSender);
        }
    }
}

