/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableMap;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import io.confluent.controlcenter.rest.res.AuthorizedOperations;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public abstract class AbstractPermissionsService
implements PermissionsService {
    private ClusterMetadataDao clusterMetadata;

    public AbstractPermissionsService(ClusterMetadataDao clusterMetadata) {
        this.clusterMetadata = clusterMetadata;
    }

    @Override
    public abstract boolean hasViewAccess(JwtPrincipal var1, String var2);

    @Override
    public AllPermissionsResponse getAllOperations(JwtPrincipal principal) throws InterruptedException, ExecutionException, TimeoutException {
        HashMap<String, AuthorizedOperations> scoped = new HashMap<String, AuthorizedOperations>();
        List<KafkaCluster> clusters = this.clusterMetadata.getKafkaClusters();
        for (KafkaCluster cluster : clusters) {
            if (!this.hasViewAccess(principal, cluster.clusterId)) continue;
            scoped.put(cluster.clusterId, new AuthorizedOperations(this.getAllScopedOperations(principal, cluster.clusterId)));
        }
        return new AllPermissionsResponse((Map<String, AuthorizedOperations>)ImmutableMap.copyOf(scoped), new AuthorizedOperations(this.getAllGlobalOperations(principal)));
    }

    @Override
    public abstract Set<PermissionsService.ControlCenterOperation> getAllScopedOperations(JwtPrincipal var1, String var2) throws InterruptedException, ExecutionException, TimeoutException;

    @Override
    public abstract Set<PermissionsService.ControlCenterOperation> getAllGlobalOperations(JwtPrincipal var1);

    @Override
    public abstract Set<PermissionsService.ControlCenterOperation> getScopedControlCenterOperations(JwtPrincipal var1, String var2);

    @Override
    public abstract Set<PermissionsService.ControlCenterOperation> getScopedKafkaOperations(JwtPrincipal var1, String var2) throws InterruptedException, ExecutionException, TimeoutException;

    @Override
    public boolean hasAlertsAccess(JwtPrincipal principal, String clusterId) {
        return this.getScopedControlCenterOperations(principal, clusterId).contains((Object)PermissionsService.ControlCenterOperation.VIEW_ALERTS);
    }

    @Override
    public Map<String, Boolean> getAllAlertsAccess(JwtPrincipal principal) {
        HashMap<String, Boolean> alertsMap = new HashMap<String, Boolean>();
        List<KafkaCluster> clusters = this.clusterMetadata.getKafkaClusters();
        for (KafkaCluster cluster : clusters) {
            alertsMap.put(cluster.clusterId, this.getScopedControlCenterOperations(principal, cluster.clusterId).contains((Object)PermissionsService.ControlCenterOperation.VIEW_ALERTS));
        }
        return alertsMap;
    }

    @Override
    public boolean hasAnyAlertsAccess(JwtPrincipal principal) {
        return this.getAllAlertsAccess(principal).values().contains(true);
    }

    @Override
    public boolean hasLicenceManagementAccess(JwtPrincipal principal) {
        return this.getAllGlobalOperations(principal).contains((Object)PermissionsService.ControlCenterOperation.VIEW_LICENSE_MANAGEMENT);
    }

    @Override
    public boolean hasBrokerMetricsAccess(JwtPrincipal principal, String clusterId) {
        return this.getScopedControlCenterOperations(principal, clusterId).contains((Object)PermissionsService.ControlCenterOperation.VIEW_BROKER_METRICS);
    }
}

