/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerOffsetsDao
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerOffsetsDao.class);
    private static final long DEFAULT_METADATA_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private final String clusterId;
    private final AdminClient kafkaAdminClient;
    private final Consumer<byte[], byte[]> consumer;

    public ConsumerOffsetsDao(String clusterId, AdminClient kafkaAdminClient, Consumer<byte[], byte[]> consumer) {
        this.clusterId = clusterId;
        this.kafkaAdminClient = kafkaAdminClient;
        this.consumer = consumer;
    }

    public Map<String, ConsumerGroupOffsets> getAllConsumerGroupOffsets() throws InterruptedException, ExecutionException, TimeoutException {
        Set<String> consumerGroupIds = this.getConsumerGroups();
        Map<String, ConsumerGroupDescription> fetchedConsumerGroupDesc = this.getAllConsumerGroupDescriptions(consumerGroupIds);
        HashMap<String, ConsumerGroupOffsets> cgOffsetsMap = new HashMap<String, ConsumerGroupOffsets>();
        for (Map.Entry<String, ConsumerGroupDescription> entry : fetchedConsumerGroupDesc.entrySet()) {
            Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets = this.getCurrentOffsets(entry.getKey());
            Map fetchedBeginningOffsets = this.consumer.beginningOffsets(fetchedCurrentOffsets.keySet());
            Map fetchedEndOffsets = this.consumer.endOffsets(fetchedCurrentOffsets.keySet());
            ConsumerGroupOffsets cgOffsets = this.getConsumerGroupOffsets(entry.getValue(), fetchedCurrentOffsets, fetchedBeginningOffsets, fetchedEndOffsets);
            cgOffsetsMap.put(entry.getKey(), cgOffsets);
        }
        return cgOffsetsMap;
    }

    public ConsumerGroupOffsets getConsumerGroupOffsets(ConsumerGroupDescription cgDesc, Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets, Map<TopicPartition, Long> fetchedBeginningOffsets, Map<TopicPartition, Long> fetchedEndOffsets) {
        ConsumerGroupOffsets cgOffsets = new ConsumerGroupOffsets(cgDesc.groupId());
        HashMap<TopicPartition, String> tpConsumerIds = new HashMap<TopicPartition, String>();
        for (MemberDescription memberDesc : cgDesc.members()) {
            for (TopicPartition tp : memberDesc.assignment().topicPartitions()) {
                tpConsumerIds.put(tp, memberDesc.consumerId());
            }
        }
        for (TopicPartition tp : fetchedCurrentOffsets.keySet()) {
            String consumerId = tpConsumerIds.getOrDefault(tp, "");
            long currentOffset = this.getCurrentOffset(fetchedCurrentOffsets, tp);
            long endOffset = this.getOffset(fetchedEndOffsets, tp);
            long beginningOffset = this.getOffset(fetchedBeginningOffsets, tp);
            if (currentOffset < 0L || endOffset < 0L) {
                log.debug("invalid offsets for topic={} consumerId={} current={} end={}", new Object[]{tp.topic(), consumerId, currentOffset, endOffset});
                continue;
            }
            cgOffsets.addOffset(tp.topic(), consumerId, tp.partition(), currentOffset, beginningOffset, endOffset);
        }
        return cgOffsets;
    }

    public ConsumerGroupOffsets getConsumerGroupOffsets(String consumerGroupId) throws InterruptedException, ExecutionException, TimeoutException {
        ConsumerGroupDescription cgDesc = this.getConsumerGroupDescription(consumerGroupId);
        Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets = this.getCurrentOffsets(consumerGroupId);
        Map fetchedEndOffsets = this.consumer.endOffsets(fetchedCurrentOffsets.keySet());
        Map fetchedBeginningOffsets = this.consumer.beginningOffsets(fetchedCurrentOffsets.keySet());
        return this.getConsumerGroupOffsets(cgDesc, fetchedCurrentOffsets, fetchedBeginningOffsets, fetchedEndOffsets);
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Set<String> getConsumerGroups() throws InterruptedException, ExecutionException, TimeoutException {
        return Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)((Iterable)this.kafkaAdminClient.listConsumerGroups().all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS)), ConsumerGroupListing::groupId));
    }

    public ConsumerGroupDescription getConsumerGroupDescription(String consumerGroupId) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupDescription> allCgDesc = this.getAllConsumerGroupDescriptions((Collection<String>)ImmutableSet.of((Object)consumerGroupId));
        return allCgDesc.get(consumerGroupId);
    }

    public Map<String, ConsumerGroupDescription> getAllConsumerGroupDescriptions(Collection<String> consumerGroupIds) throws InterruptedException, ExecutionException, TimeoutException {
        HashMap<String, ConsumerGroupDescription> ret = new HashMap<String, ConsumerGroupDescription>();
        KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])Iterables.toArray((Iterable)Iterables.transform(this.kafkaAdminClient.describeConsumerGroups(consumerGroupIds, new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true)).describedGroups().entrySet(), entry -> {
            String cgId = (String)entry.getKey();
            return ((KafkaFuture)entry.getValue()).whenComplete((cgDesc, throwable) -> {
                if (throwable != null) {
                    log.warn("failed fetching description for consumerGroup={}", (Object)cgId, throwable);
                } else if (cgDesc != null) {
                    ret.put(cgId, (ConsumerGroupDescription)cgDesc);
                }
            });
        }), KafkaFuture.class))).get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
        return ret;
    }

    public Map<TopicPartition, OffsetAndMetadata> getCurrentOffsets(String consumerGroupId) throws InterruptedException, ExecutionException, TimeoutException {
        return (Map)this.kafkaAdminClient.listConsumerGroupOffsets(consumerGroupId).partitionsToOffsetAndMetadata().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    private long getCurrentOffset(Map<TopicPartition, OffsetAndMetadata> map, TopicPartition tp) {
        if (map == null || map.isEmpty() || !map.containsKey(tp)) {
            return -1L;
        }
        return map.get(tp).offset();
    }

    private long getOffset(Map<TopicPartition, Long> map, TopicPartition tp) {
        if (map == null || map.isEmpty() || !map.containsKey(tp)) {
            return -1L;
        }
        return map.get(tp);
    }

    @Override
    public void close() {
        this.kafkaAdminClient.close();
        this.consumer.close();
    }
}

