/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerOffsetsFetcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerOffsetsFetcher.class);
    private final ClusterMetadataDao clusterMetadataDao;
    private final AdminClientSupplier<String> adminClientSupplier;
    private final ConsumerSupplier<byte[], byte[], String> consumerSupplier;
    private final Map<String, Map<String, ConsumerGroupOffsets>> offsets;

    @Inject
    public ConsumerOffsetsFetcher(ClusterMetadataDao clusterMetadataDao, AdminClientSupplier<String> adminClientSupplier, ConsumerSupplier<byte[], byte[], String> consumerSupplier, @ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> offsets) {
        this.clusterMetadataDao = clusterMetadataDao;
        this.adminClientSupplier = adminClientSupplier;
        this.consumerSupplier = consumerSupplier;
        this.offsets = offsets;
    }

    @Override
    public void run() {
        try {
            for (KafkaClusterDisplay kafkaCluster : this.clusterMetadataDao.getKafkaClustersForManagement().clusters) {
                String clusterId = kafkaCluster.clusterId;
                try {
                    AdminClient adminClient = this.adminClientSupplier.getClient(clusterId);
                    Throwable throwable = null;
                    try {
                        Consumer<byte[], byte[]> consumer = this.consumerSupplier.getConsumer(clusterId);
                        Throwable throwable2 = null;
                        try {
                            ConsumerOffsetsDao cgDao = new ConsumerOffsetsDao(clusterId, adminClient, consumer);
                            Map<String, ConsumerGroupOffsets> cgOffsets = cgDao.getAllConsumerGroupOffsets();
                            this.offsets.put(clusterId, cgOffsets);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (consumer == null) continue;
                            if (throwable2 != null) {
                                try {
                                    consumer.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            consumer.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (adminClient == null) continue;
                        if (throwable != null) {
                            try {
                                adminClient.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        adminClient.close();
                    }
                }
                catch (Throwable t) {
                    log.warn(String.format("Unable to fetch consumer offsets for cluster id %s ", clusterId), t);
                }
            }
        }
        catch (Throwable t) {
            log.warn("unable to fetch consumer offsets", t);
        }
    }
}

