/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.base.Function;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.KafkaDao;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.rest.Credential;
import io.confluent.controlcenter.streams.StreamsModule;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.NotFoundException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetadataDao {
    private static final Logger log = LoggerFactory.getLogger(KafkaMetadataDao.class);
    private static final long DEFAULT_METADATA_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private final LoadingCache<Credential, SortedSet<Integer>> brokerCache;
    private final LoadingCache<Credential, SortedSet<String>> topicCache;
    private final AdminClientSupplier<Credential> adminClientSupplier;

    @Inject
    public KafkaMetadataDao(@StreamsModule.BrokerCache LoadingCache<Credential, SortedSet<Integer>> brokerCache, @StreamsModule.TopicCache LoadingCache<Credential, SortedSet<String>> topicCache, AdminClientSupplier<Credential> adminClientSupplier) {
        this.brokerCache = brokerCache;
        this.topicCache = topicCache;
        this.adminClientSupplier = adminClientSupplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TopicDescription> getTopics(Credential credential, boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        try (AdminClient kafkaAdminClient = this.adminClientSupplier.getClient(credential);){
            KafkaDao dao = new KafkaDao(credential.cluster, kafkaAdminClient);
            List<TopicDescription> list = dao.getTopics(excludeDefaultTopics);
            return list;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public List<String> getTopicNamesFromMetadataOrCache(Credential credential) throws InterruptedException, ExecutionException, TimeoutException {
        List<String> topicsFromCache = this.getTopicsFromCache(credential);
        try {
            List<TopicDescription> topicMetadata = this.getTopics(credential, true);
            if (topicMetadata != null) {
                return Ordering.natural().sortedCopy(Iterables.transform(topicMetadata, (Function)new Function<TopicDescription, String>(){

                    public String apply(TopicDescription input) {
                        return input.name();
                    }
                }));
            }
            if (topicsFromCache != null) {
                return topicsFromCache;
            }
        }
        catch (Exception e) {
            if (topicsFromCache != null) {
                return topicsFromCache;
            }
            throw e;
        }
        throw new NotFoundException("No such cluster: " + credential.cluster);
    }

    public List<String> getTopicsFromCache(Credential credential) {
        if (!this.topicCache.asMap().containsKey(credential)) {
            return null;
        }
        return Lists.newLinkedList((Iterable)((Iterable)this.topicCache.getUnchecked((Object)credential)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Node> getNodes(Credential credential) throws InterruptedException, ExecutionException, TimeoutException {
        try (AdminClient kafkaAdminClient = this.adminClientSupplier.getClient(credential);){
            Collection collection = (Collection)kafkaAdminClient.describeCluster().nodes().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
            return collection;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<AclOperation> getAuthorizedOperations(Credential credential) throws InterruptedException, ExecutionException, TimeoutException {
        try (AdminClient kafkaAdminClient = this.adminClientSupplier.getClient(credential);){
            Set set = (Set)kafkaAdminClient.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true)).authorizedOperations().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
            return set;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getConsumerGroups(Credential credential) throws InterruptedException, ExecutionException, TimeoutException {
        try (AdminClient adminClient = this.adminClientSupplier.getClient(credential);){
            HashSet<String> consumerGroups = new HashSet<String>();
            Collection groupListings = (Collection)adminClient.listConsumerGroups().all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.SECONDS);
            for (ConsumerGroupListing group : groupListings) {
                consumerGroups.add(group.groupId());
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf(consumerGroups);
            return immutableSet;
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No such cluster: " + credential.cluster);
        }
    }

    public List<Integer> getBrokerIdsFromCacheOrMetadata(Credential credential) throws InterruptedException, ExecutionException, TimeoutException {
        List<Integer> brokerIdsFromCache = this.getBrokerIdsFromCache(credential);
        if (brokerIdsFromCache == null) {
            Collection<Node> nodes = this.getNodes(credential);
            if (nodes != null) {
                List brokerIds = Ordering.natural().sortedCopy(Iterables.transform(nodes, (Function)new Function<Node, Integer>(){

                    public Integer apply(Node input) {
                        return input.id();
                    }
                }));
                ((SortedSet)this.brokerCache.getUnchecked((Object)credential)).addAll(brokerIds);
                return brokerIds;
            }
        } else {
            return brokerIdsFromCache;
        }
        throw new NotFoundException("No such cluster: " + credential.cluster);
    }

    public List<Integer> getBrokerIdsFromCache(Credential credential) {
        if (!this.brokerCache.asMap().containsKey(credential)) {
            return null;
        }
        return Lists.newLinkedList((Iterable)((Iterable)this.brokerCache.getUnchecked((Object)credential)));
    }
}

