/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.rbacapi.entities.AuthorizeRequest;
import io.confluent.rbacapi.entities.VisibilityRequest;
import io.confluent.rbacapi.entities.VisibilityResponse;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServiceClient {
    private static final Logger log = LoggerFactory.getLogger(MetadataServiceClient.class);
    private static final long MDS_CONNECT_TIMEOUT_SEC = 15L;
    private static final long MDS_READ_TIMEOUT_SEC = 15L;
    private static int MDS_RETRIES_EACH = 2;
    private static final String ALLOWED = "ALLOWED";
    private final Random random = new Random();
    private final ControlCenterRbacConfig rbacConfig;
    private final ClientBuilder clientBuilder;
    private Client client;

    public MetadataServiceClient(ControlCenterRbacConfig rbacConfig, ObjectMapper objectMapper) {
        this.rbacConfig = rbacConfig;
        JacksonJaxbJsonProvider jaxProvider = new JacksonJaxbJsonProvider();
        jaxProvider.setMapper(objectMapper);
        this.clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)new ClientConfig(new Object[]{jaxProvider})).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS);
    }

    public void setSslContextFactory(@NotNull SslContextFactory sslContextFactory) {
        if (this.client != null) {
            throw new IllegalStateException("trying to set SslContextFactory but Client is already built!");
        }
        Preconditions.checkNotNull((Object)sslContextFactory);
        if (sslContextFactory.getSslContext() != null) {
            this.clientBuilder.sslContext(sslContextFactory.getSslContext());
        }
    }

    public boolean isKafkaClusterVisible(String subject, String token, String kafkaClusterId) {
        return this.visibility((String)subject, (String)token, (List<VisibilityRequest>)ImmutableList.of((Object)new VisibilityRequest((String)kafkaClusterId, null, null, null))).get((int)0).kafkaCluster.visible;
    }

    public String getMetadataServiceKafkaId(String token) {
        return this.makeRequestWithRetries(url -> (String)this.getBaseTarget((String)url).path("metadataClusterId").request().header("Authorization", (Object)("Bearer " + token)).get().readEntity(String.class));
    }

    public Map<PermissionsService.ControlCenterOperation, Boolean> authorize(String subject, String token, Scope scope, ImmutableMap<PermissionsService.ControlCenterOperation, PermissionsService.ResourceTypeOperation> scopedOperations) {
        ArrayList<Action> permissions = new ArrayList<Action>();
        for (PermissionsService.ResourceTypeOperation resourceTypeOperation : scopedOperations.values()) {
            permissions.add(new Action(scope, resourceTypeOperation.resourceType, resourceTypeOperation.resourceType.name(), resourceTypeOperation.operation));
        }
        List response = this.makeRequestWithRetries(url -> (List)this.getBaseTarget((String)url).path("authorize").request().header("Authorization", (Object)("Bearer " + token)).put(Entity.entity((Object)new AuthorizeRequest("User:" + subject, permissions), (MediaType)MediaType.APPLICATION_JSON_TYPE)).readEntity((GenericType)new GenericType<List<String>>(){}));
        if (response.size() != scopedOperations.size()) {
            log.error("expected list size {}, actual, {}", (Object)scopedOperations.size(), (Object)response.size());
            throw new InternalServerErrorException();
        }
        HashMap<PermissionsService.ControlCenterOperation, Boolean> allowed = new HashMap<PermissionsService.ControlCenterOperation, Boolean>();
        int i = 0;
        for (PermissionsService.ControlCenterOperation o : scopedOperations.keySet()) {
            allowed.put(o, ((String)response.get(i++)).equals(ALLOWED));
        }
        return allowed;
    }

    public List<VisibilityResponse> visibility(String subject, String token, List<VisibilityRequest> visibilityRequests) {
        return this.makeRequestWithRetries(url -> (List)this.getBaseTarget((String)url).path("principals").path("User:" + MetadataServiceClient.urlEncode(subject)).path("visibility").request().header("Authorization", (Object)("Bearer " + token)).post(Entity.entity((Object)visibilityRequests, (MediaType)MediaType.APPLICATION_JSON_TYPE)).readEntity((GenericType)new GenericType<List<VisibilityResponse>>(){}));
    }

    private <T> T makeRequestWithRetries(Function<String, T> makeRequest) {
        int startIndex = this.random.nextInt(this.rbacConfig.getMetadataServiceUrls().size());
        for (int i = 0; i < MDS_RETRIES_EACH * this.rbacConfig.getMetadataServiceUrls().size(); ++i) {
            int index = (startIndex + i) % this.rbacConfig.getMetadataServiceUrls().size();
            String url = this.rbacConfig.getMetadataServiceUrls().get(index);
            try {
                return makeRequest.apply(url);
            }
            catch (Exception e) {
                log.warn("failed to make metadata service request to {} : {}", (Object)url, (Object)e.getMessage());
                continue;
            }
        }
        throw new InternalServerErrorException("failed to connect to any MDS server");
    }

    private WebTarget getBaseTarget(String target) {
        if (this.client == null) {
            this.client = this.clientBuilder.build();
        }
        return this.client.target(target).path("security").path("1.0");
    }

    private static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalServerErrorException();
        }
    }
}

