/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableSet;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.AbstractPermissionsService;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.PermissionsService;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class NoopPermissionsService
extends AbstractPermissionsService {
    private static final Set<PermissionsService.ControlCenterOperation> ALL_KAFKA_OPERATIONS = ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_CLUSTER_SETTINGS));
    private static final Set<PermissionsService.ControlCenterOperation> ALL_CONTROL_CENTER_SCOPED_OPERATIONS = ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_BROKER_METRICS), (Object)((Object)PermissionsService.ControlCenterOperation.VIEW_ALERTS));
    private static final Set<PermissionsService.ControlCenterOperation> ALL_SCOPED_OPERATIONS = new ImmutableSet.Builder().addAll(ALL_CONTROL_CENTER_SCOPED_OPERATIONS).addAll(ALL_KAFKA_OPERATIONS).build();
    private static final Set<PermissionsService.ControlCenterOperation> ALL_GLOBAL_OPERATIONS = ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_LICENSE_MANAGEMENT));

    public NoopPermissionsService(ClusterMetadataDao clusterMetadata) {
        super(clusterMetadata);
    }

    @Override
    public boolean hasViewAccess(JwtPrincipal principal, String clusterId) {
        return true;
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getAllScopedOperations(JwtPrincipal principal, String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return ALL_SCOPED_OPERATIONS;
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getAllGlobalOperations(JwtPrincipal principal) {
        return ALL_GLOBAL_OPERATIONS;
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getScopedControlCenterOperations(JwtPrincipal principal, String clusterId) {
        return ALL_CONTROL_CENTER_SCOPED_OPERATIONS;
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getScopedKafkaOperations(JwtPrincipal principal, String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return ALL_KAFKA_OPERATIONS;
    }
}

