/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public interface PermissionsService {
    public boolean hasViewAccess(JwtPrincipal var1, String var2);

    public AllPermissionsResponse getAllOperations(JwtPrincipal var1) throws InterruptedException, ExecutionException, TimeoutException;

    public Set<ControlCenterOperation> getAllScopedOperations(JwtPrincipal var1, String var2) throws InterruptedException, ExecutionException, TimeoutException;

    public Set<ControlCenterOperation> getAllGlobalOperations(JwtPrincipal var1);

    public Set<ControlCenterOperation> getScopedControlCenterOperations(JwtPrincipal var1, String var2);

    public Set<ControlCenterOperation> getScopedKafkaOperations(JwtPrincipal var1, String var2) throws InterruptedException, ExecutionException, TimeoutException;

    public boolean hasAlertsAccess(JwtPrincipal var1, String var2);

    public Map<String, Boolean> getAllAlertsAccess(JwtPrincipal var1);

    public boolean hasAnyAlertsAccess(JwtPrincipal var1);

    public boolean hasLicenceManagementAccess(JwtPrincipal var1);

    public boolean hasBrokerMetricsAccess(JwtPrincipal var1, String var2);

    public static class ResourceTypeOperation {
        public final ResourceType resourceType;
        public final Operation operation;

        public ResourceTypeOperation(ResourceType resourceType, Operation operation) {
            this.resourceType = resourceType;
            this.operation = operation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceTypeOperation that = (ResourceTypeOperation)o;
            return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.operation, that.operation);
        }

        public int hashCode() {
            return Objects.hash(this.resourceType, this.operation);
        }
    }

    public static enum ControlCenterOperation {
        VIEW_BROKER_METRICS,
        VIEW_CLUSTER_SETTINGS,
        VIEW_ALERTS,
        VIEW_LICENSE_MANAGEMENT;

    }
}

