/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.AbstractPermissionsService;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.data.MetadataServiceClient;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.Credential;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.acl.AclOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacPermissionsService
extends AbstractPermissionsService {
    private static final Logger log = LoggerFactory.getLogger(RbacPermissionsService.class);
    private static final PermissionsService.ResourceTypeOperation BROKER_METRICS = new PermissionsService.ResourceTypeOperation(new ResourceType("ControlCenterBrokerMetrics"), new Operation("Read"));
    private static final PermissionsService.ResourceTypeOperation ALERTS = new PermissionsService.ResourceTypeOperation(new ResourceType("ControlCenterAlerts"), new Operation("Write"));
    private static final PermissionsService.ResourceTypeOperation LICENSE_MANAGEMENT = new PermissionsService.ResourceTypeOperation(new ResourceType("License"), new Operation("Alter"));
    private final KafkaMetadataDao kafkaMetadataDao;
    private final MetadataServiceClient mdsClient;

    public RbacPermissionsService(ClusterMetadataDao clusterMetadata, KafkaMetadataDao kafkaMetadataDao, MetadataServiceClient mdsClient) {
        super(clusterMetadata);
        this.kafkaMetadataDao = kafkaMetadataDao;
        this.mdsClient = mdsClient;
    }

    @Override
    public boolean hasViewAccess(JwtPrincipal principal, String clusterId) {
        return this.mdsClient.isKafkaClusterVisible(principal.getName(), principal.getJwt(), clusterId);
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getAllScopedOperations(JwtPrincipal principal, String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        ImmutableSet.Builder operations = new ImmutableSet.Builder().addAll(this.getScopedControlCenterOperations(principal, clusterId));
        Set<PermissionsService.ControlCenterOperation> kafkaOps = this.getScopedKafkaOperations(principal, clusterId);
        if (kafkaOps == null) {
            log.warn("cluster not configured for management: {}", (Object)clusterId);
        } else {
            operations.addAll(kafkaOps);
        }
        return operations.build();
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getAllGlobalOperations(JwtPrincipal principal) {
        return new ImmutableSet.Builder().addAll(this.getLicenseManagement(principal)).build();
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getScopedControlCenterOperations(JwtPrincipal principal, String clusterId) {
        Map<PermissionsService.ControlCenterOperation, Boolean> allowed = this.mdsClient.authorize(principal.getName(), principal.getJwt(), Scope.kafkaClusterScope((String)clusterId), (ImmutableMap<PermissionsService.ControlCenterOperation, PermissionsService.ResourceTypeOperation>)ImmutableMap.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_BROKER_METRICS), (Object)BROKER_METRICS, (Object)((Object)PermissionsService.ControlCenterOperation.VIEW_ALERTS), (Object)ALERTS));
        HashSet<PermissionsService.ControlCenterOperation> operations = new HashSet<PermissionsService.ControlCenterOperation>();
        for (Map.Entry<PermissionsService.ControlCenterOperation, Boolean> e : allowed.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            operations.add(e.getKey());
        }
        return operations;
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getScopedKafkaOperations(JwtPrincipal principal, String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        Set<AclOperation> operations = this.kafkaMetadataDao.getAuthorizedOperations(Credential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)principal));
        if (operations != null) {
            if (operations.contains(AclOperation.ALTER_CONFIGS)) {
                return ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_CLUSTER_SETTINGS));
            }
            return ImmutableSet.of();
        }
        return null;
    }

    private Set<PermissionsService.ControlCenterOperation> getLicenseManagement(JwtPrincipal principal) {
        Map<PermissionsService.ControlCenterOperation, Boolean> allowed = this.mdsClient.authorize(principal.getName(), principal.getJwt(), Scope.kafkaClusterScope((String)this.mdsClient.getMetadataServiceKafkaId(principal.getJwt())), (ImmutableMap<PermissionsService.ControlCenterOperation, PermissionsService.ResourceTypeOperation>)ImmutableMap.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_LICENSE_MANAGEMENT), (Object)LICENSE_MANAGEMENT));
        if (allowed.getOrDefault((Object)PermissionsService.ControlCenterOperation.VIEW_LICENSE_MANAGEMENT, false).booleanValue()) {
            return ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_LICENSE_MANAGEMENT));
        }
        return ImmutableSet.of();
    }
}

