/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.rest.Credential;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;

public class ScopedKafkaMetadataDao {
    private final KafkaMetadataDao kafkaMetadataDao;
    private final JwtPrincipal principal;

    public ScopedKafkaMetadataDao() {
        this(null, null);
    }

    public ScopedKafkaMetadataDao(KafkaMetadataDao kafkaMetadataDao, JwtPrincipal principal) {
        this.kafkaMetadataDao = kafkaMetadataDao;
        this.principal = principal;
    }

    private Credential toCredential(String clusterId) {
        return Credential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)this.principal);
    }

    public List<TopicDescription> getTopics(String clusterId, boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        return this.kafkaMetadataDao.getTopics(this.toCredential(clusterId), excludeDefaultTopics);
    }

    public List<String> getTopicNamesFromMetadataOrCache(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.kafkaMetadataDao.getTopicNamesFromMetadataOrCache(this.toCredential(clusterId));
    }

    public List<String> getTopicsFromCache(String clusterId) {
        return this.kafkaMetadataDao.getTopicsFromCache(this.toCredential(clusterId));
    }

    public Collection<Node> getNodes(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.kafkaMetadataDao.getNodes(this.toCredential(clusterId));
    }

    public Set<AclOperation> getAuthorizedOperations(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.kafkaMetadataDao.getAuthorizedOperations(this.toCredential(clusterId));
    }

    public Set<String> getConsumerGroups(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.kafkaMetadataDao.getConsumerGroups(this.toCredential(clusterId));
    }

    public List<Integer> getBrokerIdsFromCacheOrMetadata(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.kafkaMetadataDao.getBrokerIdsFromCacheOrMetadata(this.toCredential(clusterId));
    }

    public List<Integer> getBrokerIdsFromCache(String clusterId) {
        return this.kafkaMetadataDao.getBrokerIdsFromCache(this.toCredential(clusterId));
    }
}

