/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class ScopedPermissions {
    private PermissionsService permissionsService;
    private JwtPrincipal principal;

    public ScopedPermissions() {
        this(null, null);
    }

    public ScopedPermissions(PermissionsService permissionsService, JwtPrincipal principal) {
        this.permissionsService = permissionsService;
        this.principal = principal;
    }

    public boolean hasViewAccess(String clusterId) {
        return this.permissionsService.hasViewAccess(this.principal, clusterId);
    }

    public AllPermissionsResponse getAllOperations() throws InterruptedException, ExecutionException, TimeoutException {
        return this.permissionsService.getAllOperations(this.principal);
    }

    public Set<PermissionsService.ControlCenterOperation> getAllScopedOperations(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.permissionsService.getAllScopedOperations(this.principal, clusterId);
    }

    public Set<PermissionsService.ControlCenterOperation> getAllGlobalOperations() {
        return this.permissionsService.getAllGlobalOperations(this.principal);
    }

    public Set<PermissionsService.ControlCenterOperation> getScopedControlCenterOperations(String clusterId) {
        return this.permissionsService.getScopedControlCenterOperations(this.principal, clusterId);
    }

    public Set<PermissionsService.ControlCenterOperation> getScopedKafkaOperations(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        return this.permissionsService.getScopedKafkaOperations(this.principal, clusterId);
    }

    public boolean hasAlertsAccess(String clusterId) {
        return this.permissionsService.hasAlertsAccess(this.principal, clusterId);
    }

    public Map<String, Boolean> getAllAlertsAccess() {
        return this.permissionsService.getAllAlertsAccess(this.principal);
    }

    public boolean hasAnyAlertsAccess() {
        return this.permissionsService.hasAnyAlertsAccess(this.principal);
    }

    public boolean hasLicenceManagementAccess() {
        return this.permissionsService.hasLicenceManagementAccess(this.principal);
    }

    public boolean hasBrokerMetricsAccess(String clusterId) {
        return this.permissionsService.hasBrokerMetricsAccess(this.principal, clusterId);
    }
}

