/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.ServiceVisibilityFilter;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import java.util.List;

public class ScopedServiceVisibilityFilter {
    private final ServiceVisibilityFilter serviceVisibilityFilter;
    private final JwtPrincipal principal;

    public ScopedServiceVisibilityFilter() {
        this(null, null);
    }

    public ScopedServiceVisibilityFilter(ServiceVisibilityFilter serviceVisibilityFilter, JwtPrincipal principal) {
        this.serviceVisibilityFilter = serviceVisibilityFilter;
        this.principal = principal;
    }

    public List<KsqlCluster> filterKsqlClusters(List<KsqlCluster> ksqlClusters) {
        return this.serviceVisibilityFilter.filterKsqlClusters(ksqlClusters, this.principal);
    }

    public List<ConnectCluster> filterConnectClusters(List<ConnectCluster> connectClusters) {
        return this.serviceVisibilityFilter.filterConnectClusters(connectClusters, this.principal);
    }

    public List<SchemaRegistryCluster> filterSchemaRegistryClusters(List<SchemaRegistryCluster> srClusters) {
        return this.serviceVisibilityFilter.filterSchemaRegistryClusters(srClusters, this.principal);
    }
}

