/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.MetadataServiceClient;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.rest.res.KsqlServerInfo;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.kafka.schemaregistry.security.permissions.entities.Permissions;
import io.confluent.rbacapi.entities.VisibilityRequest;
import io.confluent.rbacapi.entities.VisibilityResponse;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceVisibilityFilter {
    private static final Logger log = LoggerFactory.getLogger(ServiceVisibilityFilter.class);
    private static final String KAFKA_CLUSTER = "kafka-cluster";
    private static final String SR_CLUSTER = "schema-registry-cluster";
    private static final String CONNECT_CLUSTER = "connect-cluster";
    private static final long SERVICE_CONNECT_TIMEOUT_SEC = 15L;
    private static final long SERVICE_READ_TIMEOUT_SEC = 15L;
    private final ClientBuilder clientBuilder;
    private final MetadataServiceClient metadataServiceClient;
    private Client client;

    public ServiceVisibilityFilter(ObjectMapper objectMapper, @Nullable MetadataServiceClient metadataServiceClient) {
        JacksonJaxbJsonProvider jaxProvider = new JacksonJaxbJsonProvider();
        jaxProvider.setMapper(objectMapper);
        this.clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)new ClientConfig(new Object[]{jaxProvider})).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS);
        this.metadataServiceClient = metadataServiceClient;
    }

    public void setSslContextFactory(@NotNull SslContextFactory sslContextFactory) {
        if (this.client != null) {
            throw new IllegalStateException("trying to set SslContextFactory but Client is already built!");
        }
        Preconditions.checkNotNull((Object)sslContextFactory);
        if (sslContextFactory.getSslContext() != null) {
            this.clientBuilder.sslContext(sslContextFactory.getSslContext());
        }
    }

    public List<KsqlCluster> filterKsqlClusters(List<KsqlCluster> ksqlClusters, JwtPrincipal principal) {
        if (this.metadataServiceClient == null) {
            return ksqlClusters;
        }
        return this.getFilteredClusters(ksqlClusters, principal, cluster -> this.getKsqlVisibilityRequest((KsqlCluster)cluster, principal.getJwt()), response -> response.ksqlClusters);
    }

    public List<ConnectCluster> filterConnectClusters(List<ConnectCluster> connectClusters, JwtPrincipal principal) {
        if (this.metadataServiceClient == null) {
            return connectClusters;
        }
        return this.getFilteredClusters(connectClusters, principal, cluster -> this.getConnectVisibilityRequest((ConnectCluster)cluster, principal.getJwt()), response -> response.connectClusters);
    }

    public List<SchemaRegistryCluster> filterSchemaRegistryClusters(List<SchemaRegistryCluster> srClusters, JwtPrincipal principal) {
        if (this.metadataServiceClient == null) {
            return srClusters;
        }
        return this.getFilteredClusters(srClusters, principal, cluster -> this.getSchemaRegistryVisibilityRequest((SchemaRegistryCluster)cluster, principal.getJwt()), response -> response.schemaRegistryClusters);
    }

    VisibilityRequest getKsqlVisibilityRequest(KsqlCluster ksqlCluster, String token) {
        String endpoint = ServiceVisibilityFilter.getRandomEndpoint(ksqlCluster.getEndpoints());
        try {
            KsqlServerInfo serverInfo = (KsqlServerInfo)this.getClient().target(endpoint).path("info").request().header("Authorization", (Object)("Bearer " + token)).get().readEntity(KsqlServerInfo.class);
            Preconditions.checkNotNull((Object)serverInfo.getKafkaClusterId());
            Preconditions.checkNotNull((Object)serverInfo.getKsqlServiceId());
            return new VisibilityRequest(serverInfo.getKafkaClusterId(), null, null, (List)ImmutableList.of((Object)serverInfo.getKsqlServiceId()));
        }
        catch (Exception e) {
            log.info("exception trying to request id from ksql-cluster({}): {}", (Object)ksqlCluster.getDisplayName(), (Object)e.getMessage());
            return null;
        }
    }

    VisibilityRequest getConnectVisibilityRequest(ConnectCluster connectCluster, String token) {
        String endpoint = ServiceVisibilityFilter.getRandomEndpoint(connectCluster.urls);
        try {
            Scope scope = ((io.confluent.connect.security.permissions.entities.Permissions)this.getClient().target(endpoint).path("permissions").request().header("Authorization", (Object)("Bearer " + token)).get().readEntity(io.confluent.connect.security.permissions.entities.Permissions.class)).getScope();
            String kafkaClusterId = (String)scope.clusters().get(KAFKA_CLUSTER);
            String connectClusterId = (String)scope.clusters().get(CONNECT_CLUSTER);
            Preconditions.checkNotNull((Object)kafkaClusterId);
            Preconditions.checkNotNull((Object)connectClusterId);
            return new VisibilityRequest(kafkaClusterId, (List)ImmutableList.of((Object)connectClusterId), null, null);
        }
        catch (Exception e) {
            log.info("exception trying to request id from connect-cluster({}): {}", (Object)connectCluster.displayName, (Object)e.getMessage());
            return null;
        }
    }

    VisibilityRequest getSchemaRegistryVisibilityRequest(SchemaRegistryCluster schemaRegistryCluster, String token) {
        String endpoint = ServiceVisibilityFilter.getRandomEndpoint(schemaRegistryCluster.servers);
        try {
            Scope scope = ((Permissions)this.getClient().target(endpoint).path("permissions").request().header("Authorization", (Object)("Bearer " + token)).get().readEntity(Permissions.class)).getScope();
            String kafkaClusterId = (String)scope.clusters().get(KAFKA_CLUSTER);
            String srClusterId = (String)scope.clusters().get(SR_CLUSTER);
            Preconditions.checkNotNull((Object)kafkaClusterId);
            Preconditions.checkNotNull((Object)srClusterId);
            return new VisibilityRequest(kafkaClusterId, null, (List)ImmutableList.of((Object)srClusterId), null);
        }
        catch (Exception e) {
            log.info("exception trying to request id from schema-registry-cluster({}): {}", (Object)schemaRegistryCluster.displayName, (Object)e.getMessage());
            return null;
        }
    }

    private Client getClient() {
        if (this.client == null) {
            this.client = this.clientBuilder.build();
        }
        return this.client;
    }

    private static String getRandomEndpoint(List<String> endpoints) {
        Preconditions.checkArgument((endpoints.size() > 0 ? 1 : 0) != 0);
        return endpoints.get(ThreadLocalRandom.current().nextInt(endpoints.size()));
    }

    private <T> List<T> getFilteredClusters(List<T> clusters, JwtPrincipal principal, java.util.function.Function<T, VisibilityRequest> getRequest, java.util.function.Function<VisibilityResponse, List<VisibilityResponse.ClusterVisibility>> getResponse) {
        ArrayList filtered = new ArrayList();
        ArrayList<VisibilityRequestCluster<T>> requestClusters = new ArrayList<VisibilityRequestCluster<T>>();
        for (T cluster : clusters) {
            VisibilityRequest request = getRequest.apply(cluster);
            if (request == null) continue;
            requestClusters.add(new VisibilityRequestCluster<T>(request, cluster));
        }
        if (requestClusters.size() == 0) {
            return ImmutableList.of();
        }
        List<VisibilityResponse> visibilityResponses = this.metadataServiceClient.visibility(principal.getName(), principal.getJwt(), (List<VisibilityRequest>)FluentIterable.from(requestClusters).transform(new Function<VisibilityRequestCluster<T>, VisibilityRequest>(){

            @Nullable
            public VisibilityRequest apply(@Nullable VisibilityRequestCluster<T> input) {
                return input.visibilityRequest;
            }
        }).toList());
        int i = 0;
        for (VisibilityResponse response : visibilityResponses) {
            if (getResponse.apply((VisibilityResponse)response).get((int)0).visible) {
                filtered.add(((VisibilityRequestCluster)requestClusters.get((int)i)).cluster);
            }
            ++i;
        }
        return ImmutableList.copyOf(filtered);
    }

    public static class VisibilityRequestCluster<T> {
        public final VisibilityRequest visibilityRequest;
        public final T cluster;

        public VisibilityRequestCluster(VisibilityRequest visibilityRequest, T cluster) {
            this.visibilityRequest = visibilityRequest;
            this.cluster = cluster;
        }
    }
}

