/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.confluent.controlcenter.ReferenceCountingHolder;
import io.confluent.controlcenter.kafka.ClusterView;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.kafka.DelegatingConsumer;
import io.confluent.controlcenter.rest.Credential;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.Consumer;

public class CachingConsumerSupplier<K, V>
implements ConsumerSupplier<K, V, Credential> {
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private static final long DEFAULT_CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(15L);
    private final Cache<Credential, ReferenceCountingHolder<Consumer<K, V>>> cache;
    private final ConsumerSupplier<K, V, Credential> consumerSupplier;

    public CachingConsumerSupplier(ClusterView clusterView, ConsumerSupplier<K, V, Credential> consumerSupplier) {
        this.consumerSupplier = consumerSupplier;
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(DEFAULT_CACHE_EXPIRATION_MS, TimeUnit.MILLISECONDS).removalListener(new RemovalListener<Credential, ReferenceCountingHolder<Consumer<K, V>>>(){

            public void onRemoval(RemovalNotification<Credential, ReferenceCountingHolder<Consumer<K, V>>> notification) {
                ((ReferenceCountingHolder)notification.getValue()).close();
            }
        }).build();
        clusterView.registerClusterCallback(new ClusterView.ClusterCallback(){

            @Override
            public void clusterUpdated(String clusterId) {
                CachingConsumerSupplier.this.cache.asMap().keySet().forEach(key -> {
                    if (key.matchesCluster(clusterId)) {
                        CachingConsumerSupplier.this.cache.invalidate(key);
                    }
                });
            }

            @Override
            public void clusterAdded(String clusterId) {
            }
        });
    }

    @Override
    public Consumer<K, V> getConsumer(final Credential credential) {
        try {
            final ReferenceCountingHolder holder = (ReferenceCountingHolder)this.cache.get((Object)credential, new Callable<ReferenceCountingHolder<Consumer<K, V>>>(){

                @Override
                public ReferenceCountingHolder<Consumer<K, V>> call() throws Exception {
                    return new ReferenceCountingHolder(CachingConsumerSupplier.this.consumerSupplier.getConsumer(credential));
                }
            });
            holder.increment();
            return new DelegatingConsumer<K, V>((Consumer)holder.get()){
                final AtomicBoolean closed;
                {
                    super(delegate);
                    this.closed = new AtomicBoolean(false);
                }

                @Override
                public void close() {
                    this.release();
                }

                @Override
                public void close(long duration, TimeUnit unit) {
                    this.release();
                }

                private void release() {
                    if (this.closed.compareAndSet(false, true)) {
                        ((Consumer)holder.get()).unsubscribe();
                        holder.decrement();
                    }
                }
            };
        }
        catch (UncheckedExecutionException uee) {
            Throwables.throwIfUnchecked((Throwable)uee.getCause());
            throw new RuntimeException(uee);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee.getCause());
        }
    }
}

