/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.data.MetadataServiceClient;
import io.confluent.controlcenter.data.NoopPermissionsService;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.data.RbacPermissionsService;
import io.confluent.controlcenter.data.ServiceVisibilityFilter;
import io.confluent.controlcenter.kafka.AdminClientFactory;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.kafka.CachingAdminClientSupplier;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.ClusterView;
import io.confluent.controlcenter.kafka.ConsumerManager;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.kafka.DefaultAdminClientFactory;
import io.confluent.controlcenter.rest.Credential;
import io.confluent.rbacapi.jackson.MdsJacksonModule;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

public class ClusterManagementModule
extends AbstractModule {
    protected void configure() {
        this.bind(AdminClientFactory.class).to(DefaultAdminClientFactory.class).in(Singleton.class);
        this.bind(ClusterView.class).to(ClusterManager.class);
        this.bind(ClusterManager.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @Inject
    AdminClientSupplier<Credential> adminClientSupplier(ClusterView clusterView, ClusterManager clusterManager) {
        final CachingAdminClientSupplier<Credential> cachingAdminClientSupplier = new CachingAdminClientSupplier<Credential>(clusterManager);
        clusterView.registerClusterCallback(new ClusterView.ClusterCallback(){

            @Override
            public void clusterUpdated(String clusterId) {
                cachingAdminClientSupplier.invalidateCluster(clusterId);
            }

            @Override
            public void clusterAdded(String clusterId) {
            }
        });
        return cachingAdminClientSupplier;
    }

    @Provides
    @Singleton
    @Inject
    AdminClientSupplier<String> adminClientSupplier(final AdminClientSupplier<Credential> adminClientSupplier) {
        return new AdminClientSupplier<String>(){

            @Override
            public AdminClient getClient(String clusterId) {
                return adminClientSupplier.getClient(Credential.makeCredential(clusterId));
            }
        };
    }

    @Provides
    @Singleton
    @Inject
    ConsumerSupplier<byte[], byte[], Credential> consumerSupplier(ClusterManager clusterManager) {
        ImmutableMap configs = ImmutableMap.builder().put((Object)"group.id", (Object)"").put((Object)"max.poll.records", (Object)10).put((Object)"key.deserializer", ByteArrayDeserializer.class).put((Object)"value.deserializer", ByteArrayDeserializer.class).build();
        return new ConsumerManager<byte[], byte[]>(clusterManager, (Map<String, Object>)configs);
    }

    @Provides
    @Singleton
    ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new MdsJacksonModule());
        return objectMapper;
    }

    @Provides
    @Singleton
    @Inject
    MetadataServiceClient metadataServiceClient(ControlCenterRbacConfig rbacConfig, ObjectMapper objectMapper) {
        if (rbacConfig.isRbacEnabled()) {
            return new MetadataServiceClient(rbacConfig, objectMapper);
        }
        return null;
    }

    @Provides
    @Singleton
    @Inject
    ServiceVisibilityFilter serviceVisibilityFilter(ControlCenterRbacConfig rbacConfig, ObjectMapper objectMapper, @Nullable MetadataServiceClient mdsClient) {
        return new ServiceVisibilityFilter(objectMapper, mdsClient);
    }

    @Provides
    @Singleton
    @Inject
    PermissionsService permissionsService(ControlCenterRbacConfig rbacConfig, ClusterMetadataDao clusterMetadataDao, KafkaMetadataDao kafkaMetadataDao, @Nullable MetadataServiceClient mdsClient) {
        if (rbacConfig.isRbacEnabled()) {
            return new RbacPermissionsService(clusterMetadataDao, kafkaMetadataDao, mdsClient);
        }
        return new NoopPermissionsService(clusterMetadataDao);
    }
}

