/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.ksql;

import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlClusterMetadata {
    private static final Logger log = LoggerFactory.getLogger(KsqlClusterMetadata.class);
    private final ArrayList<KsqlCluster> ksqlClusters = new ArrayList();

    public KsqlClusterMetadata(StaticClusterConfigSupplier ksqlClusterConfigSupplier, ControlCenterConfig config) {
        if (config.getList("confluent.controlcenter.ksql.url").size() > 0) {
            this.deprecatedInitialize(config);
        } else {
            for (Map.Entry<String, Map<String, Object>> entry : ksqlClusterConfigSupplier.getConfigurations().entrySet()) {
                this.addCluster(entry.getKey(), entry.getValue());
            }
        }
    }

    public List<KsqlCluster> getKsqlClusters() {
        return this.ksqlClusters;
    }

    private void deprecatedInitialize(ControlCenterConfig config) {
        log.warn("Configuration '{}' is deprecated. Configure new ksql clusters with '{}<name>.url'. Please see documentation for more details.", (Object)"confluent.controlcenter.ksql.url", (Object)"confluent.controlcenter.ksql.");
        List endpoints = config.getList("confluent.controlcenter.ksql.url");
        List advertisedEndpoints = config.getList("confluent.controlcenter.ksql.advertised.url");
        if (advertisedEndpoints.size() == 0) {
            advertisedEndpoints = endpoints;
        }
        this.addCluster("KSQL", endpoints, advertisedEndpoints);
    }

    private void addCluster(String name, Map<String, Object> cluster) {
        List<String> endpoints = ConfigUtils.getList(cluster, "url");
        List<String> advertisedEndpoints = ConfigUtils.getList(cluster, "advertised.url");
        this.addCluster(name, endpoints, advertisedEndpoints);
    }

    private void addCluster(String name, List<String> endpoints, List<String> advertisedEndpoints) {
        if (endpoints == null) {
            log.warn("Invalid url property for ksql endpoint '{}'", (Object)name);
            return;
        }
        if (advertisedEndpoints == null) {
            advertisedEndpoints = endpoints;
        }
        if (endpoints.size() == 0) {
            log.warn("No endpoints specified for ksql endpoint '{}'", (Object)name);
            return;
        }
        this.ksqlClusters.add(new KsqlCluster(name, name, endpoints, advertisedEndpoints));
    }
}

