/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseInfo {
    private static final Logger log = LoggerFactory.getLogger(LicenseInfo.class);
    private License license;
    private LicenseManager licenseManager;
    private final ControlCenterConfig controlCenterConfig;

    @Inject
    public LicenseInfo(License license, LicenseManager licenseManager, ControlCenterConfig controlCenterConfig) {
        this.license = license;
        this.licenseManager = licenseManager;
        this.controlCenterConfig = controlCenterConfig;
    }

    public long getExpiration() {
        try {
            Date expirationDate = this.license.expirationDate();
            return expirationDate != null ? expirationDate.getTime() : Long.MIN_VALUE;
        }
        catch (Throwable t) {
            log.warn("Unable to get license expiration", t);
            return 0L;
        }
    }

    public String getAudience() {
        if (this.license.audience().isEmpty()) {
            return null;
        }
        return (String)this.license.audience().get(0);
    }

    public String getString() {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable").booleanValue()) {
            return null;
        }
        return this.license.serializedForm();
    }

    public boolean setLicenseString(String licenseString) throws InvalidLicenseException {
        License license;
        this.license = license = this.licenseManager.registerOrValidateLicense(licenseString);
        return license.serializedForm().equals(licenseString);
    }
}

