/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDaoSupplier;
import io.confluent.controlcenter.data.KafkaDao;
import io.confluent.controlcenter.data.KafkaDaoSupplier;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.kafka.CachingConsumerSupplier;
import io.confluent.controlcenter.rest.BrokerMetricsCluster;
import io.confluent.controlcenter.rest.Credential;
import io.confluent.controlcenter.rest.VisibleCluster;
import io.confluent.controlcenter.util.PrincipalUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Principal;
import javax.inject.Provider;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConverter
implements ParamConverterProvider {
    private static final Logger log = LoggerFactory.getLogger(ClusterConverter.class);
    private final AdminClientSupplier<Credential> adminClientSupplier;
    private final CachingConsumerSupplier<byte[], byte[]> cachingConsumerSupplier;
    private final PermissionsService permissionsService;
    @Context
    Provider<SecurityContext> securityContext;

    @Inject
    public ClusterConverter(AdminClientSupplier<Credential> adminClientSupplier, CachingConsumerSupplier<byte[], byte[]> cachingConsumerSupplier, PermissionsService permissionsService) {
        this.adminClientSupplier = adminClientSupplier;
        this.cachingConsumerSupplier = cachingConsumerSupplier;
        this.permissionsService = permissionsService;
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(KafkaDaoSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (KafkaDaoSupplier)() -> {
                        try {
                            if (!ClusterConverter.this.permissionsService.hasViewAccess(PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()), clusterId)) {
                                throw new ForbiddenException("must have view access");
                            }
                            return new KafkaDao(clusterId, ClusterConverter.this.adminClientSupplier.getClient(Credential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()))));
                        }
                        catch (IllegalArgumentException iae) {
                            throw new NotFoundException("unable to locate cluster " + clusterId);
                        }
                    };
                }

                public String toString(T kafkaDaoSupplier) {
                    return ((KafkaDao)((KafkaDaoSupplier)kafkaDaoSupplier).get()).clusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(ConsumerOffsetsDaoSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (ConsumerOffsetsDaoSupplier)() -> {
                        try {
                            if (!ClusterConverter.this.permissionsService.hasViewAccess(PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()), clusterId)) {
                                throw new ForbiddenException("must have view access");
                            }
                            Credential credential = Credential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()));
                            return new ConsumerOffsetsDao(clusterId, ClusterConverter.this.adminClientSupplier.getClient(credential), ClusterConverter.this.cachingConsumerSupplier.getConsumer(credential));
                        }
                        catch (IllegalArgumentException iae) {
                            throw new NotFoundException("unable to locate cluster " + clusterId);
                        }
                    };
                }

                public String toString(T consumerOffsetsDaoSupplier) {
                    return ((ConsumerOffsetsDao)((ConsumerOffsetsDaoSupplier)consumerOffsetsDaoSupplier).get()).clusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(BrokerMetricsCluster.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    if (!ClusterConverter.this.permissionsService.hasBrokerMetricsAccess(PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()), clusterId)) {
                        throw new ForbiddenException("must have broker metrics access");
                    }
                    return new BrokerMetricsCluster(clusterId);
                }

                public String toString(T brokerMetricsCluster) {
                    return ((BrokerMetricsCluster)brokerMetricsCluster).getClusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(VisibleCluster.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    if (!ClusterConverter.this.permissionsService.hasViewAccess(PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()), clusterId)) {
                        throw new ForbiddenException("must have view access");
                    }
                    return new VisibleCluster(clusterId);
                }

                public String toString(T visibleCluster) {
                    return ((VisibleCluster)visibleCluster).getClusterId();
                }
            };
        }
        return null;
    }
}

