/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.connect.ConnectClusterManager;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilter;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.PATCH;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import io.confluent.controlcenter.rest.res.KafkaClusterListResponse;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/2.0/clusters/")
@Produces(value={"application/json"})
public class ClusterResource {
    private static final Logger log = LoggerFactory.getLogger(ClusterResource.class);
    private final ClusterMetadataDao clusterMetadata;
    private final ControlCenterConfig controlCenterConfig;
    private final KsqlClusterMetadata ksqlClusterMetadata;
    private final ConnectClusterManager connectClusterManager;
    private final List<String> schemaRegistryUrls;
    @Context
    private ScopedServiceVisibilityFilter scopedServiceVisibilityFilter;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public ClusterResource(ClusterMetadataDao clusterMetadata, ControlCenterConfig controlCenterConfig, KsqlClusterMetadata ksqlClusterMetadata, ConnectClusterManager connectClusterManager, @RestModule.SchemaRegistry List<String> schemaRegistryUrls) {
        this.clusterMetadata = clusterMetadata;
        this.controlCenterConfig = controlCenterConfig;
        this.ksqlClusterMetadata = ksqlClusterMetadata;
        this.connectClusterManager = connectClusterManager;
        this.schemaRegistryUrls = schemaRegistryUrls;
    }

    @GET
    @Path(value="/connect")
    public List<ConnectCluster> connectClusters() {
        return this.scopedServiceVisibilityFilter.filterConnectClusters(this.connectClusterManager.getConnectClusters());
    }

    @GET
    @Path(value="/ksql")
    public List<KsqlCluster> ksqlClusters() {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.ksql.enable").booleanValue()) {
            return null;
        }
        return this.scopedServiceVisibilityFilter.filterKsqlClusters(this.ksqlClusterMetadata.getKsqlClusters());
    }

    @GET
    @Path(value="/schema-registry")
    public List<SchemaRegistryCluster> schemaRegistryClusters() {
        if (this.schemaRegistryUrls.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scopedServiceVisibilityFilter.filterSchemaRegistryClusters((List<SchemaRegistryCluster>)ImmutableList.of((Object)new SchemaRegistryCluster(Hashing.sha1().hashString((CharSequence)ConfigUtils.toString(this.schemaRegistryUrls), Charsets.UTF_8).toString(), "Schema Registry", this.schemaRegistryUrls)));
    }

    @GET
    @Path(value="/kafka")
    public List<KafkaCluster> kafka() {
        List<KafkaCluster> clusters = this.clusterMetadata.getKafkaClusters();
        ArrayList<KafkaCluster> result = new ArrayList<KafkaCluster>();
        for (KafkaCluster cluster : clusters) {
            if (!this.scopedPermissions.hasViewAccess(cluster.clusterId)) continue;
            result.add(new KafkaCluster(cluster.clusterId, cluster.displayName, cluster.zookeeperConnect, cluster.bootstrapServers));
        }
        return result;
    }

    @GET
    @Path(value="/kafka/display/{context}")
    public KafkaClusterListResponse kafkaDisplay(@PathParam(value="context") String contextStr) {
        Controlcenter.ClusterContext context;
        String contextName = contextStr.toUpperCase().replace('-', '_');
        try {
            context = Controlcenter.ClusterContext.valueOf((String)contextName);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException();
        }
        switch (context) {
            case STREAM_MONITORING: {
                return this.filteredKafkaClusterList(this.clusterMetadata.getKafkaClustersForStreamMonitoring());
            }
            case CLUSTER_MANAGEMENT: {
                return this.filteredKafkaClusterList(this.clusterMetadata.getKafkaClustersForManagement());
            }
        }
        return new KafkaClusterListResponse(null, Collections.emptyList());
    }

    @PATCH
    @Path(value="/kafka/{clusterId}")
    @Consumes(value={"application/merge-patch+json"})
    public void patchKafka(@PathParam(value="clusterId") String clusterId, KafkaCluster updatedCluster) throws Exception {
        if (updatedCluster.clusterId != null && !updatedCluster.clusterId.equals(clusterId)) {
            throw new BadRequestException("The provided clusterId does not match the resource.");
        }
        log.info("Updating metadata for cluster {}: {}", (Object)clusterId, (Object)updatedCluster);
        try {
            this.clusterMetadata.externalUpdateKafkaCluster(clusterId, updatedCluster, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (Exception e) {
            log.error("Error updating cluster {}", (Object)clusterId, (Object)e);
            throw e;
        }
    }

    private KafkaClusterListResponse filteredKafkaClusterList(KafkaClusterListResponse listResponse) {
        ArrayList<KafkaClusterDisplay> filteredClusters = new ArrayList<KafkaClusterDisplay>();
        for (KafkaClusterDisplay cluster : listResponse.clusters) {
            if (!this.scopedPermissions.hasViewAccess(cluster.clusterId)) continue;
            filteredClusters.add(cluster);
        }
        return new KafkaClusterListResponse(listResponse.defaultClusterId, filteredClusters);
    }
}

