/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.connect.ConnectClusterManager;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.rest.ProxyServlet;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import java.util.Random;

public class ConnectProxyServlet
extends AbstractClusterLookupProxyServlet {
    private final Random random = new Random();
    private final ConnectClusterManager connectClusterManager;

    @Inject
    public ConnectProxyServlet(ConnectClusterManager connectClusterManager) {
        this.connectClusterManager = connectClusterManager;
    }

    @Override
    public String lookupEndpoint(String connectClusterName) {
        ConnectCluster connectCluster = this.connectClusterManager.getConnectCluster(connectClusterName);
        if (connectCluster != null && connectCluster.urls != null && connectCluster.urls.size() > 0) {
            return ProxyServlet.normalizeUrlProtocol(connectCluster.urls.get(this.random.nextInt(connectCluster.urls.size())));
        }
        return null;
    }
}

