/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.Message;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.data.MetadataServiceClient;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.data.ScopedKafkaMetadataDao;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilter;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilterFactory;
import io.confluent.controlcenter.data.ServiceVisibilityFilter;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.AlertsResource;
import io.confluent.controlcenter.rest.AuthResource;
import io.confluent.controlcenter.rest.CachedConsumerOffsetsResource;
import io.confluent.controlcenter.rest.ClusterConverter;
import io.confluent.controlcenter.rest.ClusterResource;
import io.confluent.controlcenter.rest.CommandResource;
import io.confluent.controlcenter.rest.ConnectProxyServlet;
import io.confluent.controlcenter.rest.ConsumerResource;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.FeatureFlagResource;
import io.confluent.controlcenter.rest.HealthCheckResource;
import io.confluent.controlcenter.rest.InvalidLicenseExceptionMapper;
import io.confluent.controlcenter.rest.KafkaExceptionMapper;
import io.confluent.controlcenter.rest.KafkaResource;
import io.confluent.controlcenter.rest.KsqlProxyServlet;
import io.confluent.controlcenter.rest.LicenseManagerNotEnabledExceptionMapper;
import io.confluent.controlcenter.rest.LicenseResource;
import io.confluent.controlcenter.rest.MessageDeliveryResource;
import io.confluent.controlcenter.rest.MetadataProxyServlet;
import io.confluent.controlcenter.rest.MetricsResource;
import io.confluent.controlcenter.rest.PermissionsResource;
import io.confluent.controlcenter.rest.ReadOnlyRolesFilter;
import io.confluent.controlcenter.rest.RestSecuritySetup;
import io.confluent.controlcenter.rest.SchemaRegistryProxyServlet;
import io.confluent.controlcenter.rest.ScopedKafkaMetadataDaoFactory;
import io.confluent.controlcenter.rest.ScopedPermissionsFactory;
import io.confluent.controlcenter.rest.SerializationExceptionMapper;
import io.confluent.controlcenter.rest.StatusResource;
import io.confluent.controlcenter.rest.jackson.KafkaModule;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import io.confluent.serializers.ProtoSerde;
import io.confluent.serializers.UberSerde;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.ext.ContextResolver;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterApplication
extends Application<RestConfig> {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterApplication.class);
    public static final String KSQL_PATH = "/api/ksql/*";
    public static final String SR_PATH = "/api/schema-registry/*";
    public static final String MDS_PATH = "/api/metadata/*";
    public static final String X_CONFLUENT_CONTROL_CENTER_VERSION_HEADER = "X-Confluent-Control-Center-Version";
    public static final String X_FRAME_OPTIONS = "X-Frame-Options";
    protected static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    protected static final String STRICT_TRANSPORT_SECURITY_VALUE = "max-age=31536000";
    private final ControlCenterConfig controlCenterConfig;
    private final MessageDeliveryResource messageDeliveryResource;
    private final KafkaResource kafkaResource;
    private final LicenseResource licenseResource;
    private final StatusResource statusResource;
    private final com.github.zafarkhaja.semver.Version version;
    private final AuthResource authResource;
    private final AlertsResource alertsResource;
    private final CommandResource commandResource;
    private final FeatureFlagResource featureFlagResource;
    private final Provider<ConsumerResource> consumerResourceProvider;
    private final ClusterResource clusterResource;
    private final MetricsResource metricsResource;
    private final HealthCheckResource healthCheckResource;
    private final CachedConsumerOffsetsResource cachedConsumerOffsetsResource;
    private final UberSerde<Alert.AlertInfo> alertInfoUberSerde;
    private final UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde;
    private final UberSerde<CommandAlert.MonitoringTriggerConfig> monitoringTriggerConfigUberSerde;
    private final UberSerde<CommandAlert.ActionConfig> actionConfigUberSerde;
    private final ClusterConverter clusterConverter;
    private final KafkaExceptionMapper kafkaExceptionMapper;
    private final Collection<String> readOnlyRoles;
    private final KsqlProxyServlet ksqlProxyServlet;
    private final ConnectProxyServlet connectProxyServlet;
    private final SchemaRegistryProxyServlet srProxyServlet;
    private final MetadataProxyServlet metadataProxyServlet;
    private final RestSecuritySetup restSecuritySetup;
    private final PermissionsResource permissionsResource;
    private final MetadataServiceClient metadataServiceClient;
    private final ServiceVisibilityFilter serviceVisibilityFilter;
    private final PermissionsService permissionsService;
    private final KafkaMetadataDao kafkaMetadataDao;

    @Inject
    public ControlCenterApplication(RestConfig config, ControlCenterConfig controlCenterConfig, FeatureFlagResource featureFlagResource, AlertsResource alertsResource, KafkaResource kafkaResource, ClusterResource clusterResource, MessageDeliveryResource messageDeliveryResource, LicenseResource licenseResource, StatusResource statusResource, AuthResource authResource, MetricsResource metricsResource, com.github.zafarkhaja.semver.Version version, CommandResource commandResource, Provider<ConsumerResource> consumerResourceProvider, HealthCheckResource healthCheckResource, CachedConsumerOffsetsResource cachedConsumerOffsetsResource, UberSerde<Alert.AlertInfo> alertInfoUberSerde, UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde, UberSerde<CommandAlert.MonitoringTriggerConfig> monitoringTriggerConfigUberSerde, UberSerde<CommandAlert.ActionConfig> actionConfigUberSerde, ClusterConverter clusterConverter, KafkaExceptionMapper kafkaExceptionMapper, @ControlCenterRestModule.RestrictedRoles Collection<String> readOnlyRoles, KsqlProxyServlet ksqlProxyServlet, SchemaRegistryProxyServlet srProxyServlet, MetadataProxyServlet metadataProxyServlet, ConnectProxyServlet connectProxyServlet, RestSecuritySetup restSecuritySetup, PermissionsResource permissionsResource, @Nullable MetadataServiceClient metadataServiceClient, ServiceVisibilityFilter serviceVisibilityFilter, PermissionsService permissionsService, KafkaMetadataDao kafkaMetadataDao) {
        super(config);
        this.controlCenterConfig = controlCenterConfig;
        this.alertsResource = alertsResource;
        this.featureFlagResource = featureFlagResource;
        this.kafkaResource = kafkaResource;
        this.clusterResource = clusterResource;
        this.messageDeliveryResource = messageDeliveryResource;
        this.licenseResource = licenseResource;
        this.statusResource = statusResource;
        this.authResource = authResource;
        this.metricsResource = metricsResource;
        this.healthCheckResource = healthCheckResource;
        this.cachedConsumerOffsetsResource = cachedConsumerOffsetsResource;
        this.version = version;
        this.commandResource = commandResource;
        this.consumerResourceProvider = consumerResourceProvider;
        this.alertInfoUberSerde = alertInfoUberSerde;
        this.triggerMeasurementUberSerde = triggerMeasurementUberSerde;
        this.monitoringTriggerConfigUberSerde = monitoringTriggerConfigUberSerde;
        this.actionConfigUberSerde = actionConfigUberSerde;
        this.clusterConverter = clusterConverter;
        this.kafkaExceptionMapper = kafkaExceptionMapper;
        this.readOnlyRoles = readOnlyRoles;
        this.ksqlProxyServlet = ksqlProxyServlet;
        this.connectProxyServlet = connectProxyServlet;
        this.srProxyServlet = srProxyServlet;
        this.metadataProxyServlet = metadataProxyServlet;
        this.restSecuritySetup = restSecuritySetup;
        this.permissionsResource = permissionsResource;
        this.metadataServiceClient = metadataServiceClient;
        this.serviceVisibilityFilter = serviceVisibilityFilter;
        this.permissionsService = permissionsService;
        this.kafkaMetadataDao = kafkaMetadataDao;
    }

    protected ResourceCollection getStaticResources() {
        return new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"io/confluent/controlcenter/rest/static")});
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
        if ("BASIC".equals(this.config.getString("authentication.method"))) {
            context.addFilter(new FilterHolder((Filter)new ReadOnlyRolesFilter(this.readOnlyRoles)), "/*", null);
        }
    }

    protected void configurePostResourceHandling(ServletContextHandler context) {
        long authTimeout = this.controlCenterConfig.getLong("confluent.controlcenter.auth.session.expiration.ms");
        if (authTimeout > 0L) {
            context.getSessionHandler().setMaxInactiveInterval((int)TimeUnit.SECONDS.toSeconds(authTimeout));
        }
        context.addFilter(new FilterHolder(new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                String path;
                ((HttpServletResponse)response).setHeader(ControlCenterApplication.X_CONFLUENT_CONTROL_CENTER_VERSION_HEADER, ControlCenterApplication.this.version.toString());
                if (ControlCenterApplication.this.controlCenterConfig.getBoolean("confluent.controlcenter.rest.hsts.enable").booleanValue()) {
                    ((HttpServletResponse)response).setHeader(ControlCenterApplication.STRICT_TRANSPORT_SECURITY_HEADER, ControlCenterApplication.STRICT_TRANSPORT_SECURITY_VALUE);
                }
                if ((path = ((HttpServletRequest)request).getRequestURI()).equals("/") || path.startsWith("/dist/") || path.startsWith("/api/")) {
                    chain.doFilter(request, response);
                } else {
                    request.getRequestDispatcher("/").forward(request, response);
                }
                ((HttpServletResponse)response).setHeader(ControlCenterApplication.X_FRAME_OPTIONS, "SAMEORIGIN");
            }

            public void destroy() {
            }
        }), "/*", null);
        this.configureProxyServlets(context);
        this.configureErrorHandler(context);
    }

    private void configureProxyServlets(ServletContextHandler context) {
        context.addServlet(new ServletHolder((Servlet)this.connectProxyServlet), "/api/connect/*");
        if (this.controlCenterConfig.getBoolean("confluent.controlcenter.ksql.enable").booleanValue()) {
            context.addServlet(new ServletHolder((Servlet)this.ksqlProxyServlet), KSQL_PATH);
            this.ksqlProxyServlet.buildKsqlEndpointLookupTable();
        }
        if (this.controlCenterConfig.getBoolean("confluent.controlcenter.schema.registry.enable").booleanValue()) {
            context.addServlet(new ServletHolder((Servlet)this.srProxyServlet), SR_PATH);
        }
        if (this.metadataServiceClient != null) {
            context.addServlet(new ServletHolder((Servlet)this.metadataProxyServlet), MDS_PATH);
        }
        this.setSslContextFactory();
        this.setRequestBufferSize();
    }

    private void setSslContextFactory() {
        if (this.getSslContextFactory() != null) {
            this.ksqlProxyServlet.setSslContextFactory(this.getSslContextFactory());
            this.connectProxyServlet.setSslContextFactory(this.getSslContextFactory());
            this.srProxyServlet.setSslContextFactory(this.getSslContextFactory());
            this.metadataProxyServlet.setSslContextFactory(this.getSslContextFactory());
            if (this.metadataServiceClient != null) {
                this.metadataServiceClient.setSslContextFactory(this.getSslContextFactory());
            }
            this.serviceVisibilityFilter.setSslContextFactory(this.getSslContextFactory());
        }
    }

    private void setRequestBufferSize() {
        int reqBufferSize = this.controlCenterConfig.getInt("confluent.controlcenter.request.buffer.size.bytes");
        this.ksqlProxyServlet.setRequestBufferSize(reqBufferSize);
        this.connectProxyServlet.setRequestBufferSize(reqBufferSize);
        this.srProxyServlet.setRequestBufferSize(reqBufferSize);
        this.metadataProxyServlet.setRequestBufferSize(reqBufferSize);
    }

    private void configureErrorHandler(ServletContextHandler context) {
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(false);
        context.setErrorHandler(errorHandler);
    }

    @VisibleForTesting
    URI getServerUri() {
        return this.server.getURI();
    }

    protected void registerWebSocketEndpoints(ServerContainer container) {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.topic.inspection.enable").booleanValue()) {
            return;
        }
        try {
            log.debug("adding consumer endpoint");
            container.addEndpoint(ServerEndpointConfig.Builder.create(ConsumerResource.class, (String)ConsumerResource.class.getAnnotation(ServerEndpoint.class).value()).configurator(new ServerEndpointConfig.Configurator(){

                public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                    return (T)ControlCenterApplication.this.consumerResourceProvider.get();
                }
            }).encoders(Arrays.asList(ConsumerResource.class.getAnnotation(ServerEndpoint.class).encoders())).build());
        }
        catch (DeploymentException e) {
            log.error("unable to deploy websocket endpoints", (Throwable)e);
        }
    }

    protected void configureSecurityHandler(ServletContextHandler context) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        if (this.restSecuritySetup.getRealm() != null) {
            securityHandler.addConstraintMapping(AuthUtil.createSecuredConstraint((RestConfig)this.config, (String)"/2.0/*"));
            securityHandler.addConstraintMapping(AuthUtil.createSecuredConstraint((RestConfig)this.config, (String)"/3.0/*"));
            securityHandler.addConstraintMapping(AuthUtil.createSecuredConstraint((RestConfig)this.config, (String)"/api/*"));
            securityHandler.addConstraintMapping(AuthUtil.createUnsecuredConstraint((RestConfig)this.config, (String)MDS_PATH));
            securityHandler.addConstraintMapping(AuthUtil.createUnsecuredConstraint((RestConfig)this.config, (String)"/2.0/feature/flags"));
        }
        securityHandler.setRealmName(this.restSecuritySetup.getRealm());
        securityHandler.setAuthenticator((Authenticator)this.restSecuritySetup.getAuthenticator());
        securityHandler.setLoginService(this.restSecuritySetup.getLoginService());
        securityHandler.setIdentityService(this.restSecuritySetup.getIdentityService());
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        context.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public void setupResources(Configurable<?> config, RestConfig appConfig) {
        config.register((Object)this.alertsResource);
        config.register((Object)this.featureFlagResource);
        config.register((Object)this.kafkaResource);
        config.register((Object)this.clusterResource);
        config.register((Object)this.licenseResource);
        config.register((Object)this.messageDeliveryResource);
        config.register((Object)this.statusResource);
        config.register((Object)this.authResource);
        config.register((Object)this.commandResource);
        config.register((Object)this.metricsResource);
        config.register((Object)this.healthCheckResource);
        config.register((Object)this.cachedConsumerOffsetsResource);
        config.register((Object)this.permissionsResource);
        config.register(JsonMappingExceptionMapper.class);
        config.register((Object)new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return ControlCenterApplication.this.getJsonMapper();
            }
        });
        config.register((Object)new SerializationExceptionMapper());
        config.register((Object)new InvalidLicenseExceptionMapper(this.licenseResource.getLicenseInfo()));
        config.register((Object)new LicenseManagerNotEnabledExceptionMapper());
        config.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bindFactory(ScopedPermissionsFactory.class).to(ScopedPermissions.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bind(ControlCenterApplication.this.permissionsService).to(PermissionsService.class);
                this.bindFactory(ScopedKafkaMetadataDaoFactory.class).to(ScopedKafkaMetadataDao.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bind(ControlCenterApplication.this.kafkaMetadataDao).to(KafkaMetadataDao.class);
                this.bindFactory(ScopedServiceVisibilityFilterFactory.class).to(ScopedServiceVisibilityFilter.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bind(ControlCenterApplication.this.serviceVisibilityFilter).to(ServiceVisibilityFilter.class);
            }
        });
        config.register((Object)new ContainerResponseFilter(){

            public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
                responseContext.getHeaders().add((Object)ControlCenterApplication.X_CONFLUENT_CONTROL_CENTER_VERSION_HEADER, (Object)ControlCenterApplication.this.version.toString());
                if (ControlCenterApplication.this.controlCenterConfig.getBoolean("confluent.controlcenter.rest.hsts.enable").booleanValue()) {
                    responseContext.getHeaders().add((Object)ControlCenterApplication.STRICT_TRANSPORT_SECURITY_HEADER, (Object)ControlCenterApplication.STRICT_TRANSPORT_SECURITY_VALUE);
                }
                responseContext.getHeaders().add((Object)ControlCenterApplication.X_FRAME_OPTIONS, (Object)"SAMEORIGIN");
            }
        });
        config.property("jersey.config.servlet.filter.staticContentRegex", (Object)"^/(?!(2.0/|3.0/|api/permissions)).*");
        config.register((Object)this.clusterConverter);
        config.register((Object)this.kafkaExceptionMapper);
    }

    protected ObjectMapper getJsonMapper() {
        ObjectMapper om = super.getJsonMapper();
        SimpleModule module = new SimpleModule("ProtoJsonSerializerModule", new Version(0, 1, 0, "alpha"));
        module.addSerializer(Alert.AlertInfo.class, (JsonSerializer)new JsonSerializer<Alert.AlertInfo>(){

            public void serialize(Alert.AlertInfo value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ControlCenterApplication.this.alertInfoUberSerde.toJson((Object)value));
            }

            public Class<Alert.AlertInfo> handledType() {
                return Alert.AlertInfo.class;
            }
        });
        module.addSerializer(Controlcenter.TriggerMeasurement.class, (JsonSerializer)new JsonSerializer<Controlcenter.TriggerMeasurement>(){

            public void serialize(Controlcenter.TriggerMeasurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ControlCenterApplication.this.triggerMeasurementUberSerde.toJson((Object)value));
            }

            public Class<Controlcenter.TriggerMeasurement> handledType() {
                return Controlcenter.TriggerMeasurement.class;
            }
        });
        module.addSerializer(Command.CommandMessage.class, (JsonSerializer)new JsonSerializer<Command.CommandMessage>(){
            final ProtoSerde<Command.CommandMessage> commandMessageProtoSerde = new ProtoSerde((Message)Command.CommandMessage.getDefaultInstance());

            public void serialize(Command.CommandMessage value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(this.commandMessageProtoSerde.toJson((Message)value));
            }
        });
        module.addDeserializer(Command.CommandMessage.class, new UberJsonDeserializer(new ProtoSerde((Message)Command.CommandMessage.getDefaultInstance())));
        module.addSerializer(CommandAlert.MonitoringTriggerConfig.class, (JsonSerializer)new JsonSerializer<CommandAlert.MonitoringTriggerConfig>(){

            public void serialize(CommandAlert.MonitoringTriggerConfig value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ControlCenterApplication.this.monitoringTriggerConfigUberSerde.toJson((Object)value));
            }

            public Class<CommandAlert.MonitoringTriggerConfig> handledType() {
                return CommandAlert.MonitoringTriggerConfig.class;
            }
        });
        module.addDeserializer(CommandAlert.MonitoringTriggerConfig.class, new UberJsonDeserializer<CommandAlert.MonitoringTriggerConfig>(this.monitoringTriggerConfigUberSerde));
        module.addSerializer(CommandAlert.ActionConfig.class, (JsonSerializer)new JsonSerializer<CommandAlert.ActionConfig>(){

            public void serialize(CommandAlert.ActionConfig value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ControlCenterApplication.this.actionConfigUberSerde.toJson((Object)value));
            }

            public Class<CommandAlert.ActionConfig> handledType() {
                return CommandAlert.ActionConfig.class;
            }
        });
        module.addDeserializer(CommandAlert.ActionConfig.class, new UberJsonDeserializer<CommandAlert.ActionConfig>(this.actionConfigUberSerde));
        module.addSerializer(Command.CommandKey.class, (JsonSerializer)new JsonSerializer<Command.CommandKey>(){
            private final UberSerde<Command.CommandKey> commandKeySerde = new ProtoSerde((Message)Command.CommandKey.getDefaultInstance());

            public void serialize(Command.CommandKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(this.commandKeySerde.toJson((Object)value));
            }

            public Class<Command.CommandKey> handledType() {
                return Command.CommandKey.class;
            }
        });
        om.registerModule((Module)module);
        om.registerModule((Module)new KafkaModule());
        return om;
    }

    static class UberJsonDeserializer<K>
    extends JsonDeserializer<K> {
        private final UberSerde<K> serde;

        UberJsonDeserializer(UberSerde<K> serde) {
            this.serde = serde;
        }

        public K deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            SegmentedStringWriter writer = new SegmentedStringWriter(new BufferRecycler());
            JsonGenerator generator = jsonParser.getCodec().getFactory().createGenerator((Writer)writer);
            generator.copyCurrentStructure(jsonParser);
            generator.close();
            return (K)this.serde.deserialize(this.serde.fromJson(writer.getAndClear()));
        }
    }
}

