/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.MoreObjects;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.rest.ClusterMatched;
import java.security.Principal;
import java.util.Objects;

public class Credential
implements ClusterMatched {
    public final String cluster;
    public final String token;
    public final String subject;

    private Credential(String cluster, String token, String subject) {
        this.cluster = cluster;
        this.token = token;
        this.subject = subject;
    }

    public static Credential makeCredential(String clusterId) {
        return new Credential(clusterId, null, null);
    }

    public static Credential makeCredentialFromJwtOrNullPrincipal(String clusterId, Principal principal) {
        if (!(principal instanceof JwtPrincipal)) {
            return Credential.makeCredential(clusterId);
        }
        JwtPrincipal p = (JwtPrincipal)principal;
        return new Credential(clusterId, p.getJwt(), p.getName());
    }

    public static Credential makeCredentialFromJwtPrincipal(String clusterId, Principal principal) {
        JwtPrincipal pr = (JwtPrincipal)principal;
        if (pr == null) {
            throw new IllegalArgumentException("invalid token");
        }
        return new Credential(clusterId, pr.getJwt(), pr.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential that = (Credential)o;
        return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.token, that.token) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.token, this.subject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("token", (Object)this.token).add("subject", (Object)this.subject).toString();
    }

    @Override
    public boolean matchesCluster(String clusterId) {
        return this.cluster.equals(clusterId);
    }
}

