/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.healthcheck.HealthCheck;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/2.0/health")
@Produces(value={"application/json"})
public class HealthCheckResource {
    private final HealthCheck healthCheck;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public HealthCheckResource(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    @GET
    @Path(value="/status")
    public Map<String, Object> status() {
        HashMap<String, Object> statusMap = new HashMap<String, Object>();
        statusMap.put("bootstrapClusterId", this.healthCheck.getBootstrapClusterId());
        statusMap.put("clusterStatus", this.filteredKafkaClusterMap(this.healthCheck.getAllClusterStatus()));
        return statusMap;
    }

    private <T> Map<String, T> filteredKafkaClusterMap(Map<String, T> clusterMap) {
        HashMap<String, T> filteredClusters = new HashMap<String, T>();
        for (Map.Entry<String, T> e : clusterMap.entrySet()) {
            if (!this.scopedPermissions.hasViewAccess(e.getKey())) continue;
            filteredClusters.put(e.getKey(), e.getValue());
        }
        return ImmutableMap.copyOf(filteredClusters);
    }
}

