/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.DelegationTokenAuthorizationException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExceptionMapper
implements ExceptionMapper<ExecutionException> {
    private static final Logger log = LoggerFactory.getLogger(KafkaExceptionMapper.class);
    private static final Map<Class<? extends ApiException>, Response.Status> HANDLED = ImmutableMap.builder().put(AuthenticationException.class, (Object)Response.Status.FORBIDDEN).put(SaslAuthenticationException.class, (Object)Response.Status.FORBIDDEN).put(AuthorizationException.class, (Object)Response.Status.FORBIDDEN).put(ClusterAuthorizationException.class, (Object)Response.Status.FORBIDDEN).put(DelegationTokenAuthorizationException.class, (Object)Response.Status.FORBIDDEN).put(GroupAuthorizationException.class, (Object)Response.Status.FORBIDDEN).put(TopicAuthorizationException.class, (Object)Response.Status.FORBIDDEN).put(TransactionalIdAuthorizationException.class, (Object)Response.Status.FORBIDDEN).put(BrokerNotAvailableException.class, (Object)Response.Status.SERVICE_UNAVAILABLE).put(InvalidReplicationFactorException.class, (Object)Response.Status.BAD_REQUEST).put(SecurityDisabledException.class, (Object)Response.Status.BAD_REQUEST).put(UnsupportedVersionException.class, (Object)Response.Status.BAD_REQUEST).put(InvalidPartitionsException.class, (Object)Response.Status.BAD_REQUEST).put(InvalidRequestException.class, (Object)Response.Status.BAD_REQUEST).put(UnknownServerException.class, (Object)Response.Status.BAD_REQUEST).put(UnknownTopicOrPartitionException.class, (Object)Response.Status.NOT_FOUND).put(PolicyViolationException.class, (Object)Response.Status.BAD_REQUEST).put(TopicExistsException.class, (Object)Response.Status.BAD_REQUEST).put(InvalidConfigurationException.class, (Object)Response.Status.BAD_REQUEST).build();
    private static final Pattern INVALID_CONFIG_PATTERN = Pattern.compile(".*Invalid value (\\S+) for configuration (\\S+): (.*)");
    private static final Pattern UNKNOWN_CONFIG_PATTERN = Pattern.compile(".*Unknown topic config name: (\\S*)");
    private static final Pattern POLICY_FOR_TOPIC_REPLICATION = Pattern.compile(".*Topic replication factor must be (\\S+)");
    private static final Pattern POLICY_FOR_MAX_PARTITIONS = Pattern.compile(".*You may not create more than .* partitions .*");
    private static final Pattern POLICY_FOR_INVALID_CONFIG_PATTERN = Pattern.compile(".*Topic config '(\\S+)' must be (\\S+)");

    static String fieldForPolicyViolation(String message) {
        String field = "unknown";
        Matcher matcher = POLICY_FOR_TOPIC_REPLICATION.matcher(message);
        if (matcher.matches()) {
            field = "replicationFactor";
        } else if (POLICY_FOR_MAX_PARTITIONS.matcher(message).matches()) {
            field = "numPartitions";
        } else {
            matcher = POLICY_FOR_INVALID_CONFIG_PATTERN.matcher(message);
            if (matcher.matches()) {
                field = matcher.group(1);
            }
        }
        return field;
    }

    static boolean isName(Throwable cause) {
        return cause instanceof UnknownTopicOrPartitionException || cause instanceof TopicExistsException;
    }

    static boolean isInvalidConfig(Throwable cause) {
        return cause instanceof UnknownServerException || cause instanceof InvalidRequestException || cause instanceof InvalidConfigurationException;
    }

    public Response toResponse(ExecutionException exception) {
        Throwable cause = exception.getCause();
        if (cause != null && HANDLED.containsKey(cause.getClass())) {
            String field = "unknown";
            String message = cause.getMessage();
            if (cause instanceof PolicyViolationException) {
                field = KafkaExceptionMapper.fieldForPolicyViolation(message);
            } else if (cause instanceof InvalidReplicationFactorException) {
                field = "replicationFactor";
            } else if (cause instanceof InvalidPartitionsException) {
                field = "numPartitions";
            } else if (KafkaExceptionMapper.isName(cause)) {
                field = "name";
            } else if (KafkaExceptionMapper.isInvalidConfig(cause)) {
                Matcher matcher = INVALID_CONFIG_PATTERN.matcher(message);
                if (matcher.matches()) {
                    field = matcher.group(2);
                    message = matcher.group(3);
                } else {
                    matcher = UNKNOWN_CONFIG_PATTERN.matcher(message);
                    if (matcher.matches()) {
                        field = matcher.group(1);
                        message = "unknown field";
                    }
                }
            }
            return Response.status((Response.Status)HANDLED.get(cause.getClass())).entity((Object)ImmutableMap.builder().put((Object)"field", (Object)field).put((Object)"message", (Object)message).build()).build();
        }
        log.error("Unhandled Kafka exception", cause);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)cause).build();
    }
}

